/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine.rbmk;

import com.hbm.api.Mode;
import com.hbm.block.machine.rbmk.BlockRBMKControlRod;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.base2.BaseMachineBlockEntity;
import com.hbm.blockentity.machine.rbmk.RBMKBaseEntity;
import com.hbm.gui.menu.RBMKControlRodMenu;
import com.hbm.item.rbmk.ItemRBMKControlRod;
import com.hbm.reactor.rbmk.RBMKColumnState;
import com.hbm.reactor.rbmk.RBMKLevelContext;
import com.hbm.reactor.rbmk.RBMKManager;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class RBMKControlRodEntity
extends BaseMachineBlockEntity {
    private static final int CONTROL_ROD_SLOT = 0;
    private static final int SLOT_COUNT = 1;
    private static final int AZ5_LOCK_TICKS = 60;
    private static final int DATA_LENGTH = 14;
    private static final float CONTROL_SPEED = 0.00277f;
    private static final String TAG_LEVEL = "ControlLevel";
    private static final String TAG_TARGET = "TargetLevel";
    private static final String TAG_COLOR = "ControlColor";
    private final ContainerData containerData = new SimpleContainerData(14);
    private final int[] dataSlots = new int[14];
    private float currentLevel;
    private float targetLevel;
    private int az5CooldownTicks;
    private ControlGroup selectedGroup;

    public RBMKControlRodEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityType.RBMK_CONTROL_ROD_ENTITY.get(), pos, state);
        this.items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
        this.slotModes = List.of(Mode.BOTH);
        this.targetLevel = this.currentLevel = this.deriveInsertionFromState();
    }

    public void serverTick() {
        RBMKBaseEntity rbmkBase;
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean hasRod = this.hasControlRod();
        if (!hasRod) {
            if (!Mth.m_14033_((float)this.currentLevel, (float)0.0f)) {
                this.forceLevel(0.0f);
            } else {
                this.syncBlockStateFromLevel();
            }
            if (!Mth.m_14033_((float)this.targetLevel, (float)0.0f)) {
                this.setTargetLevel(0.0f);
            }
        } else {
            this.stepTowardsTarget();
        }
        BlockPos corePos = this.f_58858_.m_7495_();
        RBMKLevelContext context = RBMKManager.context(serverLevel);
        context.setControlRodInsertion(corePos, this.currentLevel);
        BlockEntity blockEntity = this.f_58857_.m_7702_(corePos);
        RBMKBaseEntity base = blockEntity instanceof RBMKBaseEntity ? (rbmkBase = (RBMKBaseEntity)blockEntity) : null;
        Optional<RBMKColumnState> column = context.column(corePos);
        this.updateClientData(column.orElse(null), base, context);
    }

    private void updateClientData(@Nullable RBMKColumnState column, @Nullable RBMKBaseEntity base, RBMKLevelContext context) {
        this.dataSlots[0] = column != null ? (int)Math.round(column.heat() * 10.0) : 0;
        this.dataSlots[1] = column != null ? (int)Math.round(column.settings().meltdownHeat() * 10.0) : 0;
        this.dataSlots[2] = base != null ? (int)Math.min(Integer.MAX_VALUE, base.getEnergyStored()) : 0;
        this.dataSlots[3] = base != null ? (int)Math.min(Integer.MAX_VALUE, base.getEnergyCapacity()) : 0;
        this.dataSlots[4] = base != null ? base.getWaterAmount() : 0;
        this.dataSlots[5] = base != null ? base.getSteamAmount() : 0;
        this.dataSlots[6] = column != null ? (int)Math.round(column.controlRodInsertion() * 100.0) : 0;
        this.dataSlots[7] = (int)Math.round(context.controlRodAverage() * 100.0);
        this.dataSlots[8] = (int)Math.round((double)this.currentLevel * 100.0);
        this.dataSlots[9] = RBMKControlRodEntity.fractionToStage(this.currentLevel);
        this.dataSlots[10] = context.snapshot().size();
        if (this.az5CooldownTicks > 0) {
            --this.az5CooldownTicks;
            if (this.az5CooldownTicks == 0) {
                this.m_6596_();
            }
        }
        this.dataSlots[11] = this.az5CooldownTicks;
        this.dataSlots[12] = this.selectedGroup != null ? this.selectedGroup.ordinal() : -1;
        this.dataSlots[13] = this.hasControlRod() ? 1 : 0;
        for (int i = 0; i < this.dataSlots.length; ++i) {
            this.containerData.m_8050_(i, this.dataSlots[i]);
        }
    }

    private void stepTowardsTarget() {
        if (Mth.m_14033_((float)this.currentLevel, (float)this.targetLevel)) {
            this.syncBlockStateFromLevel();
            return;
        }
        float next = this.currentLevel;
        if (this.currentLevel < this.targetLevel) {
            next = Math.min(this.targetLevel, this.currentLevel + 0.00277f);
        } else if (this.currentLevel > this.targetLevel) {
            next = Math.max(this.targetLevel, this.currentLevel - 0.00277f);
        }
        if (!Mth.m_14033_((float)this.currentLevel, (float)next)) {
            this.currentLevel = next;
            this.syncBlockStateFromLevel();
            this.m_6596_();
        }
    }

    public boolean isAz5CoolingDown() {
        return this.az5CooldownTicks > 0;
    }

    public int getAz5CooldownTicks() {
        return this.az5CooldownTicks;
    }

    public void engageAz5() {
        this.az5CooldownTicks = 60;
        this.forceLevel(1.0f);
        this.setTargetLevel(1.0f);
        this.m_6596_();
    }

    public void toggleColorGroup(int index) {
        ControlGroup[] groups = ControlGroup.values();
        if (index < 0 || index >= groups.length) {
            return;
        }
        ControlGroup newGroup = groups[index];
        this.selectedGroup = this.selectedGroup == newGroup ? null : newGroup;
        this.m_6596_();
    }

    public void onChunkUnloaded() {
        this.resetColumn();
        super.onChunkUnloaded();
    }

    public void m_7651_() {
        this.resetColumn();
        super.m_7651_();
    }

    private void resetColumn() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RBMKManager.context(serverLevel).setControlRodInsertion(this.f_58858_.m_7495_(), 0.0);
        }
        this.currentLevel = 0.0f;
        this.targetLevel = 0.0f;
        this.selectedGroup = null;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.currentLevel = Mth.m_14036_((float)tag.m_128457_(TAG_LEVEL), (float)0.0f, (float)1.0f);
        float f = this.targetLevel = tag.m_128441_(TAG_TARGET) ? Mth.m_14036_((float)tag.m_128457_(TAG_TARGET), (float)0.0f, (float)1.0f) : this.currentLevel;
        if (tag.m_128441_("Az5Cooldown")) {
            this.az5CooldownTicks = tag.m_128451_("Az5Cooldown");
        }
        if (tag.m_128441_(TAG_COLOR)) {
            int idx = tag.m_128451_(TAG_COLOR);
            ControlGroup[] groups = ControlGroup.values();
            if (idx >= 0 && idx < groups.length) {
                this.selectedGroup = groups[idx];
            }
        } else {
            this.selectedGroup = null;
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128350_(TAG_LEVEL, this.currentLevel);
        tag.m_128350_(TAG_TARGET, this.targetLevel);
        if (this.az5CooldownTicks > 0) {
            tag.m_128405_("Az5Cooldown", this.az5CooldownTicks);
        }
        if (this.selectedGroup != null) {
            tag.m_128405_(TAG_COLOR, this.selectedGroup.ordinal());
        }
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)"block.hbm.machine_rbmk_control_rod");
    }

    @Override
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new RBMKControlRodMenu(containerId, inventory, (Container)this, this.getContainerData());
    }

    public ContainerData getContainerData() {
        return this.containerData;
    }

    public boolean setInsertionPercent(int percent) {
        return this.setInsertionFraction((double)percent / 100.0);
    }

    public boolean setInsertionFraction(double targetFraction) {
        float clamped = Mth.m_14036_((float)((float)targetFraction), (float)0.0f, (float)1.0f);
        if (this.isAz5CoolingDown() && clamped < 1.0f) {
            return false;
        }
        if (!this.hasControlRod() && clamped > 0.0f) {
            return false;
        }
        this.setTargetLevel(clamped);
        return true;
    }

    private void setTargetLevel(float target) {
        float clamped = Mth.m_14036_((float)target, (float)0.0f, (float)1.0f);
        if (!Mth.m_14033_((float)clamped, (float)this.targetLevel)) {
            this.targetLevel = clamped;
            this.m_6596_();
        }
    }

    public float getInsertionFraction() {
        return this.currentLevel;
    }

    public int getSelectedColorIndex() {
        return this.selectedGroup != null ? this.selectedGroup.ordinal() : -1;
    }

    private void forceLevel(float levelValue) {
        this.targetLevel = this.currentLevel = Mth.m_14036_((float)levelValue, (float)0.0f, (float)1.0f);
        this.syncBlockStateFromLevel();
    }

    private void syncBlockStateFromLevel() {
        if (this.f_58857_ == null) {
            return;
        }
        BlockState state = this.m_58900_();
        if (!state.m_61138_((Property)BlockRBMKControlRod.INSERTION)) {
            return;
        }
        int stage = RBMKControlRodEntity.fractionToStage(this.currentLevel);
        if ((Integer)state.m_61143_((Property)BlockRBMKControlRod.INSERTION) != stage) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)BlockRBMKControlRod.INSERTION, (Comparable)Integer.valueOf(stage)), 3);
        }
    }

    private float deriveInsertionFromState() {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)BlockRBMKControlRod.INSERTION)) {
            return RBMKControlRodEntity.stageToFraction((Integer)state.m_61143_((Property)BlockRBMKControlRod.INSERTION));
        }
        return 0.0f;
    }

    private static int fractionToStage(float fraction) {
        int max = 4;
        if (max <= 0) {
            return 0;
        }
        return Mth.m_14045_((int)Math.round(fraction * (float)max), (int)0, (int)max);
    }

    private static float stageToFraction(int stage) {
        int max = 4;
        if (max <= 0) {
            return 0.0f;
        }
        return Mth.m_14036_((float)((float)stage / (float)max), (float)0.0f, (float)1.0f);
    }

    private boolean hasControlRod() {
        ItemStack stack = (ItemStack)this.items.get(0);
        return RBMKControlRodEntity.isControlRodItem(stack);
    }

    private static boolean isControlRodItem(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41720_() instanceof ItemRBMKControlRod;
    }

    private void onControlRodSlotChanged(ItemStack previous, ItemStack current) {
        boolean has;
        boolean had = RBMKControlRodEntity.isControlRodItem(previous);
        if (had == (has = RBMKControlRodEntity.isControlRodItem(current))) {
            return;
        }
        if (!has) {
            this.forceLevel(0.0f);
            this.setTargetLevel(0.0f);
        } else {
            this.currentLevel = Mth.m_14036_((float)this.targetLevel, (float)0.0f, (float)1.0f);
            this.syncBlockStateFromLevel();
        }
        this.m_6596_();
    }

    @Override
    public void m_6836_(int slot, ItemStack stack) {
        ItemStack previous = slot >= 0 && slot < this.items.size() ? ((ItemStack)this.items.get(slot)).m_41777_() : ItemStack.f_41583_;
        super.m_6836_(slot, stack);
        if (slot == 0) {
            this.onControlRodSlotChanged(previous, stack);
        }
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot == 0) {
            return RBMKControlRodEntity.isControlRodItem(stack);
        }
        return false;
    }

    public static enum ControlGroup {
        RED,
        YELLOW,
        GREEN,
        BLUE,
        PURPLE;

    }
}

