/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine.rbmk;

import com.hbm.HBM;
import com.hbm.api.Mode;
import com.hbm.api.inventory.ModeBuilder;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.base2.BaseMachineBlockEntity;
import com.hbm.blockentity.machine.rbmk.RBMKBaseEntity;
import com.hbm.gui.menu.RBMKFuelChannelMenu;
import com.hbm.item.HBMItems;
import com.hbm.item.rbmk.ItemRBMKFuelRod;
import com.hbm.reactor.rbmk.RBMKColumnState;
import com.hbm.reactor.rbmk.RBMKLevelContext;
import com.hbm.reactor.rbmk.RBMKManager;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RBMKFuelChannelEntity
extends BaseMachineBlockEntity {
    private static final int FUEL_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private static final double TIME_STEP = 0.05;
    private static final int REDSTONE_SIGNAL_ON = 15;
    private static final String TAG_BURN_TIME_REMAINING = "BurnTimeRemaining";
    private static final String TAG_BURN_TIME_TOTAL = "BurnTimeTotal";
    private int burnTimeRemaining;
    private int burnTimeTotal;
    private int lastRedstoneSignal = -1;
    private int lastComparatorSignal = -1;
    private final ContainerData containerData = new SimpleContainerData(12);
    private final int[] dataSlots = new int[12];

    public RBMKFuelChannelEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityType.RBMK_FUEL_CHANNEL_ENTITY.get(), pos, state);
        this.items = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
        this.slotModes = new ModeBuilder().addMode(Mode.INPUT).addMode(Mode.OUTPUT).get();
    }

    public boolean isBurning() {
        return this.burnTimeRemaining > 0 && ((ItemStack)this.items.get(0)).m_41720_() instanceof ItemRBMKFuelRod;
    }

    public int burnTimeRemaining() {
        return this.burnTimeRemaining;
    }

    public int burnTimeTotal() {
        return this.burnTimeTotal;
    }

    public ItemStack fuelStack() {
        return (ItemStack)this.items.get(0);
    }

    public ItemStack spentFuelStack() {
        return (ItemStack)this.items.get(1);
    }

    public int redstoneSignal() {
        return this.isBurning() ? 15 : 0;
    }

    public int comparatorSignal() {
        return this.calculateComparatorSignal();
    }

    public void serverTick() {
        Item item;
        RBMKBaseEntity base;
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos corePos = this.f_58858_.m_7495_();
        RBMKLevelContext context = RBMKManager.context(serverLevel);
        Optional<RBMKColumnState> column = context.column(corePos);
        BlockEntity blockEntity = this.f_58857_.m_7702_(corePos);
        RBMKBaseEntity baseEntity = blockEntity instanceof RBMKBaseEntity ? (base = (RBMKBaseEntity)blockEntity) : null;
        double reportedHeatPerSecond = 0.0;
        ItemStack fuelStack = (ItemStack)this.items.get(0);
        if (fuelStack.m_41619_() || !((item = fuelStack.m_41720_()) instanceof ItemRBMKFuelRod)) {
            if (this.burnTimeRemaining != 0 || this.burnTimeTotal != 0) {
                this.burnTimeRemaining = 0;
                this.burnTimeTotal = 0;
                this.m_6596_();
            }
            this.updateSignalLevels();
            this.updateClientData(column.orElse(null), baseEntity, context, reportedHeatPerSecond);
            return;
        }
        ItemRBMKFuelRod fuelRod = (ItemRBMKFuelRod)item;
        if (this.burnTimeRemaining <= 0) {
            this.burnTimeTotal = this.loadTotalTimeFromFuel(fuelStack, fuelRod);
            this.burnTimeRemaining = this.loadRemainingTimeFromFuel(fuelStack, fuelRod, this.burnTimeTotal);
            this.m_6596_();
        }
        if (column.isPresent()) {
            RBMKColumnState state = column.get();
            double controlRod = context.controlRodAverage();
            double heatPerSecond = fuelRod.heatPerSecond() * state.settings().reactivityModifier() * (1.0 - controlRod);
            if (heatPerSecond > 0.0) {
                reportedHeatPerSecond = heatPerSecond;
                context.addHeat(corePos, heatPerSecond * 0.05);
            }
        }
        if (this.burnTimeRemaining > 0) {
            --this.burnTimeRemaining;
            this.m_6596_();
        }
        if (this.burnTimeRemaining == 0 && this.burnTimeTotal > 0) {
            ItemStack spentFuel = ((Item)HBMItems.rbmk_fuel_empty.get()).m_7968_();
            if (!this.insertIntoOutput(spentFuel.m_41777_())) {
                Containers.m_18992_((Level)serverLevel, (double)((double)this.f_58858_.m_123341_() + 0.5), (double)((double)this.f_58858_.m_123342_() + 1.0), (double)((double)this.f_58858_.m_123343_() + 0.5), (ItemStack)spentFuel.m_41777_());
            }
            this.items.set(0, (Object)ItemStack.f_41583_);
            this.burnTimeTotal = 0;
            this.m_6596_();
            HBM.LOGGER.debug("RBMK fuel channel at {} finished burn cycle.", (Object)this.f_58858_);
        }
        this.updateSignalLevels();
        this.updateClientData(column.orElse(null), baseEntity, context, reportedHeatPerSecond);
    }

    public boolean tryInsertFuel(Player player, InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        if (!(held.m_41720_() instanceof ItemRBMKFuelRod)) {
            return false;
        }
        if (!((ItemStack)this.items.get(0)).m_41619_()) {
            return false;
        }
        ItemStack output = (ItemStack)this.items.get(1);
        ItemStack spentPrototype = ((Item)HBMItems.rbmk_fuel_empty.get()).m_7968_();
        if (!output.m_41619_()) {
            if (!ItemStack.m_150942_((ItemStack)output, (ItemStack)spentPrototype)) {
                return false;
            }
            int max = Math.min(output.m_41741_(), this.m_6893_());
            if (output.m_41613_() >= max) {
                return false;
            }
        }
        ItemStack toInsert = held.m_255036_(1);
        this.items.set(0, (Object)toInsert);
        if (!player.m_150110_().f_35937_) {
            held.m_41774_(1);
        }
        this.burnTimeRemaining = 0;
        this.burnTimeTotal = 0;
        this.m_6596_();
        this.updateSignalLevels();
        return true;
    }

    public void tryExtractFuel(Player player) {
        ItemStack output = (ItemStack)this.items.get(1);
        if (!output.m_41619_()) {
            this.items.set(1, (Object)ItemStack.f_41583_);
            this.m_6596_();
            ItemStack toDrop = output.m_41777_();
            if (!player.m_36356_(toDrop)) {
                Containers.m_18992_((Level)player.m_9236_(), (double)((double)this.f_58858_.m_123341_() + 0.5), (double)((double)this.f_58858_.m_123342_() + 1.0), (double)((double)this.f_58858_.m_123343_() + 0.5), (ItemStack)toDrop);
            }
            this.updateSignalLevels();
            return;
        }
        ItemStack input = (ItemStack)this.items.get(0);
        if (input.m_41619_()) {
            return;
        }
        this.writeBurnProgressToFuel(input);
        this.items.set(0, (Object)ItemStack.f_41583_);
        this.burnTimeRemaining = 0;
        this.burnTimeTotal = 0;
        this.m_6596_();
        ItemStack toDrop = input.m_41777_();
        if (!player.m_36356_(toDrop)) {
            Containers.m_18992_((Level)player.m_9236_(), (double)((double)this.f_58858_.m_123341_() + 0.5), (double)((double)this.f_58858_.m_123342_() + 1.0), (double)((double)this.f_58858_.m_123343_() + 0.5), (ItemStack)toDrop);
        }
        this.updateSignalLevels();
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.burnTimeRemaining = tag.m_128451_(TAG_BURN_TIME_REMAINING);
        this.burnTimeTotal = tag.m_128451_(TAG_BURN_TIME_TOTAL);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_(TAG_BURN_TIME_REMAINING, this.burnTimeRemaining);
        tag.m_128405_(TAG_BURN_TIME_TOTAL, this.burnTimeTotal);
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)"block.hbm.machine_rbmk_fuel_channel");
    }

    @Override
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new RBMKFuelChannelMenu(containerId, inventory, this, this.getContainerData());
    }

    public ContainerData getContainerData() {
        return this.containerData;
    }

    public void prepareForDrop() {
        ItemStack input = (ItemStack)this.items.get(0);
        if (!input.m_41619_()) {
            this.writeBurnProgressToFuel(input);
        }
    }

    @Override
    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (stack.m_41619_() || slot != 0) {
            return stack;
        }
        if (!(stack.m_41720_() instanceof ItemRBMKFuelRod)) {
            return stack;
        }
        if (!((ItemStack)this.items.get(0)).m_41619_()) {
            return stack;
        }
        int toMove = Math.min(1, stack.m_41613_());
        if (!simulate) {
            this.items.set(0, (Object)stack.m_255036_(toMove));
            this.burnTimeRemaining = 0;
            this.burnTimeTotal = 0;
            this.m_6596_();
            this.updateSignalLevels();
        }
        return stack.m_41613_() == toMove ? ItemStack.f_41583_ : stack.m_255036_(stack.m_41613_() - toMove);
    }

    @Override
    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount <= 0) {
            return ItemStack.f_41583_;
        }
        if (slot == 1) {
            ItemStack existing = (ItemStack)this.items.get(1);
            if (existing.m_41619_()) {
                return ItemStack.f_41583_;
            }
            int toExtract = Math.min(amount, existing.m_41613_());
            ItemStack result = existing.m_255036_(toExtract);
            if (!simulate) {
                existing.m_41774_(toExtract);
                this.items.set(1, (Object)(existing.m_41619_() ? ItemStack.f_41583_ : existing));
                this.m_6596_();
                this.updateSignalLevels();
            }
            return result;
        }
        if (slot != 0) {
            return ItemStack.f_41583_;
        }
        ItemStack existing = (ItemStack)this.items.get(0);
        if (!(existing.m_41720_() instanceof ItemRBMKFuelRod)) {
            return ItemStack.f_41583_;
        }
        int toExtract = Math.min(amount, existing.m_41613_());
        ItemStack result = existing.m_255036_(toExtract);
        this.writeBurnProgressToFuel(result);
        if (!simulate) {
            this.items.set(0, (Object)ItemStack.f_41583_);
            this.burnTimeRemaining = 0;
            this.burnTimeTotal = 0;
            this.m_6596_();
            this.updateSignalLevels();
        }
        return result;
    }

    @Override
    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction side) {
        if (index != 0) {
            return false;
        }
        if (!(stack.m_41720_() instanceof ItemRBMKFuelRod)) {
            return false;
        }
        return super.m_7155_(index, stack, side);
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction side) {
        return index == 1;
    }

    private void updateSignalLevels() {
        if (this.f_58857_ == null) {
            return;
        }
        int redstoneSignal = this.redstoneSignal();
        int comparatorSignal = this.calculateComparatorSignal();
        if (redstoneSignal != this.lastRedstoneSignal) {
            this.lastRedstoneSignal = redstoneSignal;
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        }
        if (comparatorSignal != this.lastComparatorSignal) {
            this.lastComparatorSignal = comparatorSignal;
            this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
        }
    }

    private int calculateComparatorSignal() {
        ItemStack stack = (ItemStack)this.items.get(0);
        if (!(stack.m_41720_() instanceof ItemRBMKFuelRod)) {
            return 0;
        }
        if (this.burnTimeTotal <= 0) {
            return 0;
        }
        double fraction = (double)this.burnTimeRemaining / (double)this.burnTimeTotal;
        if (fraction <= 0.0) {
            return 0;
        }
        if (fraction >= 1.0) {
            return 15;
        }
        return Math.min(15, Math.max(0, (int)Math.ceil(fraction * 15.0)));
    }

    private void updateClientData(@Nullable RBMKColumnState column, @Nullable RBMKBaseEntity base, RBMKLevelContext context, double heatPerSecond) {
        this.dataSlots[0] = column != null ? (int)Math.round(column.heat() * 10.0) : 0;
        this.dataSlots[1] = column != null ? (int)Math.round(column.settings().meltdownHeat() * 10.0) : 0;
        this.dataSlots[2] = base != null ? (int)Math.min(Integer.MAX_VALUE, base.getEnergyStored()) : 0;
        this.dataSlots[3] = base != null ? (int)Math.min(Integer.MAX_VALUE, base.getEnergyCapacity()) : 0;
        this.dataSlots[4] = base != null ? base.getWaterAmount() : 0;
        this.dataSlots[5] = base != null ? base.getSteamAmount() : 0;
        this.dataSlots[6] = this.burnTimeRemaining;
        this.dataSlots[7] = this.burnTimeTotal;
        this.dataSlots[8] = this.isBurning() ? 1 : 0;
        this.dataSlots[9] = (int)Math.round(Math.max(0.0, heatPerSecond) * 10.0);
        this.dataSlots[10] = column != null ? (int)Math.round(column.controlRodInsertion() * 100.0) : 0;
        this.dataSlots[11] = (int)Math.round(context.controlRodAverage() * 100.0);
        for (int i = 0; i < this.dataSlots.length; ++i) {
            this.containerData.m_8050_(i, this.dataSlots[i]);
        }
    }

    private boolean insertIntoOutput(ItemStack stack) {
        if (stack.m_41619_()) {
            return true;
        }
        ItemStack existing = (ItemStack)this.items.get(1);
        if (existing.m_41619_()) {
            this.items.set(1, (Object)stack);
            return true;
        }
        if (!ItemStack.m_150942_((ItemStack)existing, (ItemStack)stack)) {
            return false;
        }
        int max = Math.min(existing.m_41741_(), this.m_6893_());
        int space = max - existing.m_41613_();
        if (space <= 0) {
            return false;
        }
        int toAdd = Math.min(space, stack.m_41613_());
        existing.m_41769_(toAdd);
        stack.m_41774_(toAdd);
        this.items.set(1, (Object)existing);
        return stack.m_41619_();
    }

    private void writeBurnProgressToFuel(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof ItemRBMKFuelRod)) {
            return;
        }
        ItemRBMKFuelRod fuelRod = (ItemRBMKFuelRod)item;
        if (this.burnTimeTotal <= 0) {
            return;
        }
        int total = Math.min(this.burnTimeTotal, fuelRod.burnTimeTicks());
        int remaining = Math.min(this.burnTimeRemaining, total);
        stack.m_41784_().m_128405_(TAG_BURN_TIME_TOTAL, total);
        stack.m_41784_().m_128405_(TAG_BURN_TIME_REMAINING, remaining);
    }

    private int loadTotalTimeFromFuel(ItemStack stack, ItemRBMKFuelRod fuelRod) {
        int configuredTotal = fuelRod.burnTimeTicks();
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return configuredTotal;
        }
        int stored = tag.m_128451_(TAG_BURN_TIME_TOTAL);
        if (stored <= 0) {
            return configuredTotal;
        }
        return Math.min(stored, configuredTotal);
    }

    private int loadRemainingTimeFromFuel(ItemStack stack, ItemRBMKFuelRod fuelRod, int burnTimeTotal) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return burnTimeTotal;
        }
        int stored = tag.m_128451_(TAG_BURN_TIME_REMAINING);
        if (stored <= 0) {
            return burnTimeTotal;
        }
        return Math.min(stored, burnTimeTotal);
    }
}

