/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine.rbmk;

import com.hbm.HBM;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.base2.BaseMachineBlockEntity;
import com.hbm.reactor.rbmk.RBMKColumnState;
import com.hbm.reactor.rbmk.RBMKLevelContext;
import com.hbm.reactor.rbmk.RBMKManager;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class RBMKHeaterEntity
extends BaseMachineBlockEntity {
    private static final double HEAT_PER_SECOND = 5.0;
    private static final double TIME_STEP = 0.05;
    private boolean active;
    private double heatBuffer;

    public RBMKHeaterEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityType.RBMK_HEATER_ENTITY.get(), pos, state);
        this.items = NonNullList.m_122779_();
        this.slotModes = Collections.emptyList();
    }

    public void setActive(boolean active) {
        this.active = active;
        this.m_6596_();
    }

    public void serverTick() {
        Level level;
        if (!this.active || !((level = this.f_58857_) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos below = this.f_58858_.m_7495_();
        RBMKLevelContext context = RBMKManager.context(serverLevel);
        Optional<RBMKColumnState> column = context.column(below);
        column.ifPresent(state -> {
            if (!context.addHeat(below, 0.25)) {
                return;
            }
            this.heatBuffer += 0.25;
            if (this.heatBuffer >= 5.0) {
                HBM.LOGGER.debug("RBMK heater at {} delivered {} heat to column {} (heat={})", new Object[]{this.f_58858_, this.heatBuffer, state.corePosition(), state.heat()});
                this.heatBuffer = 0.0;
            }
        });
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.active = tag.m_128471_("Active");
        this.heatBuffer = tag.m_128459_("HeatBuffer");
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("Active", this.active);
        tag.m_128347_("HeatBuffer", this.heatBuffer);
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)"block.hbm.machine_rbmk_heater");
    }

    @Override
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return null;
    }
}

