/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine.rbmk;

import com.hbm.block.machine.rbmk.BlockRBMKBase;
import com.hbm.block.machine.rbmk.BlockRBMKControlRod;
import com.hbm.block.machine.rbmk.BlockRBMKPeripheral;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.base2.BaseMachineBlockEntity;
import com.hbm.blockentity.machine.rbmk.RBMKBaseEntity;
import com.hbm.blockentity.machine.rbmk.RBMKControlRodEntity;
import com.hbm.gui.menu.RBMKPeripheralMenu;
import com.hbm.reactor.rbmk.RBMKColumnState;
import com.hbm.reactor.rbmk.RBMKLevelContext;
import com.hbm.reactor.rbmk.RBMKManager;
import com.hbm.reactor.rbmk.RBMKPeripheralType;
import com.hbm.registries.ModSounds;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class RBMKPeripheralEntity
extends BaseMachineBlockEntity {
    private static final int SEARCH_INTERVAL_TICKS = 40;
    private static final int DATA_SLOTS = 10;
    private final RBMKPeripheralType peripheralType;
    private final ContainerData containerData = new SimpleContainerData(10);
    private final int[] dataBacking = new int[10];
    private BlockPos linkedColumn;
    private BlockPos manualLink;
    private int tickCounter;

    public RBMKPeripheralEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityType.RBMK_PERIPHERAL_ENTITY.get(), pos, state);
        RBMKPeripheralType rBMKPeripheralType;
        this.items = NonNullList.m_122779_();
        this.slotModes = List.of();
        Block block = state.m_60734_();
        if (block instanceof BlockRBMKPeripheral) {
            BlockRBMKPeripheral block2 = (BlockRBMKPeripheral)block;
            rBMKPeripheralType = block2.getPeripheralType();
        } else {
            rBMKPeripheralType = RBMKPeripheralType.CONSOLE;
        }
        this.peripheralType = rBMKPeripheralType;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.manualLink != null) {
            tag.m_128356_("ManualLink", this.manualLink.m_121878_());
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("ManualLink")) {
            this.linkedColumn = this.manualLink = BlockPos.m_122022_((long)tag.m_128454_("ManualLink"));
        } else {
            this.manualLink = null;
        }
    }

    @Override
    protected void onUpdateServer() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.dataBacking[9] = this.peripheralType.ordinal();
        if (this.manualLink != null) {
            if (this.isColumnValid(this.manualLink)) {
                this.linkedColumn = this.manualLink;
            } else {
                this.manualLink = null;
                this.linkedColumn = null;
            }
        }
        if (!(this.manualLink != null || ++this.tickCounter % 40 != 0 && this.isLinkedColumnValid())) {
            this.linkedColumn = this.findNearestColumn();
        }
        if (this.linkedColumn == null) {
            this.clearTelemetry();
            this.pushData();
            return;
        }
        RBMKLevelContext context = RBMKManager.context(serverLevel);
        Optional<RBMKColumnState> columnOpt = context.column(this.linkedColumn);
        if (columnOpt.isEmpty()) {
            this.linkedColumn = null;
            this.clearTelemetry();
            this.pushData();
            return;
        }
        RBMKColumnState column = columnOpt.get();
        this.dataBacking[0] = (int)Math.round(column.heat() * 10.0);
        this.dataBacking[1] = (int)Math.round(column.settings().meltdownHeat() * 10.0);
        this.dataBacking[6] = (int)Math.round(column.controlRodInsertion() * 100.0);
        this.dataBacking[7] = (int)Math.round(context.controlRodAverage() * 100.0);
        this.dataBacking[8] = context.snapshot().size();
        RBMKBaseEntity base = this.resolveBaseEntity();
        if (base != null) {
            this.dataBacking[2] = (int)Math.min(Integer.MAX_VALUE, base.getEnergyStored());
            this.dataBacking[3] = (int)Math.min(Integer.MAX_VALUE, base.getEnergyCapacity());
            this.dataBacking[4] = base.getWaterAmount();
            this.dataBacking[5] = base.getSteamAmount();
        } else {
            this.dataBacking[2] = 0;
            this.dataBacking[3] = 0;
            this.dataBacking[4] = 0;
            this.dataBacking[5] = 0;
        }
        this.pushData();
    }

    private void pushData() {
        for (int i = 0; i < this.dataBacking.length; ++i) {
            this.containerData.m_8050_(i, this.dataBacking[i]);
        }
    }

    private void clearTelemetry() {
        for (int i = 0; i < this.dataBacking.length - 1; ++i) {
            this.dataBacking[i] = 0;
        }
    }

    private boolean isLinkedColumnValid() {
        if (this.linkedColumn == null || this.f_58857_ == null) {
            return false;
        }
        BlockState state = this.f_58857_.m_8055_(this.linkedColumn);
        if (!(state.m_60734_() instanceof BlockRBMKBase)) {
            return false;
        }
        return state.m_61138_((Property)BlockRBMKBase.IS_CORE) && (Boolean)state.m_61143_((Property)BlockRBMKBase.IS_CORE) != false;
    }

    private boolean isColumnValid(BlockPos pos) {
        if (this.f_58857_ == null) {
            return false;
        }
        BlockState state = this.f_58857_.m_8055_(pos);
        if (!(state.m_60734_() instanceof BlockRBMKBase)) {
            return false;
        }
        return state.m_61138_((Property)BlockRBMKBase.IS_CORE) && (Boolean)state.m_61143_((Property)BlockRBMKBase.IS_CORE) != false;
    }

    @Nullable
    private BlockPos findNearestColumn() {
        if (this.f_58857_ == null) {
            return null;
        }
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        BlockPos best = null;
        double closest = Double.MAX_VALUE;
        int horizontal = 8;
        int vertical = 6;
        for (int dx = -horizontal; dx <= horizontal; ++dx) {
            for (int dy = -vertical; dy <= vertical; ++dy) {
                for (int dz = -horizontal; dz <= horizontal; ++dz) {
                    double dist;
                    BlockState state;
                    cursor.m_122178_(this.f_58858_.m_123341_() + dx, this.f_58858_.m_123342_() + dy, this.f_58858_.m_123343_() + dz);
                    if (!this.f_58857_.m_46805_((BlockPos)cursor) || !((state = this.f_58857_.m_8055_((BlockPos)cursor)).m_60734_() instanceof BlockRBMKBase) || !state.m_61138_((Property)BlockRBMKBase.IS_CORE) || !((Boolean)state.m_61143_((Property)BlockRBMKBase.IS_CORE)).booleanValue() || !((dist = cursor.m_123331_((Vec3i)this.f_58858_)) < closest)) continue;
                    closest = dist;
                    best = cursor.m_7949_();
                }
            }
        }
        return best;
    }

    @Nullable
    private RBMKBaseEntity resolveBaseEntity() {
        if (this.linkedColumn == null || this.f_58857_ == null) {
            return null;
        }
        BlockEntity entity = this.f_58857_.m_7702_(this.linkedColumn);
        if (entity instanceof RBMKBaseEntity) {
            RBMKBaseEntity baseEntity = (RBMKBaseEntity)entity;
            return baseEntity;
        }
        return null;
    }

    public ContainerData getContainerData() {
        return this.containerData;
    }

    public RBMKPeripheralType getPeripheralType() {
        return this.peripheralType;
    }

    public boolean triggerAz5() {
        Level level;
        if (this.peripheralType != RBMKPeripheralType.CONSOLE || !((level = this.f_58857_) instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        RBMKLevelContext context = RBMKManager.context(serverLevel);
        Map<BlockPos, RBMKColumnState> snapshot = context.snapshot();
        if (snapshot.isEmpty()) {
            return false;
        }
        boolean changed = false;
        for (BlockPos corePos : snapshot.keySet()) {
            context.setControlRodInsertion(corePos, 1.0);
            BlockPos rodPos = corePos.m_7494_();
            BlockEntity entity = this.f_58857_.m_7702_(rodPos);
            if (entity instanceof RBMKControlRodEntity) {
                RBMKControlRodEntity controlRod = (RBMKControlRodEntity)entity;
                controlRod.engageAz5();
                changed = true;
                continue;
            }
            BlockState rodState = this.f_58857_.m_8055_(rodPos);
            if (!(rodState.m_60734_() instanceof BlockRBMKControlRod) || !rodState.m_61138_((Property)BlockRBMKControlRod.INSERTION)) continue;
            this.f_58857_.m_7731_(rodPos, (BlockState)rodState.m_61124_((Property)BlockRBMKControlRod.INSERTION, (Comparable)Integer.valueOf(4)), 3);
            changed = true;
        }
        if (changed) {
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.BLOCK_RBMK_AZ5_COVER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return changed;
    }

    public boolean linkToColumn(BlockPos target) {
        if (this.f_58857_ == null || !this.isColumnValid(target)) {
            return false;
        }
        this.linkedColumn = this.manualLink = target.m_7949_();
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        return true;
    }

    public void clearManualLink() {
        if (this.manualLink != null) {
            this.manualLink = null;
            this.linkedColumn = null;
            this.m_6596_();
        }
    }

    @Override
    public Component getDefaultName() {
        return this.peripheralType.displayName();
    }

    @Override
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new RBMKPeripheralMenu(containerId, inventory, (Container)this, this.getContainerData());
    }
}

