/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine.research;

import com.hbm.Inventory.recipe.BreederRecipes;
import com.hbm.api.Mode;
import com.hbm.api.inventory.ModeBuilder;
import com.hbm.block.base.BlockDummyable;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.base2.DummyableBlockEntity;
import com.hbm.blockentity.machine.research.ResearchReactorBlockEntity;
import com.hbm.gui.menu.BreederReactorMenu;
import com.hbm.registries.ModBlocks;
import com.hbm.utils.multiblock.MultiblockData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.NotNull;

public class BreederReactorBlockEntity
extends DummyableBlockEntity
implements MenuProvider {
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_OUTPUT = 1;
    private static final double BASE_PROGRESS = 0.0025;
    private final ContainerData containerData = new SimpleContainerData(2){

        public int m_6413_(int index) {
            return index == 0 ? BreederReactorBlockEntity.this.flux : (int)Math.min(100L, Math.round(BreederReactorBlockEntity.this.progress * 100.0));
        }
    };
    private int flux;
    private double progress;

    public BreederReactorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityType.BREEDER_REACTOR_ENTITY.get(), pos, state);
        this.items = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
        this.multiblockData = MultiblockData.mapping.get(ModBlocks.machine_reactor_breeding.get());
        this.slotModes = new ModeBuilder().addModes(new Object[]{1, Mode.INPUT}).addModes(new Object[]{1, Mode.OUTPUT}).get();
        this.capabilitiesContent.addCapability(ForgeCapabilities.ITEM_HANDLER, this);
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (!this.isFormed || this.f_58857_ == null) {
            this.running = false;
            this.flux = 0;
            return;
        }
        this.running = true;
        this.gatherFlux();
        this.process();
    }

    private void gatherFlux() {
        if (this.f_58857_ == null) {
            this.flux = 0;
            return;
        }
        int total = 0;
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockEntity blockEntity;
            BlockPos corePos;
            BlockPos neighborPos = this.f_58858_.m_121945_(dir);
            BlockState neighborState = this.f_58857_.m_8055_(neighborPos);
            if (neighborState.m_60734_() != ModBlocks.machine_research_reactor.get() || (corePos = ((BlockDummyable)neighborState.m_60734_()).getCore(neighborState, (LevelReader)this.f_58857_, neighborPos)) == null || !((blockEntity = this.f_58857_.m_7702_(corePos)) instanceof ResearchReactorBlockEntity)) continue;
            ResearchReactorBlockEntity reactor = (ResearchReactorBlockEntity)blockEntity;
            total += reactor.getFlux();
        }
        this.flux = total;
    }

    private void process() {
        ItemStack input = (ItemStack)this.items.get(0);
        if (input.m_41619_()) {
            this.progress = 0.0;
            return;
        }
        BreederRecipes.BreederRecipe recipe = BreederRecipes.getOutput(input);
        if (recipe == null || this.flux < recipe.flux()) {
            this.progress = 0.0;
            return;
        }
        int targetSlot = 1;
        ItemStack output = (ItemStack)this.items.get(targetSlot);
        ItemStack produced = recipe.createOutput(input);
        if (!(output.m_41619_() || ItemStack.m_150942_((ItemStack)output, (ItemStack)produced) && output.m_41613_() < output.m_41741_())) {
            this.progress = 0.0;
            return;
        }
        this.progress += 0.0025 * ((double)this.flux / (double)recipe.flux());
        if (this.progress >= 1.0) {
            this.progress = 0.0;
            this.items.set(0, (Object)recipe.consumeInput(input));
            if (output.m_41619_()) {
                this.items.set(targetSlot, (Object)produced);
            } else {
                output.m_41769_(produced.m_41613_());
            }
            this.m_6596_();
        }
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("flux", this.flux);
        tag.m_128347_("Progress", this.progress);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.flux = tag.m_128451_("flux");
        this.progress = tag.m_128459_("Progress");
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.m_60713_(newState.m_60734_())) {
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)this);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @Override
    public Component m_5446_() {
        return Component.m_237115_((String)"container.hbm.reactor_breeder");
    }

    @Override
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new BreederReactorMenu(containerId, inventory, (Container)this, this.containerData);
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)"container.hbm.reactor_breeder");
    }

    public int getFlux() {
        return this.flux;
    }

    public int getProgressScaled(int pixels) {
        return (int)Math.min((long)pixels, Math.round(this.progress * (double)pixels));
    }

    public int getProgressPercent() {
        return (int)Math.min(100L, Math.round(this.progress * 100.0));
    }
}

