/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine.research;

import com.hbm.api.Mode;
import com.hbm.api.inventory.ModeBuilder;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.base2.DummyableBlockEntity;
import com.hbm.gui.menu.ResearchReactorMenu;
import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.item.HBMItems;
import com.hbm.item.research.ItemResearchFuelPlate;
import com.hbm.registries.ModBlocks;
import com.hbm.utils.multiblock.MultiblockData;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.NotNull;

public class ResearchReactorBlockEntity
extends DummyableBlockEntity
implements MenuProvider {
    public static final int SLOT_COUNT = 12;
    private static final int MAX_HEAT = 50000;
    private static final double CONTROL_SPEED = 0.04;
    private static final int[][] NEIGHBORS = new int[][]{{1, 5}, {0, 6}, {3, 7}, {2, 4, 8}, {3, 9}, {0, 6, 10}, {1, 5, 11}, {2, 8}, {3, 7, 9}, {4, 8}, {5, 11}, {6, 10}};
    private static final Map<Supplier<Item>, Supplier<Item>> WASTE_MAP = Map.of(HBMItems.plate_fuel_u233, HBMItems.waste_plate_u233, HBMItems.plate_fuel_u235, HBMItems.waste_plate_u235, HBMItems.plate_fuel_mox, HBMItems.waste_plate_mox, HBMItems.plate_fuel_pu239, HBMItems.waste_plate_pu239, HBMItems.plate_fuel_sa326, HBMItems.waste_plate_sa326, HBMItems.plate_fuel_ra226be, HBMItems.waste_plate_ra226be, HBMItems.plate_fuel_pu238be, HBMItems.waste_plate_pu238be);
    private final int[] slotFlux = new int[12];
    private final ContainerData containerData = new SimpleContainerData(5){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> Math.min(9999, ResearchReactorBlockEntity.this.totalFlux);
                case 1 -> ResearchReactorBlockEntity.this.heat;
                case 2 -> (int)Math.round(ResearchReactorBlockEntity.this.controlLevel * 100.0);
                case 3 -> (int)Math.round(ResearchReactorBlockEntity.this.targetLevel * 100.0);
                case 4 -> ResearchReactorBlockEntity.this.waterLevel & 0xFF;
                default -> 0;
            };
        }
    };
    private double controlLevel;
    private double targetLevel;
    private double lastLevel;
    private int heat;
    private int totalFlux;
    private byte waterLevel;

    public ResearchReactorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityType.RESEARCH_REACTOR_ENTITY.get(), pos, state);
        this.items = NonNullList.m_122780_((int)12, (Object)ItemStack.f_41583_);
        this.multiblockData = MultiblockData.mapping.get(ModBlocks.machine_research_reactor.get());
        this.slotModes = new ModeBuilder().addModes(new Object[]{12, Mode.BOTH}).get();
        this.capabilitiesContent.addCapability(ForgeCapabilities.ITEM_HANDLER, this);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128347_("hbmControl", this.controlLevel);
        tag.m_128347_("hbmTarget", this.targetLevel);
        tag.m_128347_("hbmLastControl", this.lastLevel);
        tag.m_128405_("heat", this.heat);
        tag.m_128405_("hbmFlux", this.totalFlux);
        tag.m_128344_("hbmWater", this.waterLevel);
        tag.m_128385_("hbmSlotFlux", this.slotFlux);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.controlLevel = tag.m_128459_("hbmControl");
        this.targetLevel = tag.m_128459_("hbmTarget");
        this.lastLevel = tag.m_128459_("hbmLastControl");
        this.heat = tag.m_128451_("heat");
        this.totalFlux = tag.m_128451_("hbmFlux");
        this.waterLevel = tag.m_128445_("hbmWater");
        int[] savedFlux = tag.m_128465_("hbmSlotFlux");
        if (savedFlux.length == 12) {
            System.arraycopy(savedFlux, 0, this.slotFlux, 0, 12);
        }
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (!this.isFormed || this.f_58857_ == null) {
            this.totalFlux = 0;
            this.running = false;
            return;
        }
        this.running = true;
        this.tickControl();
        this.performReaction();
        this.dissipateHeat();
        if (this.heat > 50000) {
            this.triggerMeltdown();
        }
    }

    private void tickControl() {
        this.lastLevel = this.controlLevel;
        if (this.controlLevel < this.targetLevel) {
            this.controlLevel = Math.min(this.targetLevel, this.controlLevel + 0.04);
        } else if (this.controlLevel > this.targetLevel) {
            this.controlLevel = Math.max(this.targetLevel, this.controlLevel - 0.04);
        }
    }

    private void performReaction() {
        this.totalFlux = 0;
        for (int i = 0; i < 12; ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (stack.m_41619_()) {
                this.slotFlux[i] = 0;
                continue;
            }
            Item item = stack.m_41720_();
            if (item instanceof ItemResearchFuelPlate) {
                int[] neighbors;
                ItemResearchFuelPlate plate = (ItemResearchFuelPlate)item;
                int produced = plate.react(stack, this.slotFlux[i]);
                this.slotFlux[i] = 0;
                this.totalFlux += produced;
                this.heat += produced * 2;
                if (plate.isSpent(stack)) {
                    this.items.set(i, (Object)this.getWasteForPlate(stack));
                }
                int[] nArray = neighbors = NEIGHBORS[i];
                int n = nArray.length;
                for (int j = 0; j < n; ++j) {
                    int neighbor;
                    int n2 = neighbor = nArray[j];
                    this.slotFlux[n2] = this.slotFlux[n2] + (int)((double)produced * this.controlLevel);
                }
                continue;
            }
            this.slotFlux[i] = 0;
        }
        this.m_6596_();
    }

    private ItemStack getWasteForPlate(ItemStack stack) {
        for (Map.Entry<Supplier<Item>, Supplier<Item>> entry : WASTE_MAP.entrySet()) {
            if (!stack.m_150930_(entry.getKey().get())) continue;
            return entry.getValue().get().m_7968_();
        }
        return ItemStack.f_41583_;
    }

    private void dissipateHeat() {
        if (this.heat <= 0) {
            this.heat = 0;
            return;
        }
        this.waterLevel = this.computeWaterLevel();
        this.heat = this.waterLevel > 0 ? (this.heat -= (int)((double)this.heat * 0.07 * (double)this.waterLevel / 12.0)) : Math.max(0, this.heat - 1);
    }

    private byte computeWaterLevel() {
        if (this.f_58857_ == null) {
            return 0;
        }
        byte water = 0;
        BlockPos pos = this.m_58899_();
        for (Direction dir : Direction.values()) {
            if (dir == Direction.UP || dir == Direction.DOWN) {
                BlockPos check = pos.m_5484_(Direction.UP, 1 + dir.m_122430_() * 2);
                if (!this.isWater(check)) continue;
                water = (byte)(water + 1);
                continue;
            }
            BlockPos column = pos.m_121945_(dir);
            for (int i = 0; i < 3; ++i) {
                if (!this.isWater(column.m_6630_(i))) continue;
                water = (byte)(water + 1);
            }
        }
        return water;
    }

    private boolean isWater(BlockPos check) {
        if (this.f_58857_ == null) {
            return false;
        }
        return this.f_58857_.m_8055_(check).m_60819_().m_76170_() && this.f_58857_.m_8055_(check).m_60819_().m_76152_() == Fluids.f_76193_;
    }

    private void triggerMeltdown() {
        if (this.f_58857_ == null) {
            return;
        }
        BlockPos pos = this.m_58899_();
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)pos, (Container)this);
        this.f_58857_.m_7471_(pos, false);
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_254849_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 8.0f, Level.ExplosionInteraction.BLOCK);
            ChunkRadiationManager.proxy.incrementRad((Level)serverLevel, pos, 50.0f);
        }
        this.f_58857_.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        BlockState below = this.f_58857_.m_8055_(pos.m_7495_());
        if (!below.m_60795_()) {
            this.f_58857_.m_7731_(pos.m_7495_(), Blocks.f_49991_.m_49966_(), 3);
        }
        this.running = false;
    }

    public boolean isSubmerged() {
        if (this.f_58857_ == null) {
            return false;
        }
        BlockPos pos = this.m_58899_();
        return this.isWater(pos.m_122029_().m_7494_()) || this.isWater(pos.m_122024_().m_7494_()) || this.isWater(pos.m_122012_().m_7494_()) || this.isWater(pos.m_122019_().m_7494_());
    }

    public double getRenderLevel(double partialTicks) {
        return this.lastLevel + (this.controlLevel - this.lastLevel) * partialTicks;
    }

    public ContainerData getContainerData() {
        return this.containerData;
    }

    public void setTargetLevel(double percent) {
        this.targetLevel = Mth.m_14008_((double)percent, (double)0.0, (double)1.0);
        this.m_6596_();
    }

    @Override
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new ResearchReactorMenu(containerId, inventory, (Container)this, this.containerData);
    }

    @Override
    public Component m_5446_() {
        return Component.m_237115_((String)"container.hbm.research_reactor");
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)"container.hbm.research_reactor");
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.m_60713_(newState.m_60734_())) {
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)this);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @NotNull
    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82377_(1.0, 2.5, 1.0);
    }

    public int getFlux() {
        return this.totalFlux;
    }

    public int getHeat() {
        return this.heat;
    }

    public double getControlLevel() {
        return this.controlLevel;
    }

    public double getTargetLevelPercent() {
        return this.targetLevel;
    }

    public byte getWaterLevel() {
        return this.waterLevel;
    }
}

