/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine.tokamak;

import com.hbm.HBMLang;
import com.hbm.Inventory.fluid.ModFluids;
import com.hbm.api.Mode;
import com.hbm.api.energy.BasicEnergyContainer;
import com.hbm.api.energy.HybridEnergyStorage;
import com.hbm.api.energy.ProxyEnergyHandler;
import com.hbm.api.energy.TransmitUtils;
import com.hbm.api.fluid.BasicFluidHandler;
import com.hbm.api.inventory.ModeBuilder;
import com.hbm.api.math.MathUtils;
import com.hbm.block.machine.tokamak.TokamakCoilBlock;
import com.hbm.block.machine.tokamak.TokamakHeaterBlock;
import com.hbm.block.machine.tokamak.TokamakInjectorBlock;
import com.hbm.block.machine.tokamak.TokamakPortBlock;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.base2.BaseMachineBlockEntity;
import com.hbm.capabilities.HBMCaps;
import com.hbm.gui.menu.TokamakMenu;
import com.hbm.item.HBMComponent;
import com.hbm.registries.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TokamakControllerBlockEntity
extends BaseMachineBlockEntity
implements MenuProvider {
    public static final double R0 = 4.0;
    public static final double A_MINOR = 1.6;
    private static final int COIL_SAMPLES = 24;
    private static final double COIL_RING_TOLERANCE = 0.45;
    private static final int MIN_COILS_REQUIRED = 16;
    private static final double K_B = 0.75;
    private static final double K_FUSION = 2.0E-9;
    private static final double IGNITION_THRESHOLD = 1500.0;
    private static final double MIN_IGNITION_TEMPERATURE = 10000.0;
    private static final double MELTDOWN_TEMPERATURE = 5000000.0;
    private static final double BASE_HEATER_POWER = 1200.0;
    private static final double BASE_COOLING = 6000.0;
    private static final double COOLANT_PER_ITEM = 240000.0;
    private static final double PASSIVE_COOLING = 50.0;
    private static final double DENSITY_DECAY = 0.002;
    private static final double DENSITY_GAIN = 6.0E-4;
    private static final double MAX_DENSITY = 10.0;
    private static final int COOLANT_MB_PER_TICK = 50;
    private static final double COOLING_PER_MB = 120.0;
    private double temperatureK = 300.0;
    private double density = 0.0;
    private double bField = 0.0;
    private double confinementScore = 0.0;
    private double instability = 0.0;
    private boolean structureValid = false;
    private boolean burning = false;
    private boolean manualLock = false;
    private int recheckTicker = 0;
    private double fuelD = 0.0;
    private double fuelT = 0.0;
    private double coolantBuffer = 0.0;
    private final BasicEnergyContainer energy = new BasicEnergyContainer(10000000L);
    private final BasicFluidHandler fluids = new BasicFluidHandler().addTank(16000, Mode.INPUT).addTank(16000, Mode.OUTPUT);
    private final LazyOptional<BasicFluidHandler> fluidOptional = LazyOptional.of(() -> this.fluids);
    private final ContainerData containerData = new SimpleContainerData(6){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> MathUtils.clampToInt(TokamakControllerBlockEntity.this.bField * 100.0);
                case 1 -> MathUtils.clampToInt(TokamakControllerBlockEntity.this.temperatureK / 100.0);
                case 2 -> MathUtils.clampToInt(TokamakControllerBlockEntity.this.density * 10000.0);
                case 3 -> MathUtils.clampToInt(TokamakControllerBlockEntity.this.confinementScore * 100.0);
                case 4 -> MathUtils.clampToInt(TokamakControllerBlockEntity.this.energy.getEnergy());
                case 5 -> {
                    if (TokamakControllerBlockEntity.this.burning) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
        }
    };

    public TokamakControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityType.TOKAMAK_CONTROLLER.get(), pos, state);
        this.items = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);
        this.capabilitiesContent.addCapability(ForgeCapabilities.ITEM_HANDLER, this);
        this.capabilitiesContent.addCapability(HBMCaps.LONG_ENERGY, new ProxyEnergyHandler(this.energy));
        this.capabilitiesContent.addCapability(ForgeCapabilities.ENERGY, new HybridEnergyStorage(this.energy));
        this.capabilitiesContent.addCapability(ForgeCapabilities.FLUID_HANDLER, this.fluids);
        this.energy.setListener(this);
        this.slotModes = new ModeBuilder().addModes(new Object[]{3, Mode.INPUT, 1, Mode.NONE, 1, Mode.OUTPUT, 1, Mode.BOTH}).get();
        this.fluids.getFluidTanks().set(0, new FluidTank(16000){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().m_6212_((Fluid)ModFluids.COOLANT.source().get()) || stack.getFluid().m_6212_((Fluid)ModFluids.IRRADIATED_WATER.source().get()) || stack.getFluid().m_6212_((Fluid)Fluids.f_76193_);
            }
        });
        this.fluids.getFluidTanks().set(1, new FluidTank(16000){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().m_6212_((Fluid)ModFluids.SPENT_STEAM.source().get());
            }
        });
    }

    @Override
    protected void onUpdateServer() {
        boolean unstable;
        boolean canIgnite;
        boolean hasFuel;
        Level level = this.m_58904_();
        if (level == null) {
            return;
        }
        if (++this.recheckTicker % 20 == 0) {
            this.structureValid = this.validateStructure();
        }
        this.refuelFromItems();
        this.refillCoolant();
        double totalCoilCurrent = this.computeCoilCurrent(level);
        this.bField = 0.75 * totalCoilCurrent / (Math.max(4.0, 0.1) * 24.0);
        double heaterPower = this.computeHeaterPower(level);
        double volume = this.torusVolume();
        double heating = heaterPower;
        double cooling = this.computeCooling();
        this.temperatureK = Math.max(0.0, this.temperatureK + heating - cooling);
        this.density = Math.max(0.0, this.density * 0.998);
        this.confinementScore = this.bField * Math.sqrt(Math.max(this.temperatureK, 0.0));
        boolean bl = hasFuel = this.fuelD > 0.0 && this.fuelT > 0.0;
        if (this.manualLock || !this.structureValid || !hasFuel || this.temperatureK < 10000.0) {
            this.burning = false;
        }
        boolean bl2 = canIgnite = this.structureValid && hasFuel && this.temperatureK >= 10000.0 && this.confinementScore >= 1500.0 && !this.manualLock;
        if (!this.burning && canIgnite) {
            this.burning = true;
        }
        double fusionPower = 0.0;
        if (this.burning) {
            fusionPower = 2.0E-9 * this.density * this.temperatureK * this.temperatureK * volume;
            double fuelUse = 5.0E-4 + fusionPower * 1.0E-7;
            this.fuelD = Math.max(0.0, this.fuelD - fuelUse);
            this.fuelT = Math.max(0.0, this.fuelT - fuelUse);
            this.density = Math.min(10.0, this.density + 6.0E-4);
            this.temperatureK += fusionPower / 5000.0;
            long toStore = (long)Math.min(fusionPower, (double)this.energy.getNeeded());
            if (toStore > 0L) {
                this.energy.receive(toStore, false);
            } else {
                this.instability += 0.05;
            }
        }
        this.instability += this.computeInstability(fusionPower);
        this.instability = Math.max(0.0, this.instability - 0.005);
        boolean overheated = this.temperatureK > 5000000.0;
        boolean bl3 = unstable = this.burning && this.instability > 1.2;
        if (overheated || unstable) {
            this.triggerMeltdown();
        }
        TransmitUtils.outputOnly(this);
        TransmitUtils.chargeItem(this, (ItemStack)this.items.get(5));
        this.networkPackNT(64);
        this.m_6596_();
    }

    @Override
    protected void onUpdateClient() {
        super.onUpdateClient();
    }

    public boolean validateStructure() {
        Level level = this.m_58904_();
        if (level == null) {
            return false;
        }
        int scanRadius = Mth.m_14165_((double)5.0);
        int ringRadius = (int)Math.round(4.0);
        int coils = 0;
        for (int dx = -scanRadius; dx <= scanRadius; ++dx) {
            for (int dz = -scanRadius; dz <= scanRadius; ++dz) {
                BlockPos pos;
                if (!TokamakControllerBlockEntity.isCoilRingPosition(dx, dz, ringRadius) || !(level.m_8055_(pos = this.f_58858_.m_7918_(dx, 0, dz)).m_60734_() instanceof TokamakCoilBlock)) continue;
                ++coils;
            }
        }
        return coils >= 16;
    }

    private double computeCoilCurrent(Level level) {
        double sum = 0.0;
        int scanRadius = Mth.m_14165_((double)5.0);
        int ringRadius = (int)Math.round(4.0);
        for (int dx = -scanRadius; dx <= scanRadius; ++dx) {
            for (int dz = -scanRadius; dz <= scanRadius; ++dz) {
                BlockPos pos;
                BlockState state;
                if (!TokamakControllerBlockEntity.isCoilRingPosition(dx, dz, ringRadius) || !((state = level.m_8055_(pos = this.f_58858_.m_7918_(dx, 0, dz))).m_60734_() instanceof TokamakCoilBlock)) continue;
                int strength = (Integer)state.m_61143_((Property)TokamakCoilBlock.STRENGTH);
                sum += 50.0 * (double)strength;
            }
        }
        return sum;
    }

    private static boolean isCoilRingPosition(int dx, int dz, int ringRadius) {
        if (dx == 0 && dz == 0) {
            return false;
        }
        int chebyshev = Math.max(Math.abs(dx), Math.abs(dz));
        if (chebyshev == ringRadius) {
            return true;
        }
        double radius = Math.sqrt((double)dx * (double)dx + (double)dz * (double)dz);
        return Math.abs(radius - 4.0) <= 0.45;
    }

    private double computeHeaterPower(Level level) {
        double heaters = 0.0;
        for (BlockPos p : BlockPos.m_121925_((BlockPos)this.f_58858_, (int)3, (int)3, (int)3)) {
            BlockState state = level.m_8055_(p);
            if (!(state.m_60734_() instanceof TokamakHeaterBlock)) continue;
            heaters += (Boolean)state.m_61143_((Property)TokamakHeaterBlock.ACTIVE) != false ? 1.0 : 0.25;
        }
        return heaters * 1200.0;
    }

    private double computeCooling() {
        double cooling = 50.0;
        if (this.coolantBuffer > 0.0) {
            double used = Math.min(this.coolantBuffer, 6000.0);
            cooling += used;
            this.coolantBuffer -= used;
        }
        return cooling;
    }

    private double drainCoolantFromTank() {
        FluidTank coolant = this.fluids.getFluidTanks().get(0);
        FluidTank steam = this.fluids.getFluidTanks().get(1);
        if (coolant.isEmpty()) {
            return 0.0;
        }
        int steamSpace = steam.getCapacity() - steam.getFluidAmount();
        if (steamSpace <= 0) {
            return 0.0;
        }
        int mb = Math.min(50, Math.min(coolant.getFluidAmount(), steamSpace));
        if (mb <= 0) {
            return 0.0;
        }
        coolant.drain(mb, IFluidHandler.FluidAction.EXECUTE);
        steam.fill(new FluidStack((Fluid)ModFluids.SPENT_STEAM.source().get(), mb), IFluidHandler.FluidAction.EXECUTE);
        return (double)mb * 120.0;
    }

    private void refuelFromItems() {
        Item deuteriumCell = (Item)HBMComponent.CELL_DEUTERIUM.get();
        Item tritiumCell = (Item)HBMComponent.CELL_TRITIUM.get();
        Item emptyCell = (Item)HBMComponent.CELL_EMPTY.get();
        ItemStack dStack = (ItemStack)this.items.get(0);
        ItemStack tStack = (ItemStack)this.items.get(1);
        if (this.fuelD < 1.0 && dStack.m_150930_(deuteriumCell)) {
            this.fuelD += 1.0;
            dStack.m_41774_(1);
            this.pushByproduct(new ItemStack((ItemLike)emptyCell));
        }
        if (this.fuelT < 1.0 && tStack.m_150930_(tritiumCell)) {
            this.fuelT += 1.0;
            tStack.m_41774_(1);
            this.pushByproduct(new ItemStack((ItemLike)emptyCell));
        }
        this.items.set(0, (Object)dStack);
        this.items.set(1, (Object)tStack);
    }

    private void refillCoolant() {
        ItemStack coolant = (ItemStack)this.items.get(2);
        if (this.coolantBuffer < 6000.0 && !coolant.m_41619_()) {
            this.coolantBuffer += 240000.0;
            coolant.m_41774_(1);
            this.items.set(2, (Object)coolant);
        }
    }

    private double computeInstability(double fusionPower) {
        if (!this.burning) {
            return 0.0;
        }
        double instab = 0.0;
        if (!this.structureValid) {
            instab += 0.25;
        }
        if (this.temperatureK >= 10000.0) {
            if (this.coolantBuffer <= 0.0) {
                instab += 0.03;
            }
            if (this.bField < 4.0) {
                instab += 0.05;
            }
            if (fusionPower > 0.0 && this.energy.getNeeded() <= 0L) {
                instab += 0.05;
            }
        }
        return instab;
    }

    private double torusVolume() {
        return 202.12949813431007;
    }

    private void triggerMeltdown() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.burning = false;
        this.instability = 0.0;
        this.f_58857_.m_254849_(null, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, 6.0f, Level.ExplosionInteraction.BLOCK);
        for (BlockPos p : BlockPos.m_121925_((BlockPos)this.f_58858_, (int)2, (int)2, (int)2)) {
            BlockState state = this.f_58857_.m_8055_(p);
            if (state.m_60795_()) continue;
            this.f_58857_.m_46961_(p, false);
        }
        this.f_58857_.m_7731_(this.f_58858_, Blocks.f_49991_.m_49966_(), 3);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos firePos = this.f_58858_.m_121945_(direction);
            if (!this.f_58857_.m_8055_(firePos).m_60795_() || !this.f_58857_.m_8055_(firePos.m_7495_()).m_60804_((BlockGetter)this.f_58857_, firePos.m_7495_())) continue;
            this.f_58857_.m_7731_(firePos, Blocks.f_50083_.m_49966_(), 3);
        }
        this.temperatureK = 1500.0;
        this.density = 0.0;
        this.fuelT = 0.0;
        this.fuelD = 0.0;
    }

    private void pushByproduct(ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        int outputSlot = 4;
        ItemStack existing = (ItemStack)this.items.get(4);
        if (existing.m_41619_()) {
            this.items.set(4, (Object)stack);
            return;
        }
        if (!ItemStack.m_150942_((ItemStack)existing, (ItemStack)stack)) {
            this.dropStack(stack);
            return;
        }
        int max = Math.min(existing.m_41741_(), this.m_6893_());
        int space = max - existing.m_41613_();
        if (space <= 0) {
            this.dropStack(stack);
            return;
        }
        int toAdd = Math.min(space, stack.m_41613_());
        existing.m_41769_(toAdd);
        stack.m_41774_(toAdd);
        this.items.set(4, (Object)existing);
        if (!stack.m_41619_()) {
            this.dropStack(stack);
        }
    }

    private void dropStack(ItemStack stack) {
        if (this.f_58857_ == null || stack.m_41619_()) {
            return;
        }
        Containers.m_18992_((Level)this.f_58857_, (double)((double)this.f_58858_.m_123341_() + 0.5), (double)((double)this.f_58858_.m_123342_() + 1.0), (double)((double)this.f_58858_.m_123343_() + 0.5), (ItemStack)stack);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.temperatureK = tag.m_128459_("temp");
        this.density = tag.m_128459_("density");
        this.bField = tag.m_128459_("bField");
        this.confinementScore = tag.m_128459_("score");
        this.instability = tag.m_128459_("instability");
        this.fuelD = tag.m_128459_("fuelD");
        this.fuelT = tag.m_128459_("fuelT");
        this.coolantBuffer = tag.m_128459_("coolant");
        this.burning = tag.m_128471_("burning");
        this.manualLock = tag.m_128471_("manualLock");
        this.energy.deserializeNBT(tag.m_128469_("energy"));
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128347_("temp", this.temperatureK);
        tag.m_128347_("density", this.density);
        tag.m_128347_("bField", this.bField);
        tag.m_128347_("score", this.confinementScore);
        tag.m_128347_("instability", this.instability);
        tag.m_128347_("fuelD", this.fuelD);
        tag.m_128347_("fuelT", this.fuelT);
        tag.m_128347_("coolant", this.coolantBuffer);
        tag.m_128379_("burning", this.burning);
        tag.m_128379_("manualLock", this.manualLock);
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        tag.m_128365_("fluids", (Tag)this.fluids.serializeNBT());
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)HBMLang.TOKAMAK.key());
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new TokamakMenu(containerId, inventory, (Container)this, this.containerData);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        Item deuteriumCell = (Item)HBMComponent.CELL_DEUTERIUM.get();
        Item tritiumCell = (Item)HBMComponent.CELL_TRITIUM.get();
        if (index == 0) {
            return stack.m_150930_(deuteriumCell);
        }
        if (index == 1) {
            return stack.m_150930_(tritiumCell);
        }
        if (index == 2) {
            return !stack.m_204117_(ModTags.Items.BATTERY) && !stack.getCapability(HBMCaps.LONG_ENERGY).isPresent() && !stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
        }
        if (index == 5) {
            return stack.m_204117_(ModTags.Items.BATTERY) || stack.getCapability(HBMCaps.LONG_ENERGY).isPresent() || stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
        }
        return false;
    }

    @Override
    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction side) {
        return this.m_7013_(index, stack);
    }

    public float getPlasmaRadius() {
        return (float)Mth.m_14008_((double)(this.temperatureK / 5000000.0 * (double)1.2f), (double)0.2f, (double)1.25);
    }

    public float getBrightness() {
        return (float)Mth.m_14008_((double)(this.confinementScore / 3000.0), (double)0.0, (double)1.0);
    }

    public float getSwirlSpeed() {
        return this.burning ? 0.8f : 0.2f;
    }

    public float getInstabilityFactor() {
        return (float)Mth.m_14008_((double)this.instability, (double)0.0, (double)1.5);
    }

    public ContainerData getContainerData() {
        return this.containerData;
    }

    public void setManualRunning(boolean start) {
        if (start) {
            this.manualLock = false;
        } else {
            this.manualLock = true;
            this.burning = false;
        }
        this.m_6596_();
        this.sendUpdatePacket();
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (side != null && this.f_58857_ != null) {
            Block block = this.f_58857_.m_8055_(this.f_58858_.m_121945_(side)).m_60734_();
            boolean isPort = block instanceof TokamakPortBlock;
            boolean isInjector = block instanceof TokamakInjectorBlock;
            if (cap == ForgeCapabilities.FLUID_HANDLER || cap == HBMCaps.LONG_ENERGY || cap == ForgeCapabilities.ENERGY ? !isPort : cap == ForgeCapabilities.ITEM_HANDLER && !isInjector) {
                return LazyOptional.empty();
            }
        }
        return super.getCapability(cap, side);
    }
}

