/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.weapon;

import com.hbm.HBMLang;
import com.hbm.api.Mode;
import com.hbm.api.energy.BasicEnergyContainer;
import com.hbm.api.energy.TransmitUtils;
import com.hbm.api.fluid.BasicFluidHandler;
import com.hbm.block.weapon.IBomb;
import com.hbm.blockentity.IRadarCommandReceiver;
import com.hbm.blockentity.base2.DummyableBlockEntity;
import com.hbm.entity.weapon.missile.EntityMissileAntiBallistic;
import com.hbm.item.HBMWeapon;
import com.hbm.item.weapon.ItemDesignator;
import com.hbm.item.weapon.ItemMissile;
import com.hbm.registries.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public abstract class EntityLaunchPadBase
extends DummyableBlockEntity
implements IRadarCommandReceiver {
    public ItemStack toRender;
    public static final long maxPower = 100000L;
    public int state = 0;
    public static final int STATE_MISSING = 0;
    public static final int STATE_LOADING = 1;
    public static final int STATE_READY = 2;
    protected BasicEnergyContainer energyContainer;
    protected BasicFluidHandler fluidHandler;

    public EntityLaunchPadBase(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState, int slotNum) {
        super(pType, pPos, pBlockState);
        this.items = NonNullList.m_122780_((int)slotNum, (Object)ItemStack.f_41583_);
        this.fluidHandler = new BasicFluidHandler().addTanks(2, 24000, Mode.INPUT);
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)HBMLang.CONTAINER_LAUNCHPAD.key());
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        TransmitUtils.dischargeItem(this, this.m_8020_(2));
        this.toRender = this.m_8020_(0);
        this.sendUpdatePacket();
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag tag = new CompoundTag();
        if (this.toRender != null) {
            tag.m_128365_("item", (Tag)this.toRender.serializeNBT());
        }
        return tag;
    }

    @Override
    public void handleUpdatePacket(@NotNull CompoundTag tag) {
        CompoundTag tag1 = tag.m_128469_("item");
        if (!tag1.m_128456_()) {
            this.toRender = ItemStack.m_41712_((CompoundTag)tag1);
        }
    }

    @Override
    public boolean m_6542_(Player pPlayer) {
        if (this.f_58857_.m_7702_(this.getTilePos()) != this) {
            return false;
        }
        return pPlayer.m_20238_(this.getTilePos().m_252807_()) <= 128.0 && super.m_6542_(pPlayer);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.energyContainer.deserializeNBT(nbt.m_128469_("energy"));
        this.fluidHandler.deserializeNBT(nbt.m_128469_("fluids"));
    }

    @Override
    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("energy", (Tag)this.energyContainer.serializeNBT());
        pTag.m_128365_("fluids", (Tag)this.fluidHandler.serializeNBT());
    }

    @Override
    public BasicEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    public BasicFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    public boolean isMissileValid() {
        return !this.m_8020_(0).m_41619_() && this.isMissileValid(this.m_8020_(0));
    }

    public boolean isMissileValid(ItemStack stack) {
        return stack.m_41720_() instanceof ItemMissile && ((ItemMissile)stack.m_41720_()).launchable;
    }

    public boolean hasFuel() {
        return true;
    }

    public Entity instantiateMissile(int targetX, int targetZ) {
        if (this.m_8020_(0).m_41619_()) {
            return null;
        }
        ItemStack item = this.m_8020_(0);
        Item item2 = item.m_41720_();
        if (item2 instanceof ItemMissile) {
            ItemMissile itemMissile = (ItemMissile)item2;
            Vec3 posCenter = this.f_58858_.m_252807_();
            if (itemMissile == HBMWeapon.MISSILE_ANTI_BALLISTIC.get()) {
                EntityMissileAntiBallistic missile = new EntityMissileAntiBallistic(this.f_58857_);
                missile.m_6034_(posCenter.f_82479_, (double)this.f_58858_.m_123342_() + this.getLaunchOffset(), posCenter.f_82481_);
                return missile;
            }
            Object entityMissile = itemMissile.missileCreator.create(this.f_58857_, (float)posCenter.f_82479_, (float)((double)this.f_58858_.m_123342_() + this.getLaunchOffset()), (float)posCenter.f_82481_, new BlockPos(targetX, this.f_58858_.m_123342_(), targetZ));
            return entityMissile;
        }
        return null;
    }

    public void finalizeLaunch(Entity missile) {
        Item item;
        this.f_58857_.m_7967_(missile);
        this.f_58857_.m_6263_(null, (double)this.getTilePos().m_123341_() + 0.5, (double)this.getTilePos().m_123342_(), (double)this.getTilePos().m_123343_() + 0.5, (SoundEvent)ModSounds.WEAPON_MISSILE_TAKE_OFF.get(), SoundSource.AMBIENT, 2.0f, 1.0f);
        this.energyContainer.extract(75000L, false);
        ItemStack itemStack = this.m_8020_(0);
        if (!itemStack.m_41619_() && (item = itemStack.m_41720_()) instanceof ItemMissile) {
            ItemMissile itemMissile = (ItemMissile)item;
            this.fluidHandler.getFluidTanks().get(0).drain(itemMissile.fuelCap, IFluidHandler.FluidAction.EXECUTE);
            this.fluidHandler.getFluidTanks().get(1).drain(itemMissile.fuelCap, IFluidHandler.FluidAction.EXECUTE);
        }
        this.m_8020_(0).m_41774_(1);
    }

    public IBomb.BombReturnCode launchFromDesignator() {
        if (!this.canLaunch()) {
            return IBomb.BombReturnCode.ERROR_MISSING_COMPONENT;
        }
        boolean needsDesignator = this.needsDesignator(this.m_8020_(0).m_41720_());
        int targetX = this.f_58858_.m_123341_();
        int targetZ = this.f_58858_.m_123343_();
        ItemStack itemStack = this.m_8020_(1);
        if (needsDesignator) {
            Item item;
            if (!itemStack.m_41619_() && (item = itemStack.m_41720_()) instanceof ItemDesignator) {
                ItemDesignator designator = (ItemDesignator)item;
                if (!designator.isReady(this.f_58857_, itemStack, this.f_58858_)) {
                    return IBomb.BombReturnCode.ERROR_MISSING_COMPONENT;
                }
                Vec3 coords = designator.getCoords(this.f_58857_, itemStack, this.f_58858_);
                targetX = (int)Math.floor(coords.f_82479_);
                targetZ = (int)Math.floor(coords.f_82481_);
            } else {
                return IBomb.BombReturnCode.ERROR_MISSING_COMPONENT;
            }
        }
        return this.launchToCoordinate(targetX, targetZ);
    }

    public IBomb.BombReturnCode launchToEntity(Entity entity) {
        if (!this.canLaunch()) {
            return IBomb.BombReturnCode.ERROR_MISSING_COMPONENT;
        }
        Entity e = this.instantiateMissile(entity.m_146903_(), entity.m_146907_());
        if (e != null) {
            this.finalizeLaunch(e);
            return IBomb.BombReturnCode.LAUNCHED;
        }
        return IBomb.BombReturnCode.ERROR_MISSING_COMPONENT;
    }

    public IBomb.BombReturnCode launchToCoordinate(int targetX, int targetZ) {
        if (!this.canLaunch()) {
            return IBomb.BombReturnCode.ERROR_MISSING_COMPONENT;
        }
        Entity e = this.instantiateMissile(targetX, targetZ);
        if (e != null) {
            this.finalizeLaunch(e);
            return IBomb.BombReturnCode.LAUNCHED;
        }
        return IBomb.BombReturnCode.ERROR_MISSING_COMPONENT;
    }

    @Override
    public boolean sendCommandPosition(int x, int y, int z) {
        return this.launchToCoordinate(x, z) == IBomb.BombReturnCode.LAUNCHED;
    }

    @Override
    public boolean sendCommandEntity(Entity target) {
        return this.launchToEntity(target) == IBomb.BombReturnCode.LAUNCHED;
    }

    public boolean needsDesignator(Item item) {
        return item != HBMWeapon.MISSILE_ANTI_BALLISTIC.get();
    }

    public boolean canLaunch() {
        return this.isMissileValid() && this.isReadyForLaunch();
    }

    public int getFuelState() {
        return this.getGaugeState(0);
    }

    public int getOxidizerState() {
        return this.getGaugeState(1);
    }

    public int getGaugeState(int tank) {
        Item item;
        ItemStack itemStack = this.m_8020_(0);
        if (!itemStack.m_41619_() && (item = itemStack.m_41720_()) instanceof ItemMissile) {
            ItemMissile missile = (ItemMissile)item;
            ItemMissile.MissileFuel fuel = missile.fuel;
            if (fuel == ItemMissile.MissileFuel.SOLID) {
                return 0;
            }
            return this.fluidHandler.getFluidInTank(tank).getAmount() >= missile.fuelCap ? 1 : -1;
        }
        return 0;
    }

    public void updateRedstonePower(BlockPos pPos) {
    }

    public abstract boolean isReadyForLaunch();

    public abstract double getLaunchOffset();
}

