/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.weapon;

import com.hbm.api.Mode;
import com.hbm.api.energy.BasicEnergyContainer;
import com.hbm.api.energy.HybridEnergyStorage;
import com.hbm.api.energy.ProxyEnergyHandler;
import com.hbm.api.inventory.ModeBuilder;
import com.hbm.block.HBMMachine;
import com.hbm.block.weapon.LaunchPad;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.blockentity.weapon.EntityLaunchPadBase;
import com.hbm.capabilities.HBMCaps;
import com.hbm.entity.projectile.EntityThrowableNT;
import com.hbm.gui.menu.LaunchPadMenu;
import com.hbm.utils.multiblock.MultiblockData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.NotNull;

public class LaunchPadTileEntity
extends EntityLaunchPadBase {
    private final HybridEnergyStorage forgeEnergy;
    protected ContainerData containerData = new ContainerData(){

        public int m_6413_(int pIndex) {
            return 0;
        }

        public void m_8050_(int pIndex, int pValue) {
        }

        public int m_6499_() {
            return 0;
        }
    };
    public int delay = 0;

    public LaunchPadTileEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntityType.LAUNCHPAD_ENTITY.get(), pPos, pBlockState, 7);
        this.slotModes = new ModeBuilder().addModes(new Object[]{7, Mode.BOTH}).get();
        this.energyContainer = new BasicEnergyContainer(100000L, 100000L, 0L, 0L);
        this.forgeEnergy = new HybridEnergyStorage(this.energyContainer);
        this.capabilitiesContent.addCapability(HBMCaps.LONG_ENERGY, new ProxyEnergyHandler(this.energyContainer));
        this.capabilitiesContent.addCapability(ForgeCapabilities.ENERGY, this.forgeEnergy);
        this.capabilitiesContent.addCapability(ForgeCapabilities.FLUID_HANDLER, this.fluidHandler);
        this.multiblockData = MultiblockData.mapping.get(HBMMachine.LAUNCH_PAD.get());
    }

    @Override
    public boolean isReadyForLaunch() {
        return this.delay <= 0;
    }

    @Override
    public double getLaunchOffset() {
        return 1.0;
    }

    @Override
    protected void onUpdateServer() {
        if (this.delay > 0) {
            --this.delay;
        }
        if (!this.isMissileValid() || !this.hasFuel()) {
            this.delay = 100;
            this.toRender = this.m_8020_(0);
        }
        this.state = !this.hasFuel() || !this.isMissileValid() ? 0 : (this.delay > 0 ? 1 : 2);
        super.onUpdateServer();
    }

    @Override
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory) {
        return new LaunchPadMenu(pContainerId, pInventory, (Container)this, this.containerData);
    }

    @Override
    protected void onUpdateClient() {
        Vec3 center = this.getTilePos().m_252807_();
        List missiles = this.f_58857_.m_45976_(EntityThrowableNT.class, new AABB(center.f_82479_ - 0.5, center.f_82480_, center.f_82481_ - 0.5, center.f_82479_ + 1.5, center.f_82480_, center.f_82481_ + 1.5));
        for (EntityThrowableNT missile : missiles) {
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)LaunchPad.FACING);
            for (int i = 0; i < 15; ++i) {
                Direction dir = this.f_58857_.f_46441_.m_188499_() ? facing : facing.m_122424_();
                float moX = (float)(this.f_58857_.f_46441_.m_188583_() * (double)0.15f + 0.75) * (float)dir.m_122429_();
                float f = (float)(this.f_58857_.f_46441_.m_188583_() * (double)0.15f + 0.75) * (float)dir.m_122431_();
            }
        }
    }

    @Override
    public void finalizeLaunch(Entity missile) {
        super.finalizeLaunch(missile);
        this.delay = 100;
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.delay = nbt.m_128451_("delay");
    }

    @Override
    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("delay", this.delay);
    }
}

