/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.capabilities;

import com.hbm.api.energy.IEnergyHandler;
import com.hbm.capabilities.HBMCaps;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class CapabilitiesContent {
    private final Map<Capability<?>, Object> handlerMap = new IdentityHashMap();
    private final Map<Capability<?>, LazyOptional<?>> lazyOptionalMap = new IdentityHashMap();
    private final Map<Capability<?>, List<Direction>> sideMap = new IdentityHashMap();

    public <T> void addCapability(Capability<T> capability, T handler) {
        if (!this.lazyOptionalMap.containsKey(capability)) {
            this.handlerMap.put(capability, handler);
            this.lazyOptionalMap.put(capability, LazyOptional.of(() -> handler));
            this.sideMap.put(capability, List.of(Direction.values()));
        }
    }

    public <T> void addCapability(Capability<T> capability, T handler, Direction ... sides) {
        if (!this.lazyOptionalMap.containsKey(capability)) {
            this.handlerMap.put(capability, handler);
            this.lazyOptionalMap.put(capability, LazyOptional.of(() -> handler));
            this.sideMap.put(capability, Arrays.stream(sides).toList());
        }
    }

    public void addCapability(Capability<?> capability, Object handler, Set<Direction> directions) {
        Direction[] directionsArray = directions.toArray(new Direction[0]);
        if (directions.contains(null)) {
            directionsArray = new Direction[]{null};
        }
        if (capability == HBMCaps.LONG_ENERGY && handler instanceof IEnergyHandler || capability == ForgeCapabilities.FLUID_HANDLER && handler instanceof IFluidHandler || capability == ForgeCapabilities.ITEM_HANDLER && handler instanceof IItemHandler) {
            this.plusCapability(capability, handler, directionsArray);
        }
    }

    private void plusCapability(Capability<?> capability, Object handler, Direction[] directionsArray) {
        if (!this.lazyOptionalMap.containsKey(capability)) {
            this.handlerMap.put(capability, handler);
            this.lazyOptionalMap.put(capability, LazyOptional.of(() -> handler));
            this.sideMap.put(capability, Arrays.stream(directionsArray).toList());
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (this.lazyOptionalMap.containsKey(capability) && (side == null || this.sideMap.get(capability).contains(side))) {
            LazyOptional<?> lazyOptional = this.lazyOptionalMap.get(capability);
            if (lazyOptional.isPresent()) {
                return lazyOptional.cast();
            }
            Object object = this.handlerMap.get(capability);
            if (object != null) {
                LazyOptional optional2 = LazyOptional.of(() -> object);
                this.lazyOptionalMap.put(capability, optional2);
                return optional2.cast();
            }
        }
        return LazyOptional.empty();
    }

    public <T> void invalidate(Capability<T> capability) {
        if (this.lazyOptionalMap.containsKey(capability)) {
            this.lazyOptionalMap.get(capability).invalidate();
        }
    }

    public void invalidateAll() {
        this.lazyOptionalMap.forEach((capability, optional) -> optional.invalidate());
    }
}

