/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.capabilities;

import com.hbm.HBM;
import com.hbm.blockentity.base.DummibleBlockEntity;
import com.hbm.capabilities.resolver.ICapabilityResolver;
import com.hbm.utils.multiblock.HBMMultiData;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class CapabilityCache
implements INBTSerializable<CompoundTag> {
    public static String STOREKEY = "blockCapabilities";
    private final Map<Capability<?>, ICapabilityResolver> capabilityResolvers = new IdentityHashMap();
    private final List<ICapabilityResolver> uniqueResolvers = new ArrayList<ICapabilityResolver>();
    private final Set<Capability<?>> alwaysDisabled = new ReferenceOpenHashSet();
    private final Map<Capability<?>, List<BooleanSupplier>> semiDisabled = new IdentityHashMap();
    public static final Map<Capability<?>, String> CAPABILITY_NAME = new IdentityHashMap();

    public void addCapabilityResolver(ICapabilityResolver resolver) {
        if (resolver == null) {
            return;
        }
        this.uniqueResolvers.add(resolver);
        List<Capability<?>> supportedCapabilities = resolver.getSupportedCapabilities();
        for (Capability<?> supportedCapability : supportedCapabilities) {
            if (this.capabilityResolvers.put(supportedCapability, resolver) == null) continue;
            HBM.LOGGER.warn("Multiple capability resolvers registered for {}. Overriding", (Object)supportedCapability.getName(), (Object)new Exception());
        }
    }

    public void addDisabledCapabilities(Capability<?> ... capabilities) {
        Collections.addAll(this.alwaysDisabled, capabilities);
    }

    public void addDisabledCapabilities(Collection<Capability<?>> capabilities) {
        this.alwaysDisabled.addAll(capabilities);
    }

    public void addSemiDisabledCapability(Capability<?> capability, BooleanSupplier checker) {
        this.semiDisabled.computeIfAbsent(capability, cap -> new ArrayList()).add(checker);
    }

    public boolean isCapabilityDisabled(Capability<?> capability, @Nullable Direction side) {
        if (!capability.isRegistered() || this.alwaysDisabled.contains(capability)) {
            return true;
        }
        if (this.semiDisabled.containsKey(capability)) {
            List<BooleanSupplier> predicates = this.semiDisabled.get(capability);
            for (BooleanSupplier predicate : predicates) {
                if (!predicate.getAsBoolean()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canResolve(Capability<?> capability) {
        return this.capabilityResolvers.containsKey(capability);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (!this.isCapabilityDisabled(capability, side) && this.canResolve(capability)) {
            return this.getCapabilityUnchecked(capability, side);
        }
        return LazyOptional.empty();
    }

    public <T> LazyOptional<T> getCapabilityUnchecked(Capability<T> capability, @Nullable Direction side) {
        ICapabilityResolver capabilityResolver = this.capabilityResolvers.get(capability);
        if (capabilityResolver == null) {
            return LazyOptional.empty();
        }
        return capabilityResolver.resolve(capability, side);
    }

    public void validate(Capability<?> capability, @Nullable Direction side) {
        ICapabilityResolver capabilityResolver = this.capabilityResolvers.get(capability);
        if (capabilityResolver != null) {
            capabilityResolver.validate(capability, side);
        }
    }

    public void invalidate(Capability<?> capability, @Nullable Direction side) {
        ICapabilityResolver capabilityResolver = this.capabilityResolvers.get(capability);
        if (capabilityResolver != null) {
            capabilityResolver.invalidate(capability, side);
        }
    }

    public void invalidateSides(Capability<?> capability, Direction ... sides) {
        ICapabilityResolver capabilityResolver = this.capabilityResolvers.get(capability);
        if (capabilityResolver != null) {
            for (Direction side : sides) {
                capabilityResolver.invalidate(capability, side);
            }
        }
    }

    public void invalidateAll() {
        this.uniqueResolvers.forEach(ICapabilityResolver::invalidateAll);
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        for (Map.Entry<Capability<?>, ICapabilityResolver> entry : this.capabilityResolvers.entrySet()) {
            Object cap = entry.getValue().resolve(entry.getKey(), null).orElse(null);
            if (!(cap instanceof INBTSerializable)) continue;
            INBTSerializable serializable = (INBTSerializable)cap;
            compoundTag.m_128365_(CAPABILITY_NAME.get(entry.getKey()), serializable.serializeNBT());
        }
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        for (Map.Entry<Capability<?>, ICapabilityResolver> entry : this.capabilityResolvers.entrySet()) {
            Object cap = entry.getValue().resolve(entry.getKey(), null).orElse(null);
            if (!(cap instanceof INBTSerializable)) continue;
            INBTSerializable serializable = (INBTSerializable)cap;
            serializable.deserializeNBT(nbt.m_128423_(CAPABILITY_NAME.get(entry.getKey())));
        }
    }

    public void allocDummyBlockCaps(Level level, HBMMultiData multiblockData) {
        for (Map.Entry<Capability<?>, List<Tuple<BlockPos, Direction>>> entry : multiblockData.afterTrans.entrySet()) {
            Capability<?> capability = entry.getKey();
            for (Tuple<BlockPos, Direction> tuple : entry.getValue()) {
                BlockEntity blockEntity = level.m_7702_((BlockPos)tuple.m_14418_());
                if (!(blockEntity instanceof DummibleBlockEntity)) continue;
                DummibleBlockEntity dummibleBlock = (DummibleBlockEntity)blockEntity;
                dummibleBlock.setCaps(capability, this.capabilityResolvers.get(capability), (Direction)tuple.m_14419_());
            }
        }
    }

    static {
        CAPABILITY_NAME.put(ForgeCapabilities.ENERGY, "energy");
        CAPABILITY_NAME.put(ForgeCapabilities.FLUID_HANDLER, "fluids");
    }
}

