/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.capabilities;

import com.hbm.capabilities.CapabilityCache;
import com.hbm.capabilities.resolver.ICapabilityResolver;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemCapabilityWrapper
implements ICapabilityProvider {
    private final Map<Capability<?>, ItemCapability> capabilities = new IdentityHashMap();
    private final CapabilityCache capabilityCache = new CapabilityCache();
    protected final ItemStack itemStack;

    public ItemCapabilityWrapper(ItemStack stack, ItemCapability ... caps) {
        this.itemStack = stack;
        this.add(caps);
    }

    public void add(ItemCapability ... caps) {
        for (ItemCapability c : caps) {
            c.wrapper = this;
            c.init();
            c.gatherCapabilityResolvers(resolver -> {
                this.capabilityCache.addCapabilityResolver((ICapabilityResolver)resolver);
                this.capabilities.put(resolver.getSupportedCapabilities().get(0), c);
            });
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        if (!this.itemStack.m_41619_() && capability.isRegistered() && !this.capabilityCache.isCapabilityDisabled(capability, null) && this.capabilityCache.canResolve(capability)) {
            ItemCapability cap = this.capabilities.get(capability);
            if (cap != null) {
                cap.load();
            }
            return this.capabilityCache.getCapabilityUnchecked(capability, null);
        }
        return LazyOptional.empty();
    }

    public static abstract class ItemCapability {
        private ItemCapabilityWrapper wrapper;

        protected void gatherCapabilityResolvers(Consumer<ICapabilityResolver> consumer) {
        }

        protected void init() {
        }

        protected void load() {
        }

        public ItemStack getStack() {
            return this.wrapper.itemStack;
        }
    }
}

