/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.capabilities.network;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.hbm.HBM;
import com.hbm.api.Chunk3D;
import com.hbm.api.Coord4D;
import com.hbm.blockentity.base.TransmitterBlockEntity;
import com.hbm.capabilities.network.network.DynamicNetwork;
import com.hbm.capabilities.network.transmitter.Transmitter;
import com.hbm.capabilities.network.validator.CompatibleTransmitterValidator;
import com.hbm.utils.EnumUtils;
import com.hbm.utils.WorldUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.ChunkTicketLevelUpdatedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.Nullable;

public class TransmitterNetworkRegistry {
    private static final TransmitterNetworkRegistry INSTANCE = new TransmitterNetworkRegistry();
    private static boolean loaderRegistered = false;
    private final Multimap<Chunk3D, Transmitter<?, ?, ?>> transmitters = HashMultimap.create();
    private Map<Coord4D, Transmitter<?, ?, ?>> newOrphanTransmitters = new Object2ObjectOpenHashMap();
    private Set<Transmitter<?, ?, ?>> invalidTransmitters = new ObjectOpenHashSet();
    private Object2BooleanMap<Chunk3D> changedTicketChunks = new Object2BooleanOpenHashMap();
    private final Set<DynamicNetwork<?, ?, ?>> networks = new ObjectOpenHashSet();
    private final Map<UUID, DynamicNetwork<?, ?, ?>> clientNetworks = new Object2ObjectOpenHashMap();
    private Set<DynamicNetwork<?, ?, ?>> networksToChange = new ObjectOpenHashSet();

    public void addClientNetwork(UUID networkID, DynamicNetwork<?, ?, ?> network) {
        if (!this.clientNetworks.containsKey(networkID)) {
            this.clientNetworks.put(networkID, network);
        }
    }

    @Nullable
    public DynamicNetwork<?, ?, ?> getClientNetwork(UUID networkID) {
        return this.clientNetworks.get(networkID);
    }

    public void removeClientNetwork(DynamicNetwork<?, ?, ?> network) {
        this.clientNetworks.remove(network.getUUID());
    }

    public void clearClientNetworks() {
        this.clientNetworks.clear();
    }

    public static TransmitterNetworkRegistry getInstance() {
        return INSTANCE;
    }

    public static void initiate() {
        if (!loaderRegistered) {
            loaderRegistered = true;
            MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        }
    }

    public static void reset() {
        TransmitterNetworkRegistry.getInstance().networks.clear();
        TransmitterNetworkRegistry.getInstance().networksToChange.clear();
        TransmitterNetworkRegistry.getInstance().invalidTransmitters.clear();
        TransmitterNetworkRegistry.getInstance().newOrphanTransmitters.clear();
        TransmitterNetworkRegistry.getInstance().transmitters.clear();
        TransmitterNetworkRegistry.getInstance().changedTicketChunks.clear();
    }

    public static void trackTransmitter(Transmitter<?, ?, ?> transmitter) {
        TransmitterNetworkRegistry.getInstance().transmitters.put((Object)transmitter.getTileChunk(), transmitter);
    }

    public static void untrackTransmitter(Transmitter<?, ?, ?> transmitter) {
        TransmitterNetworkRegistry.getInstance().transmitters.remove((Object)transmitter.getTileChunk(), transmitter);
    }

    public static void invalidateTransmitter(Transmitter<?, ?, ?> transmitter) {
        TransmitterNetworkRegistry registry = TransmitterNetworkRegistry.getInstance();
        registry.invalidTransmitters.add(transmitter);
        Coord4D coord = transmitter.getTileCoord();
        Transmitter<?, ?, ?> removed = registry.newOrphanTransmitters.remove(coord);
        if (removed != null && removed != transmitter) {
            HBM.LOGGER.error("Different orphan transmitter was registered at location during removal! {}", (Object)coord);
            registry.newOrphanTransmitters.put(coord, transmitter);
        }
    }

    public static void registerOrphanTransmitter(Transmitter<?, ?, ?> transmitter) {
        Coord4D coord;
        Transmitter<?, ?, ?> previous;
        if (!TransmitterNetworkRegistry.getInstance().invalidTransmitters.remove(transmitter) && (previous = TransmitterNetworkRegistry.getInstance().newOrphanTransmitters.put(coord = transmitter.getTileCoord(), transmitter)) != null && previous != transmitter && previous.isValid()) {
            HBM.LOGGER.error("Different orphan transmitter was already registered at location! {}", (Object)coord);
        }
    }

    public static void registerChangedNetwork(DynamicNetwork<?, ?, ?> network) {
        TransmitterNetworkRegistry.getInstance().networksToChange.add(network);
    }

    public void registerNetwork(DynamicNetwork<?, ?, ?> network) {
        this.networks.add(network);
    }

    public void removeNetwork(DynamicNetwork<?, ?, ?> network) {
        this.networks.remove(network);
        this.networksToChange.remove(network);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side.isServer()) {
            this.handleChangedChunks();
            this.removeInvalidTransmitters();
            this.assignOrphans();
            this.commitChanges();
            for (DynamicNetwork<?, ?, ?> net : this.networks) {
                net.onUpdate();
            }
        }
    }

    @SubscribeEvent
    public void onTicketLevelChange(ChunkTicketLevelUpdatedEvent event) {
        boolean loaded;
        int newTicketLevel = event.getNewTicketLevel();
        int oldTicketLevel = event.getOldTicketLevel();
        if (oldTicketLevel > 32 && newTicketLevel <= 32) {
            loaded = true;
        } else if (newTicketLevel > 32 && oldTicketLevel <= 32) {
            loaded = false;
        } else {
            return;
        }
        Chunk3D chunk = new Chunk3D((ResourceKey<Level>)event.getLevel().m_46472_(), event.getChunkPos());
        if (this.transmitters.containsKey((Object)chunk)) {
            if (this.changedTicketChunks.getOrDefault((Object)chunk, loaded) != loaded) {
                this.changedTicketChunks.removeBoolean((Object)chunk);
            } else {
                this.changedTicketChunks.put((Object)chunk, loaded);
            }
        }
    }

    private void handleChangedChunks() {
        if (!this.changedTicketChunks.isEmpty()) {
            Object2BooleanMap<Chunk3D> changed = this.changedTicketChunks;
            this.changedTicketChunks = new Object2BooleanOpenHashMap();
            if (HBM.debug) {
                HBM.LOGGER.info("Dealing with {} changed chunks", (Object)changed.size());
            }
            for (Object2BooleanMap.Entry entry : changed.object2BooleanEntrySet()) {
                Chunk3D chunk = (Chunk3D)((Object)entry.getKey());
                boolean loaded = entry.getBooleanValue();
                Collection chunkTransmitters = this.transmitters.get((Object)chunk);
                for (Transmitter transmitter : chunkTransmitters) {
                    transmitter.getTransmitterTile().chunkAccessibilityChange(loaded);
                }
                if (!HBM.debug) continue;
                HBM.LOGGER.info("{} {} transmitters in chunk: {}, {}", new Object[]{loaded ? "Loaded" : "Unloaded", chunkTransmitters.size(), chunk.f_45578_, chunk.f_45579_});
            }
        }
    }

    private void removeInvalidTransmitters() {
        if (!this.invalidTransmitters.isEmpty()) {
            Set<Transmitter<?, ?, ?>> toInvalidate = this.invalidTransmitters;
            this.invalidTransmitters = new ObjectOpenHashSet();
            if (HBM.debug) {
                HBM.LOGGER.info("Dealing with {} invalid Transmitters", (Object)toInvalidate.size());
            }
            for (Transmitter<?, ?, ?> invalid : toInvalidate) {
                this.removeInvalidTransmitter(invalid);
            }
        }
    }

    private <NETWORK extends DynamicNetwork<?, NETWORK, TRANSMITTER>, TRANSMITTER extends Transmitter<?, NETWORK, TRANSMITTER>> void removeInvalidTransmitter(Transmitter<?, NETWORK, TRANSMITTER> invalid) {
        NETWORK n;
        if (!(invalid.isOrphan() && invalid.isValid() || (n = invalid.getTransmitterNetwork()) == null)) {
            ((DynamicNetwork)n).invalidate(invalid);
            if (!invalid.isValid()) {
                invalid.setTransmitterNetwork(null, false);
            }
        }
    }

    private void assignOrphans() {
        if (!this.newOrphanTransmitters.isEmpty()) {
            Map<Coord4D, Transmitter<?, ?, ?>> orphanTransmitters = this.newOrphanTransmitters;
            this.newOrphanTransmitters = new Object2ObjectOpenHashMap();
            if (HBM.debug) {
                HBM.LOGGER.info("Dealing with {} orphan Transmitters", (Object)orphanTransmitters.size());
            }
            for (Transmitter<?, ?, ?> orphanTransmitter : orphanTransmitters.values()) {
                if (!orphanTransmitter.isValid() || !orphanTransmitter.isOrphan()) continue;
                OrphanPathFinder finder = new OrphanPathFinder(orphanTransmitter);
                this.networksToChange.add((DynamicNetwork<?, ?, ?>)finder.getNetworkFromOrphan(orphanTransmitters));
            }
        }
    }

    private void commitChanges() {
        if (!this.networksToChange.isEmpty()) {
            Set<DynamicNetwork<?, ?, ?>> networks = this.networksToChange;
            this.networksToChange = new ObjectOpenHashSet();
            for (DynamicNetwork<?, ?, ?> network : networks) {
                network.commit();
            }
        }
    }

    public String toString() {
        return "Network Registry:\n" + String.valueOf(this.networks);
    }

    public Component[] toComponents() {
        Component[] components = new Component[this.networks.size()];
        int i = 0;
        for (DynamicNetwork<?, ?, ?> network : this.networks) {
            components[i++] = network.getTextComponent();
        }
        return components;
    }

    public static class OrphanPathFinder<ACCEPTOR, NETWORK extends DynamicNetwork<ACCEPTOR, NETWORK, TRANSMITTER>, TRANSMITTER extends Transmitter<ACCEPTOR, NETWORK, TRANSMITTER>> {
        private final CompatibleTransmitterValidator<ACCEPTOR, NETWORK, TRANSMITTER> transmitterValidator;
        private final Set<TRANSMITTER> connectedTransmitters = new ObjectOpenHashSet();
        private final Long2ObjectMap<ChunkAccess> chunkMap = new Long2ObjectOpenHashMap();
        private final Set<NETWORK> networksFound = new ObjectOpenHashSet();
        private final Set<BlockPos> iterated = new ObjectOpenHashSet();
        private final Deque<BlockPos> queue = new LinkedList<BlockPos>();
        private final TRANSMITTER startPoint;
        private final Level world;

        OrphanPathFinder(Transmitter<ACCEPTOR, NETWORK, TRANSMITTER> start) {
            this.startPoint = start;
            this.world = ((Transmitter)this.startPoint).getTileWorld();
            this.transmitterValidator = ((Transmitter)this.startPoint).getNewOrphanValidator();
        }

        NETWORK getNetworkFromOrphan(Map<Coord4D, Transmitter<?, ?, ?>> orphanTransmitters) {
            DynamicNetwork<ACCEPTOR, NETWORK, TRANSMITTER> network;
            if (this.queue.peek() != null) {
                HBM.LOGGER.error("OrphanPathFinder queue was not empty?!");
                this.queue.clear();
            }
            this.queue.push(((Transmitter)this.startPoint).getTilePos());
            while (this.queue.peek() != null) {
                this.iterate(orphanTransmitters, this.queue.removeFirst());
            }
            if (this.networksFound.size() == 1) {
                if (HBM.debug) {
                    HBM.LOGGER.info("Adding {} transmitters to single found network", (Object)this.connectedTransmitters.size());
                }
                network = (DynamicNetwork)this.networksFound.iterator().next();
            } else {
                if (HBM.debug) {
                    if (this.networksFound.isEmpty()) {
                        HBM.LOGGER.info("No networks found. Creating new network for {} transmitters", (Object)this.connectedTransmitters.size());
                    } else {
                        HBM.LOGGER.info("Merging {} networks with {} new transmitters", (Object)this.networksFound.size(), (Object)this.connectedTransmitters.size());
                    }
                }
                network = ((Transmitter)this.startPoint).createNetworkByMerging(this.networksFound);
            }
            network.addNewTransmitters(this.connectedTransmitters, this.transmitterValidator);
            return (NETWORK)network;
        }

        private void iterate(Map<Coord4D, Transmitter<?, ?, ?>> orphanTransmitters, BlockPos from) {
            if (this.iterated.add(from)) {
                Coord4D fromCoord = new Coord4D((Vec3i)from, this.world);
                Transmitter<?, ?, ?> transmitter = orphanTransmitters.get(fromCoord);
                if (transmitter != null) {
                    if (transmitter.isValid() && transmitter.isOrphan() && ((Transmitter)this.startPoint).supportsTransmissionType(transmitter) && this.transmitterValidator.isTransmitterCompatible(transmitter)) {
                        this.connectedTransmitters.add(transmitter);
                        transmitter.setOrphan(false);
                        for (Direction direction : EnumUtils.DIRECTIONS) {
                            TransmitterBlockEntity tile;
                            BlockPos directionPos = from.m_121945_(direction);
                            if (this.iterated.contains(directionPos) || (tile = WorldUtils.getTileEntity(TransmitterBlockEntity.class, (LevelAccessor)this.world, this.chunkMap, directionPos)) == null || !transmitter.isValidTransmitterBasic(tile, direction)) continue;
                            this.queue.addLast(directionPos);
                        }
                    }
                } else {
                    Object net;
                    TransmitterBlockEntity tile = WorldUtils.getTileEntity(TransmitterBlockEntity.class, (LevelAccessor)this.world, this.chunkMap, from);
                    if (tile != null && ((Transmitter)this.startPoint).supportsTransmissionType(tile) && (net = tile.getTransmitter().getTransmitterNetwork()) != null && this.transmitterValidator.isNetworkCompatible(net)) {
                        this.networksFound.add(net);
                    }
                }
            }
        }
    }
}

