/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.capabilities.network.cache;

import com.hbm.api.annotations.NothingNullByDefault;
import com.hbm.blockentity.base.TransmitterBlockEntity;
import com.hbm.capabilities.network.accepterInfo.AbstractAcceptorInfo;
import com.hbm.capabilities.network.transmitter.Transmitter;
import com.hbm.utils.WorldUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public abstract class AbstractAcceptorCache<ACCEPTOR, INFO extends AbstractAcceptorInfo> {
    private final Map<Direction, NonNullConsumer<LazyOptional<ACCEPTOR>>> cachedListeners = new EnumMap<Direction, NonNullConsumer<LazyOptional<ACCEPTOR>>>(Direction.class);
    protected final Map<Direction, INFO> cachedAcceptors = new EnumMap<Direction, INFO>(Direction.class);
    protected final Transmitter<ACCEPTOR, ?, ?> transmitter;
    private final TransmitterBlockEntity transmitterTile;
    public byte currentAcceptorConnections = 0;

    protected AbstractAcceptorCache(Transmitter<ACCEPTOR, ?, ?> transmitter, TransmitterBlockEntity transmitterTile) {
        this.transmitter = transmitter;
        this.transmitterTile = transmitterTile;
    }

    public void clear() {
        this.cachedListeners.clear();
        this.cachedAcceptors.clear();
    }

    public void invalidateCachedAcceptor(Direction side) {
        if (this.cachedAcceptors.containsKey(side)) {
            this.cachedAcceptors.remove(side);
            this.transmitter.markDirtyAcceptor(side);
        }
    }

    public LazyOptional<ACCEPTOR> getCachedAcceptor(Direction side) {
        return Transmitter.connectionMapContainsSide(this.currentAcceptorConnections, side) ? this.getConnectedAcceptor(side) : LazyOptional.empty();
    }

    public List<ACCEPTOR> getConnectedAcceptors(Set<Direction> sides) {
        ArrayList acceptors = new ArrayList(sides.size());
        for (Direction side : sides) {
            this.getConnectedAcceptor(side).ifPresent(acceptors::add);
        }
        return acceptors;
    }

    protected abstract LazyOptional<ACCEPTOR> getConnectedAcceptor(Direction var1);

    protected NonNullConsumer<LazyOptional<ACCEPTOR>> getRefreshListener(@NotNull Direction side) {
        return this.cachedListeners.computeIfAbsent(side, s -> new RefreshListener(this.transmitterTile, (Direction)s));
    }

    private static class RefreshListener<ACCEPTOR>
    implements NonNullConsumer<LazyOptional<ACCEPTOR>> {
        private final WeakReference<TransmitterBlockEntity> tile;
        private final Direction side;

        private RefreshListener(TransmitterBlockEntity tile, Direction side) {
            this.tile = new WeakReference<TransmitterBlockEntity>(tile);
            this.side = side;
        }

        public void accept(@NotNull LazyOptional<ACCEPTOR> ignored) {
            TransmitterBlockEntity transmitterTile = (TransmitterBlockEntity)this.tile.get();
            if (transmitterTile != null && !transmitterTile.m_58901_() && transmitterTile.m_58898_() && transmitterTile.isLoaded() && WorldUtils.isBlockLoaded((BlockGetter)transmitterTile.m_58904_(), transmitterTile.m_58899_().m_121945_(this.side))) {
                transmitterTile.getTransmitter().refreshConnections(this.side);
            }
        }
    }
}

