/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.capabilities.network.transmitter;

import com.hbm.api.Chunk3D;
import com.hbm.api.Coord4D;
import com.hbm.api.interferences.ITileWrapper;
import com.hbm.blockentity.base.TransmitterBlockEntity;
import com.hbm.capabilities.network.ConnType;
import com.hbm.capabilities.network.TransmissionType;
import com.hbm.capabilities.network.TransmitterNetworkRegistry;
import com.hbm.capabilities.network.cache.AbstractAcceptorCache;
import com.hbm.capabilities.network.cache.AcceptorCache;
import com.hbm.capabilities.network.network.DynamicNetwork;
import com.hbm.capabilities.network.validator.CompatibleTransmitterValidator;
import com.hbm.utils.EnumUtils;
import com.hbm.utils.NBTUtils;
import com.hbm.utils.WorldUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Transmitter<ACCEPTOR, NETWORK extends DynamicNetwork<ACCEPTOR, NETWORK, TRANSMITTER>, TRANSMITTER extends Transmitter<ACCEPTOR, NETWORK, TRANSMITTER>>
implements ITileWrapper {
    private ConnType[] connTypes = new ConnType[]{ConnType.NORMAL, ConnType.NORMAL, ConnType.NORMAL, ConnType.NORMAL, ConnType.NORMAL, ConnType.NORMAL};
    private AbstractAcceptorCache<ACCEPTOR, ?> acceptorCache;
    public byte currentTransmitterConnections = 0;
    private TransmitterBlockEntity transmitterTile;
    private Set<TransmissionType> supportedTransmissionTypes;
    private NETWORK network;
    private boolean orphaned = true;

    public static boolean connectionMapContainsSide(byte connections, Direction side) {
        return Transmitter.connectionMapContainsSide(connections, side.ordinal());
    }

    private static boolean connectionMapContainsSide(byte connections, int sideOrdinal) {
        byte tester = (byte)(1 << sideOrdinal);
        return (connections & tester) > 0;
    }

    private static byte setConnectionBit(byte connections, boolean toSet, Direction side) {
        return (byte)(connections & ~((byte)(1 << side.ordinal())) | (byte)((toSet ? 1 : 0) << side.ordinal()));
    }

    private static ConnType getConnType(Direction side, byte allConnections, byte transmitterConnections, ConnType[] types) {
        int sideOrdinal = side.ordinal();
        if (!Transmitter.connectionMapContainsSide(allConnections, sideOrdinal)) {
            return ConnType.FORBID;
        }
        if (Transmitter.connectionMapContainsSide(transmitterConnections, sideOrdinal)) {
            return ConnType.NORMAL;
        }
        return types[sideOrdinal];
    }

    Transmitter(TransmitterBlockEntity tile, TransmissionType ... transmissionTypes) {
        this.transmitterTile = tile;
        this.acceptorCache = this.createAcceptorCache();
    }

    protected TRANSMITTER getTransmitter() {
        return (TRANSMITTER)this;
    }

    protected AbstractAcceptorCache<ACCEPTOR, ?> createAcceptorCache() {
        return new AcceptorCache(this, this.getTransmitterTile());
    }

    public AbstractAcceptorCache<ACCEPTOR, ?> getAcceptorCache() {
        return this.acceptorCache;
    }

    @NotNull
    public LazyOptional<ACCEPTOR> getAcceptor(Direction side) {
        return this.acceptorCache.getCachedAcceptor(side);
    }

    public TransmitterBlockEntity getTransmitterTile() {
        return this.transmitterTile;
    }

    public ConnType[] getConnTypesRaw() {
        return this.connTypes;
    }

    public void setConnTypesRaw(@NotNull ConnType[] connTypes) {
        if (this.connTypes.length != connTypes.length) {
            throw new IllegalArgumentException("Mismatched connection types length");
        }
        this.connTypes = connTypes;
    }

    public ConnType getConnTypeRaw(@NotNull Direction side) {
        return this.connTypes[side.ordinal()];
    }

    public void setConnectionTypeRaw(@NotNull Direction side, @NotNull ConnType type) {
        int index = side.ordinal();
        ConnType old = this.connTypes[index];
        if (old != type) {
            this.connTypes[index] = type;
            this.getTransmitterTile().sideChanged(side, old, type);
        }
    }

    @Override
    public BlockPos getTilePos() {
        return this.transmitterTile.getTilePos();
    }

    @Override
    public Level getTileWorld() {
        return this.transmitterTile.getTileWorld();
    }

    @Override
    public Coord4D getTileCoord() {
        return this.transmitterTile.getTileCoord();
    }

    @Override
    public Chunk3D getTileChunk() {
        return this.transmitterTile.getTileChunk();
    }

    public boolean isRemote() {
        return this.transmitterTile.isRemote();
    }

    public boolean isOrphan() {
        return this.orphaned;
    }

    public void setOrphan(boolean nowOrphaned) {
        this.orphaned = nowOrphaned;
    }

    public CompatibleTransmitterValidator<ACCEPTOR, NETWORK, TRANSMITTER> getNewOrphanValidator() {
        return new CompatibleTransmitterValidator();
    }

    public Set<TransmissionType> getSupportedTransmissionTypes() {
        return this.supportedTransmissionTypes;
    }

    public boolean supportsTransmissionType(Transmitter<?, ?, ?> transmitter) {
        return transmitter.getSupportedTransmissionTypes().stream().anyMatch(this.supportedTransmissionTypes::contains);
    }

    public boolean supportsTransmissionType(TransmitterBlockEntity transmitter) {
        return this.supportsTransmissionType(transmitter.getTransmitter());
    }

    public void requestsUpdate() {
        this.getTransmitterTile().sendUpdatePacket();
    }

    public NETWORK getTransmitterNetwork() {
        return this.network;
    }

    public void setTransmitterNetwork(NETWORK network) {
        this.setTransmitterNetwork(network, true);
    }

    public boolean setTransmitterNetwork(NETWORK network, boolean requestNow) {
        if (this.network == network) {
            return false;
        }
        if (this.isRemote() && this.network != null) {
            ((DynamicNetwork)this.network).removeTransmitter(this.getTransmitter());
        }
        this.network = network;
        boolean bl = this.orphaned = this.network == null;
        if (this.isRemote()) {
            if (this.network != null) {
                ((DynamicNetwork)this.network).addTransmitter(this.getTransmitter());
            }
        } else if (requestNow) {
            this.requestsUpdate();
        } else {
            return true;
        }
        return false;
    }

    public boolean hasTransmitterNetwork() {
        return !this.isOrphan() && this.getTransmitterNetwork() != null;
    }

    public abstract NETWORK createEmptyNetworkWithID(UUID var1);

    public abstract NETWORK createNetworkByMerging(Collection<NETWORK> var1);

    public boolean isValid() {
        return !this.getTransmitterTile().m_58901_() && this.getTransmitterTile().isLoaded();
    }

    public boolean isValidTransmitter(TransmitterBlockEntity transmitter, Direction side) {
        return this.isValidTransmitterBasic(transmitter, side);
    }

    public boolean isValidTransmitterBasic(TransmitterBlockEntity transmitter, Direction side) {
        return this.supportsTransmissionType(transmitter) && this.canConnectMutual(side, transmitter);
    }

    public void markDirtyAcceptor(Direction side) {
    }

    public abstract void takeShare();

    public boolean isValidAcceptor(BlockEntity tile, Direction side) {
        TransmitterBlockEntity transmitter;
        return !(tile instanceof TransmitterBlockEntity) || !this.supportsTransmissionType(transmitter = (TransmitterBlockEntity)tile);
    }

    public boolean canConnectMutual(Direction side, @Nullable BlockEntity cachedTile) {
        TransmitterBlockEntity transmitter;
        if (!this.canConnect(side)) {
            return false;
        }
        if (cachedTile == null) {
            cachedTile = WorldUtils.getTileEntity((BlockGetter)this.getTileWorld(), this.getTilePos().m_121945_(side));
        }
        return !(cachedTile instanceof TransmitterBlockEntity) || (transmitter = (TransmitterBlockEntity)cachedTile).getTransmitter().canConnect(side.m_122424_());
    }

    public boolean canConnectMutual(Direction side, @Nullable TRANSMITTER cachedTransmitter) {
        if (!this.canConnect(side)) {
            return false;
        }
        return cachedTransmitter == null || ((Transmitter)cachedTransmitter).canConnect(side.m_122424_());
    }

    public boolean canConnect(Direction side) {
        return this.getConnTypeRaw(side) != ConnType.FORBID;
    }

    public byte getPossibleTransmitterConnections() {
        byte connections = 0;
        for (Direction side : EnumUtils.DIRECTIONS) {
            TransmitterBlockEntity tile = WorldUtils.getTileEntity(TransmitterBlockEntity.class, (BlockGetter)this.getTileWorld(), this.getTilePos().m_121945_(side));
            if (tile == null || !this.isValidTransmitter(tile, side)) continue;
            connections = (byte)(connections | (byte)(1 << side.ordinal()));
        }
        return connections;
    }

    private boolean getPossibleAcceptorConnection(Direction side) {
        BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)this.getTileWorld(), this.getTilePos().m_121945_(side));
        if (this.canConnectMutual(side, tile) && this.isValidAcceptor(tile, side)) {
            return true;
        }
        this.acceptorCache.invalidateCachedAcceptor(side);
        return false;
    }

    private boolean getPossibleTransmitterConnection(Direction side) {
        TransmitterBlockEntity tile = WorldUtils.getTileEntity(TransmitterBlockEntity.class, (BlockGetter)this.getTileWorld(), this.getTilePos().m_121945_(side));
        return tile != null && this.isValidTransmitter(tile, side);
    }

    public byte getPossibleAcceptorConnections() {
        byte connections = 0;
        for (Direction side : EnumUtils.DIRECTIONS) {
            BlockPos offset = this.getTilePos().m_121945_(side);
            BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)this.getTileWorld(), offset);
            if (this.canConnectMutual(side, tile)) {
                if (!this.isRemote() && !WorldUtils.isBlockLoaded((BlockGetter)this.getTileWorld(), offset)) {
                    this.getTransmitterTile().setForceUpdate();
                    continue;
                }
                if (this.isValidAcceptor(tile, side)) {
                    connections = (byte)(connections | 1 << side.ordinal());
                    continue;
                }
            }
            this.acceptorCache.invalidateCachedAcceptor(side);
        }
        return connections;
    }

    public byte getAllCurrentConnections() {
        return (byte)(this.currentTransmitterConnections | this.acceptorCache.currentAcceptorConnections);
    }

    public boolean canConnectToAcceptor(Direction side) {
        ConnType type = this.getConnTypeRaw(side);
        return type == ConnType.NORMAL || type == ConnType.OUT;
    }

    @NotNull
    public CompoundTag getReducedUpdateTag(CompoundTag updateTag) {
        updateTag.m_128344_("connections", this.currentTransmitterConnections);
        updateTag.m_128344_("acceptors", this.acceptorCache.currentAcceptorConnections);
        for (Direction direction : EnumUtils.DIRECTIONS) {
            NBTUtils.writeEnum(updateTag, "side" + direction.ordinal(), this.getConnTypeRaw(direction));
        }
        if (this.hasTransmitterNetwork()) {
            updateTag.m_128362_("network", ((DynamicNetwork)this.getTransmitterNetwork()).getUUID());
        }
        return updateTag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag) {
        NBTUtils.setByteIfPresent(tag, "connections", connections -> {
            this.currentTransmitterConnections = connections;
        });
        NBTUtils.setByteIfPresent(tag, "acceptors", acceptors -> {
            this.acceptorCache.currentAcceptorConnections = acceptors;
        });
        for (Direction direction : EnumUtils.DIRECTIONS) {
            NBTUtils.setEnumIfPresent(tag, "side" + direction.ordinal(), ConnType::byIndexStatic, type -> this.setConnectionTypeRaw(direction, (ConnType)((Object)type)));
        }
        NBTUtils.setUUIDIfPresentElse(tag, "network", networkID -> {
            if (this.hasTransmitterNetwork() && ((DynamicNetwork)this.getTransmitterNetwork()).getUUID().equals(networkID)) {
                return;
            }
            DynamicNetwork<?, ?, ?> clientNetwork = TransmitterNetworkRegistry.getInstance().getClientNetwork((UUID)networkID);
            if (clientNetwork == null) {
                NETWORK network = this.createEmptyNetworkWithID((UUID)networkID);
                ((DynamicNetwork)network).register();
                this.setTransmitterNetwork(network);
                this.handleContentsUpdateTag(network, tag);
            } else {
                this.updateClientNetwork(clientNetwork);
            }
        }, () -> this.setTransmitterNetwork(null));
    }

    protected void updateClientNetwork(@NotNull NETWORK network) {
        ((DynamicNetwork)network).register();
        this.setTransmitterNetwork(network);
    }

    protected void handleContentsUpdateTag(@NotNull NETWORK network, @NotNull CompoundTag tag) {
    }

    public void read(@NotNull CompoundTag nbtTags) {
        for (Direction direction : EnumUtils.DIRECTIONS) {
            NBTUtils.setEnumIfPresent(nbtTags, "connection" + direction.ordinal(), ConnType::byIndexStatic, type -> this.setConnectionTypeRaw(direction, (ConnType)((Object)type)));
        }
    }

    @NotNull
    public CompoundTag write(@NotNull CompoundTag nbtTags) {
        for (Direction direction : EnumUtils.DIRECTIONS) {
            NBTUtils.writeEnum(nbtTags, "connection" + direction.ordinal(), this.getConnTypeRaw(direction));
        }
        return nbtTags;
    }

    public void refreshConnections() {
        if (!this.isRemote()) {
            byte possibleTransmitters = this.getPossibleTransmitterConnections();
            byte possibleAcceptors = this.getPossibleAcceptorConnections();
            byte newlyEnabledTransmitters = 0;
            boolean sendDesc = false;
            if ((possibleTransmitters | possibleAcceptors) != this.getAllCurrentConnections()) {
                sendDesc = true;
                if (possibleTransmitters != this.currentTransmitterConnections) {
                    newlyEnabledTransmitters = (byte)(possibleTransmitters ^ this.currentTransmitterConnections);
                    newlyEnabledTransmitters = (byte)(newlyEnabledTransmitters & ~this.currentTransmitterConnections);
                }
            }
            this.currentTransmitterConnections = possibleTransmitters;
            this.acceptorCache.currentAcceptorConnections = possibleAcceptors;
            if (newlyEnabledTransmitters != 0) {
                this.recheckConnections(newlyEnabledTransmitters);
            }
            if (sendDesc) {
                this.getTransmitterTile().sendUpdatePacket();
            }
        }
    }

    public void refreshConnections(Direction side) {
        if (!this.isRemote()) {
            boolean possibleTransmitter = this.getPossibleTransmitterConnection(side);
            boolean possibleAcceptor = this.getPossibleAcceptorConnection(side);
            boolean transmitterChanged = false;
            boolean sendDesc = false;
            if ((possibleTransmitter || possibleAcceptor) != Transmitter.connectionMapContainsSide(this.getAllCurrentConnections(), side)) {
                sendDesc = true;
                if (possibleTransmitter != Transmitter.connectionMapContainsSide(this.currentTransmitterConnections, side)) {
                    transmitterChanged = possibleTransmitter;
                }
            }
            this.currentTransmitterConnections = Transmitter.setConnectionBit(this.currentTransmitterConnections, possibleTransmitter, side);
            this.acceptorCache.currentAcceptorConnections = Transmitter.setConnectionBit(this.acceptorCache.currentAcceptorConnections, possibleAcceptor, side);
            if (transmitterChanged) {
                this.recheckConnection(side);
            }
            if (sendDesc) {
                this.getTransmitterTile().sendUpdatePacket();
            }
        }
    }

    protected void recheckConnections(byte newlyEnabledTransmitters) {
        if (!this.hasTransmitterNetwork()) {
            for (Direction side : EnumUtils.DIRECTIONS) {
                TransmitterBlockEntity tile;
                if (!Transmitter.connectionMapContainsSide(newlyEnabledTransmitters, side) || (tile = WorldUtils.getTileEntity(TransmitterBlockEntity.class, (BlockGetter)this.getTileWorld(), this.getTilePos().m_121945_(side))) == null) continue;
                tile.getTransmitter().refreshConnections(side.m_122424_());
            }
        }
    }

    protected void recheckConnection(Direction side) {
    }

    public void onModeChange(Direction side) {
        this.markDirtyAcceptor(side);
        if (this.getPossibleTransmitterConnections() != this.currentTransmitterConnections) {
            this.markDirtyTransmitters();
        }
        this.getTransmitterTile().m_6596_();
    }

    public void onNeighborTileChange(Direction side) {
        this.refreshConnections(side);
    }

    public void onNeighborBlockChange(Direction side) {
        this.refreshConnections(side);
    }

    protected void markDirtyTransmitters() {
        this.notifyTileChange();
        if (this.hasTransmitterNetwork()) {
            TransmitterNetworkRegistry.invalidateTransmitter(this.getTransmitter());
        }
    }

    public void remove() {
        this.acceptorCache.clear();
    }

    public ConnType getConnType(Direction side) {
        return Transmitter.getConnType(side, this.getAllCurrentConnections(), this.currentTransmitterConnections, this.connTypes);
    }

    public Set<Direction> getConnections(ConnType type) {
        EnumSet<Direction> sides = null;
        for (Direction side : EnumUtils.DIRECTIONS) {
            if (this.getConnType(side) != type) continue;
            if (sides == null) {
                sides = EnumSet.noneOf(Direction.class);
            }
            sides.add(side);
        }
        return sides == null ? Collections.emptySet() : sides;
    }

    public InteractionResult onConfigure(Player player, Direction side) {
        return InteractionResult.PASS;
    }

    public void notifyTileChange() {
        WorldUtils.notifyLoadedNeighborsOfTileChange(this.getTileWorld(), this.getTilePos());
    }

    public void validateAndTakeShare() {
        this.takeShare();
    }
}

