/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.capabilities.resolver;

import com.hbm.api.annotations.NothingNullByDefault;
import com.hbm.capabilities.resolver.ICapabilityResolver;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class BasicCapabilityResolver
implements ICapabilityResolver {
    public final Capability<?> supportedCapability;
    private final NonNullSupplier<?> supplier;
    @Nullable
    private LazyOptional<?> cachedCapability;

    public <T> BasicCapabilityResolver(NonNullSupplier<T> supplier, Capability<? super T> supportedCapabilities) {
        this.supportedCapability = supportedCapabilities;
        this.supplier = supplier;
    }

    @Override
    public <T> LazyOptional<T> resolve(Capability<T> capability, @Nullable Direction side) {
        if (this.cachedCapability == null || !this.cachedCapability.isPresent()) {
            this.cachedCapability = LazyOptional.of(this.supplier);
        }
        return this.cachedCapability.cast();
    }

    @Override
    public List<Capability<?>> getSupportedCapabilities() {
        return List.of(this.supportedCapability);
    }

    @Override
    public void invalidate(Capability<?> capability, @Nullable Direction side) {
        this.invalidateAll();
    }

    @Override
    public void validate(Capability<?> capability, @Nullable Direction side) {
        this.cachedCapability = LazyOptional.of(this.supplier);
    }

    @Override
    public void invalidateAll() {
        if (this.cachedCapability != null && this.cachedCapability.isPresent()) {
            this.cachedCapability.invalidate();
            this.cachedCapability = null;
        }
    }
}

