/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.compat.ballistix;

import com.hbm.compat.ballistix.BallistixExplosiveType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

final class BallistixExplosionHandlers {
    private BallistixExplosionHandlers() {
    }

    static void detonate(BallistixExplosiveType type, Level level, Vec3 pos, Entity owner) {
        switch (type) {
            case OBSIDIAN: {
                BallistixExplosionHandlers.blast(level, pos, type.baseRadius(), false);
                break;
            }
            case CONDENSIVE: {
                BallistixExplosionHandlers.blast(level, pos, type.baseRadius(), false);
                break;
            }
            case INCENDIARY: {
                BallistixExplosionHandlers.incendiary(level, pos, type.baseRadius());
                break;
            }
            case ATTRACTIVE: {
                BallistixExplosionHandlers.applyForce(level, pos, 6.0, 1.2, false);
                break;
            }
            case REPULSIVE: {
                BallistixExplosionHandlers.applyForce(level, pos, 6.0, 1.4, true);
                break;
            }
            case SHRAPNEL: {
                BallistixExplosionHandlers.shrapnel(level, pos, 28, owner);
                break;
            }
            case CHEMICAL: {
                BallistixExplosionHandlers.chemicalCloud(level, pos, 6.0f);
                break;
            }
            case ANVIL: {
                BallistixExplosionHandlers.dropAnvils(level, pos, 10);
                break;
            }
            case INFESTIVE: {
                BallistixExplosionHandlers.spawnInfestation(level, pos, 8);
                break;
            }
            case DEBILITATION: {
                BallistixExplosionHandlers.debilitate(level, pos, 7.0f);
                break;
            }
            case FRAGMENTATION: {
                BallistixExplosionHandlers.shrapnel(level, pos, 50, owner);
                break;
            }
            case CONTAGIOUS: {
                BallistixExplosionHandlers.contagious(level, pos, type.baseRadius());
                break;
            }
            case BREACHING: {
                BallistixExplosionHandlers.breaching(level, pos, type.baseRadius());
                break;
            }
            case THERMOBARIC: {
                BallistixExplosionHandlers.thermobaric(level, pos, type.baseRadius());
                break;
            }
            case SONIC: {
                BallistixExplosionHandlers.sonic(level, pos, type.baseRadius());
                break;
            }
            case ANTIGRAVITY: {
                BallistixExplosionHandlers.antigravity(level, pos, type.baseRadius());
                break;
            }
            case EMP: {
                BallistixExplosionHandlers.emp(level, pos, type.baseRadius());
                break;
            }
            case NUCLEAR: {
                BallistixExplosionHandlers.nuclear(level, pos, type.baseRadius());
                break;
            }
            case ENDOTHERMIC: {
                BallistixExplosionHandlers.endothermic(level, pos, type.baseRadius());
                break;
            }
            case EXOTHERMIC: {
                BallistixExplosionHandlers.exothermic(level, pos, type.baseRadius());
                break;
            }
            case ENDER: {
                BallistixExplosionHandlers.ender(level, pos, type.baseRadius());
                break;
            }
            case HYPERSONIC: {
                BallistixExplosionHandlers.hypersonic(level, pos, type.baseRadius());
                break;
            }
            case REJUVINATION: {
                BallistixExplosionHandlers.rejuvenate(level, pos, type.baseRadius());
                break;
            }
            case ANTIMATTER: {
                BallistixExplosionHandlers.antimatter(level, pos, type.baseRadius());
                break;
            }
            case LARGE_ANTIMATTER: {
                BallistixExplosionHandlers.antimatter(level, pos, type.baseRadius());
                break;
            }
            case DARKMATTER: {
                BallistixExplosionHandlers.darkmatter(level, pos, type.baseRadius());
                break;
            }
            case LANDMINE: {
                BallistixExplosionHandlers.blast(level, pos, type.baseRadius(), false);
                break;
            }
            default: {
                BallistixExplosionHandlers.blast(level, pos, 4.0f, false);
            }
        }
    }

    private static void blast(Level level, Vec3 pos, float radius, boolean causesFire) {
        level.m_255391_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, radius, causesFire, Level.ExplosionInteraction.TNT);
    }

    private static void applyForce(Level level, Vec3 pos, double radius, double strength, boolean pushOut) {
        List targets = level.m_6443_(LivingEntity.class, new AABB(pos, pos).m_82400_(radius), living -> living.m_6084_() && !living.m_5833_());
        for (LivingEntity living2 : targets) {
            Vec3 delta = living2.m_20182_().m_82546_(pos);
            double distance = delta.m_82553_();
            if (distance < 0.001 || distance > radius) continue;
            Vec3 dir = delta.m_82541_().m_82490_(strength * (1.0 - distance / radius));
            if (!pushOut) {
                dir = dir.m_82490_(-1.0);
            }
            living2.m_5997_(dir.f_82479_, dir.f_82480_ + 0.05, dir.f_82481_);
            living2.f_19864_ = true;
        }
    }

    private static void incendiary(Level level, Vec3 pos, float radius) {
        BallistixExplosionHandlers.blast(level, pos, radius, true);
        if (!level.f_46443_) {
            BlockPos center = BlockPos.m_274446_((Position)pos);
            for (BlockPos target : BlockPos.m_121940_((BlockPos)center.m_7918_(-((int)radius), -1, -((int)radius)), (BlockPos)center.m_7918_((int)radius, 1, (int)radius))) {
                if (center.m_123331_((Vec3i)target) > (double)(radius * radius) || level.f_46441_.m_188501_() > 0.3f || !level.m_8055_(target).m_60795_() || !level.m_8055_(target.m_7495_()).m_280296_()) continue;
                level.m_7731_(target, Blocks.f_50083_.m_49966_(), 11);
            }
        }
    }

    private static void shrapnel(Level level, Vec3 pos, int count, Entity owner) {
        if (level.f_46443_) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            Arrow arrow = new Arrow(level, pos.f_82479_, pos.f_82480_ + 0.2, pos.f_82481_);
            arrow.m_5602_(owner);
            Vec3 direction = Vec3.m_82498_((float)(level.f_46441_.m_188501_() * 360.0f), (float)(level.f_46441_.m_188501_() * 60.0f - 30.0f));
            arrow.m_20256_(direction.m_82541_().m_82490_(1.2));
            arrow.m_36781_(4.0);
            arrow.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
            level.m_7967_((Entity)arrow);
        }
    }

    private static void chemicalCloud(Level level, Vec3 pos, float radius) {
        if (level.f_46443_) {
            for (int i = 0; i < 120; ++i) {
                double rx = pos.f_82479_ + (level.f_46441_.m_188500_() - 0.5) * (double)radius * 2.0;
                double rz = pos.f_82481_ + (level.f_46441_.m_188500_() - 0.5) * (double)radius * 2.0;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123777_, rx, pos.f_82480_ + 0.5, rz, 0.0, 0.01, 0.0);
            }
            return;
        }
        ServerLevel server = (ServerLevel)level;
        List victims = server.m_45976_(LivingEntity.class, new AABB(pos, pos).m_82400_((double)radius));
        for (LivingEntity living : victims) {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 360, 1));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 360, 1));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 360, 0));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 0));
        }
    }

    private static void dropAnvils(Level level, Vec3 pos, int count) {
        if (level.f_46443_) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            double dx = pos.f_82479_ + level.f_46441_.m_188500_() * 6.0 - 3.0;
            double dz = pos.f_82481_ + level.f_46441_.m_188500_() * 6.0 - 3.0;
            BlockPos spawnPos = BlockPos.m_274561_((double)dx, (double)(pos.f_82480_ + 12.0 + (double)level.f_46441_.m_188503_(6)), (double)dz);
            FallingBlockEntity.m_201971_((Level)level, (BlockPos)spawnPos, (BlockState)Blocks.f_50322_.m_49966_());
        }
    }

    private static void spawnInfestation(Level level, Vec3 pos, int count) {
        if (level.f_46443_) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        for (int i = 0; i < count; ++i) {
            Silverfish fish = new Silverfish(EntityType.f_20523_, (Level)server);
            fish.m_6034_(pos.f_82479_ + server.f_46441_.m_188583_() * 2.0, pos.f_82480_, pos.f_82481_ + server.f_46441_.m_188583_() * 2.0);
            fish.m_6518_((ServerLevelAccessor)server, server.m_6436_(fish.m_20183_()), null, null, null);
            server.m_7967_((Entity)fish);
        }
    }

    private static void debilitate(Level level, Vec3 pos, float radius) {
        if (level.f_46443_) {
            return;
        }
        List victims = level.m_6443_(LivingEntity.class, new AABB(pos, pos).m_82400_((double)radius), LivingEntity::m_6084_);
        for (LivingEntity living : victims) {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 400, 1));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 2));
        }
    }

    private static void contagious(Level level, Vec3 pos, float radius) {
        if (level.f_46443_) {
            return;
        }
        List victims = level.m_6443_(LivingEntity.class, new AABB(pos, pos).m_82400_((double)radius), LivingEntity::m_6084_);
        for (LivingEntity living : victims) {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 300, 0));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 300, 1));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 300, 1));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 140, 0));
        }
    }

    private static void breaching(Level level, Vec3 pos, float radius) {
        level.m_255391_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, radius, false, Level.ExplosionInteraction.BLOCK);
    }

    private static void thermobaric(Level level, Vec3 pos, float radius) {
        BallistixExplosionHandlers.blast(level, pos, radius, true);
        BallistixExplosionHandlers.blast(level, pos, radius / 2.0f, true);
    }

    private static void sonic(Level level, Vec3 pos, float radius) {
        BallistixExplosionHandlers.applyForce(level, pos, radius, 2.5, true);
        if (!level.f_46443_) {
            AABB area = new AABB(pos, pos).m_82400_((double)radius);
            for (BlockPos bp : BlockPos.m_121940_((BlockPos)BlockPos.m_274561_((double)area.f_82288_, (double)area.f_82289_, (double)area.f_82290_), (BlockPos)BlockPos.m_274561_((double)area.f_82291_, (double)area.f_82292_, (double)area.f_82293_))) {
                if (pos.m_82554_(bp.m_252807_()) > (double)radius || level.m_8055_(bp).m_60795_() || !(level.f_46441_.m_188501_() < 0.05f)) continue;
                level.m_46961_(bp, false);
            }
        }
    }

    private static void antigravity(Level level, Vec3 pos, float radius) {
        if (level.f_46443_) {
            return;
        }
        List victims = level.m_6443_(LivingEntity.class, new AABB(pos, pos).m_82400_((double)radius), LivingEntity::m_6084_);
        for (LivingEntity living : victims) {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 200, 1));
        }
    }

    private static void emp(Level level, Vec3 pos, float radius) {
        if (level.f_46443_) {
            return;
        }
        List victims = level.m_6443_(LivingEntity.class, new AABB(pos, pos).m_82400_((double)radius), LivingEntity::m_6084_);
        for (LivingEntity living : victims) {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 2));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 1));
        }
    }

    private static void nuclear(Level level, Vec3 pos, float radius) {
        BallistixExplosionHandlers.blast(level, pos, radius, true);
        if (!level.f_46443_) {
            List victims = level.m_6443_(LivingEntity.class, new AABB(pos, pos).m_82400_((double)(radius + 10.0f)), LivingEntity::m_6084_);
            for (LivingEntity living : victims) {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 600, 2));
                living.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 200, 1));
            }
        }
    }

    private static void endothermic(Level level, Vec3 pos, float radius) {
        BallistixExplosionHandlers.blast(level, pos, radius / 2.0f, false);
        if (!level.f_46443_) {
            BlockPos center = BlockPos.m_274446_((Position)pos);
            for (BlockPos bp : BlockPos.m_121940_((BlockPos)center.m_7918_(-((int)radius), -1, -((int)radius)), (BlockPos)center.m_7918_((int)radius, 1, (int)radius))) {
                if (center.m_123331_((Vec3i)bp) > (double)(radius * radius) || level.f_46441_.m_188501_() > 0.2f || !level.m_8055_(bp).m_60795_()) continue;
                level.m_7731_(bp, Blocks.f_50125_.m_49966_(), 11);
            }
        }
    }

    private static void exothermic(Level level, Vec3 pos, float radius) {
        BallistixExplosionHandlers.blast(level, pos, radius / 2.0f, true);
        if (!level.f_46443_) {
            BlockPos center = BlockPos.m_274446_((Position)pos);
            for (BlockPos bp : BlockPos.m_121940_((BlockPos)center.m_7918_(-((int)radius), -1, -((int)radius)), (BlockPos)center.m_7918_((int)radius, 1, (int)radius))) {
                if (center.m_123331_((Vec3i)bp) > (double)(radius * radius) || level.f_46441_.m_188501_() > 0.15f) continue;
                if (level.m_8055_(bp).m_60795_() && level.m_8055_(bp.m_7495_()).m_280296_()) {
                    level.m_7731_(bp, Blocks.f_50083_.m_49966_(), 11);
                    continue;
                }
                if (!(level.f_46441_.m_188501_() < 0.05f)) continue;
                level.m_7731_(bp, Blocks.f_49991_.m_49966_(), 11);
            }
        }
    }

    private static void ender(Level level, Vec3 pos, float radius) {
        if (level.f_46443_) {
            return;
        }
        List victims = level.m_6443_(LivingEntity.class, new AABB(pos, pos).m_82400_((double)radius), LivingEntity::m_6084_);
        for (LivingEntity living : victims) {
            double dx = pos.f_82479_ + level.f_46441_.m_188500_() * (double)radius * 2.0 - (double)radius;
            double dz = pos.f_82481_ + level.f_46441_.m_188500_() * (double)radius * 2.0 - (double)radius;
            double dy = pos.f_82480_ + (double)level.f_46441_.m_188503_(6) - 3.0;
            living.m_6021_(dx, dy, dz);
        }
    }

    private static void hypersonic(Level level, Vec3 pos, float radius) {
        BallistixExplosionHandlers.applyForce(level, pos, radius, 3.5, true);
        if (!level.f_46443_) {
            List victims = level.m_6443_(LivingEntity.class, new AABB(pos, pos).m_82400_((double)radius), LivingEntity::m_6084_);
            for (LivingEntity living : victims) {
                living.m_6469_(level.m_269111_().m_269093_(null), 8.0f);
            }
        }
    }

    private static void rejuvenate(Level level, Vec3 pos, float radius) {
        if (level.f_46443_) {
            return;
        }
        List victims = level.m_6443_(LivingEntity.class, new AABB(pos, pos).m_82400_((double)radius), LivingEntity::m_6084_);
        for (LivingEntity living : victims) {
            living.m_5634_(8.0f);
            living.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 1));
        }
    }

    private static void antimatter(Level level, Vec3 pos, float radius) {
        BallistixExplosionHandlers.blast(level, pos, radius, true);
    }

    private static void darkmatter(Level level, Vec3 pos, float radius) {
        BallistixExplosionHandlers.applyForce(level, pos, radius, 2.0, false);
        if (!level.f_46443_) {
            List victims = level.m_6443_(LivingEntity.class, new AABB(pos, pos).m_82400_((double)radius), LivingEntity::m_6084_);
            for (LivingEntity living : victims) {
                living.m_6469_(level.m_269111_().m_269264_(), 6.0f);
            }
        }
    }
}

