/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.compat.ballistix;

import com.hbm.compat.ballistix.BallistixExplosionHandlers;
import com.hbm.compat.ballistix.BallistixExplosiveType;
import com.hbm.compat.ballistix.BallistixPrimedExplosive;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BallistixExplosiveBlock
extends Block {
    public static final BooleanProperty UNSTABLE = BlockStateProperties.f_61361_;
    private final BallistixExplosiveType type;

    public BallistixExplosiveBlock(BallistixExplosiveType type) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50077_).m_60966_().m_60918_(SoundType.f_56740_));
        this.type = type;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)UNSTABLE, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UNSTABLE});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)UNSTABLE, (Comparable)Boolean.valueOf(ctx.m_43723_() != null && ctx.m_43723_().m_6144_()));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.type.shape();
    }

    public void onCaughtFire(BlockState state, Level level, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        this.ignite(level, pos, igniter);
        level.m_7471_(pos, false);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.m_60713_(state.m_60734_()) && level.m_276867_(pos)) {
            this.onCaughtFire(state, level, pos, null, null);
            level.m_7471_(pos, false);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (level.m_276867_(pos)) {
            this.onCaughtFire(state, level, pos, null, null);
            level.m_7471_(pos, false);
        }
    }

    public void m_7592_(Level level, BlockPos pos, Explosion explosion) {
        if (level.f_46443_) {
            return;
        }
        LivingEntity living = explosion.m_252906_();
        BallistixPrimedExplosive primed = BallistixPrimedExplosive.spawn(level, pos, this.type, living);
        primed.setFuse(level.f_46441_.m_188503_(primed.getFuse() / 4 + 1) + primed.getFuse() / 8);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (this.type.isPressureTriggered() && entity instanceof LivingEntity) {
            this.explodeInstant(level, pos, (LivingEntity)entity);
        }
        super.m_7892_(state, level, pos, entity);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack held = player.m_21120_(hand);
        Item item = held.m_41720_();
        if (item != Items.f_42409_ && item != Items.f_42613_) {
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
        this.onCaughtFire(state, level, pos, hit.m_82434_(), (LivingEntity)player);
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
        if (!player.m_7500_()) {
            if (item == Items.f_42409_) {
                held.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            } else {
                held.m_41774_(1);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (!level.f_46443_ && projectile.m_6060_()) {
            LivingEntity owner;
            Entity entity = projectile.m_19749_();
            LivingEntity living = entity instanceof LivingEntity ? (owner = (LivingEntity)entity) : null;
            this.explodeFromLevel(level, hit.m_82425_(), living);
            level.m_7471_(hit.m_82425_(), false);
        }
    }

    public boolean m_6903_(Explosion explosion) {
        return false;
    }

    private void ignite(Level level, BlockPos pos, @Nullable LivingEntity igniter) {
        if (!level.f_46443_) {
            BallistixPrimedExplosive.spawn(level, pos, this.type, igniter);
        }
        level.m_5594_(null, pos, SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private void explodeFromLevel(Level level, BlockPos pos, @Nullable LivingEntity igniter) {
        this.ignite(level, pos, igniter);
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
    }

    private void explodeInstant(Level level, BlockPos pos, LivingEntity trigger) {
        if (!level.f_46443_) {
            BallistixExplosionHandlers.detonate(this.type, level, pos.m_252807_(), (Entity)trigger);
        }
        level.m_7471_(pos, false);
    }
}

