/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.compat.ballistix;

import java.util.Arrays;
import java.util.List;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.VoxelShape;

public enum BallistixExplosiveType {
    OBSIDIAN("obsidian", 120, 10.0f, BallistixExplosiveType.fullCube(), false),
    CONDENSIVE("condensive", 30, 2.5f, BallistixExplosiveType.fullCube(), false),
    ATTRACTIVE("attractive", 30, 6.0f, BallistixExplosiveType.fullCube(), false),
    REPULSIVE("repulsive", 30, 6.0f, BallistixExplosiveType.fullCube(), false),
    INCENDIARY("incendiary", 80, 7.0f, BallistixExplosiveType.fullCube(), false),
    SHRAPNEL("shrapnel", 40, 4.0f, BallistixExplosiveType.fullCube(), false),
    CHEMICAL("chemical", 100, 7.0f, BallistixExplosiveType.fullCube(), false),
    ANVIL("anvil", 100, 6.0f, BallistixExplosiveType.fullCube(), false),
    INFESTIVE("infestive", 40, 7.0f, BallistixExplosiveType.fullCube(), false),
    DEBILITATION("debilitation", 80, 7.0f, BallistixExplosiveType.fullCube(), false),
    FRAGMENTATION("fragmentation", 100, 8.0f, BallistixExplosiveType.fullCube(), false),
    CONTAGIOUS("contagious", 100, 7.0f, BallistixExplosiveType.fullCube(), false),
    BREACHING("breaching", 5, 5.0f, BallistixExplosiveType.fullCube(), false),
    THERMOBARIC("thermobaric", 100, 30.0f, BallistixExplosiveType.fullCube(), false),
    SONIC("sonic", 80, 20.0f, BallistixExplosiveType.fullCube(), false),
    ANTIGRAVITY("antigravity", 100, 12.0f, BallistixExplosiveType.fullCube(), false),
    EMP("emp", 80, 45.0f, BallistixExplosiveType.fullCube(), false),
    NUCLEAR("nuclear", 200, 45.0f, BallistixExplosiveType.fullCube(), false),
    ENDOTHERMIC("endothermic", 80, 30.0f, BallistixExplosiveType.fullCube(), false),
    EXOTHERMIC("exothermic", 80, 40.0f, BallistixExplosiveType.fullCube(), false),
    ENDER("ender", 100, 9.0f, BallistixExplosiveType.fullCube(), false),
    HYPERSONIC("hypersonic", 150, 30.0f, BallistixExplosiveType.fullCube(), false),
    REJUVINATION("rejuvination", 400, 12.0f, BallistixExplosiveType.fullCube(), false),
    ANTIMATTER("antimatter", 400, 45.0f, BallistixExplosiveType.fullCube(), false),
    LARGE_ANTIMATTER("largeantimatter", 600, 100.0f, BallistixExplosiveType.fullCube(), false),
    DARKMATTER("darkmatter", 400, 50.0f, BallistixExplosiveType.fullCube(), false),
    LANDMINE("landmine", 5, 2.5f, BallistixExplosiveType.landmineShape(), true);

    private static final VoxelShape FULL_CUBE;
    private static final VoxelShape LANDMINE_SHAPE;
    private final String id;
    private final int defaultFuse;
    private final float baseRadius;
    private final VoxelShape shape;
    private final boolean pressureTriggered;
    private static final List<BallistixExplosiveType> PORTED;

    private BallistixExplosiveType(String id, int defaultFuse, float baseRadius, VoxelShape shape, boolean pressureTriggered) {
        this.id = id;
        this.defaultFuse = defaultFuse;
        this.baseRadius = baseRadius;
        this.shape = shape;
        this.pressureTriggered = pressureTriggered;
    }

    public String id() {
        return this.id;
    }

    public int defaultFuse() {
        return this.defaultFuse;
    }

    public float baseRadius() {
        return this.baseRadius;
    }

    public VoxelShape shape() {
        return this.shape;
    }

    public boolean isPressureTriggered() {
        return this.pressureTriggered;
    }

    public static List<BallistixExplosiveType> portedTypes() {
        return PORTED;
    }

    private static VoxelShape fullCube() {
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    private static VoxelShape landmineShape() {
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    }

    static {
        FULL_CUBE = BallistixExplosiveType.fullCube();
        LANDMINE_SHAPE = BallistixExplosiveType.landmineShape();
        PORTED = Arrays.asList(BallistixExplosiveType.values());
    }
}

