/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.compat.ballistix;

import com.hbm.compat.ballistix.BallistixBlocks;
import com.hbm.compat.ballistix.BallistixEntities;
import com.hbm.compat.ballistix.BallistixExplosionHandlers;
import com.hbm.compat.ballistix.BallistixExplosiveBlock;
import com.hbm.compat.ballistix.BallistixExplosiveType;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class BallistixPrimedExplosive
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_FUSE = SynchedEntityData.m_135353_(BallistixPrimedExplosive.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_TYPE = SynchedEntityData.m_135353_(BallistixPrimedExplosive.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private LivingEntity owner;

    public BallistixPrimedExplosive(EntityType<? extends BallistixPrimedExplosive> type, Level level) {
        super(type, level);
        this.f_19850_ = true;
    }

    public BallistixPrimedExplosive(Level level, double x, double y, double z, @Nullable LivingEntity owner, BallistixExplosiveType explosiveType) {
        this((EntityType<? extends BallistixPrimedExplosive>)((EntityType)BallistixEntities.PRIMED_EXPLOSIVE.get()), level);
        this.m_6034_(x, y, z);
        double variance = level.f_46441_.m_188500_() * 0.2 - 0.1;
        this.m_20334_(variance, 0.2, variance);
        this.owner = owner;
        this.setExplosiveType(explosiveType);
        this.setFuse(explosiveType.defaultFuse());
    }

    public static BallistixPrimedExplosive spawn(Level level, BlockPos pos, BallistixExplosiveType type, @Nullable LivingEntity owner) {
        BallistixPrimedExplosive entity = new BallistixPrimedExplosive(level, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, owner, type);
        level.m_7967_((Entity)entity);
        return entity;
    }

    static void init() {
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_FUSE, (Object)80);
        this.f_19804_.m_135372_(DATA_TYPE, (Object)0);
    }

    protected void m_7378_(CompoundTag tag) {
        this.setFuse(tag.m_128448_("Fuse"));
        if (tag.m_128441_("ExplosiveType")) {
            String id = tag.m_128461_("ExplosiveType");
            for (BallistixExplosiveType candidate : BallistixExplosiveType.values()) {
                if (!candidate.id().equals(id)) continue;
                this.setExplosiveType(candidate);
                break;
            }
        }
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128376_("Fuse", (short)this.getFuse());
        tag.m_128359_("ExplosiveType", this.getExplosiveType().id());
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_ && !(this.m_9236_() instanceof ServerLevel)) {
            this.m_146870_();
            return;
        }
        Vec3 motion = this.m_20184_();
        if (!this.m_20068_()) {
            this.m_20334_(motion.f_82479_, motion.f_82480_ - 0.04, motion.f_82481_);
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.98));
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
        }
        int fuse = this.getFuse() - 1;
        this.setFuse(fuse);
        if (fuse <= 0) {
            this.m_146870_();
            if (!this.m_9236_().f_46443_) {
                BallistixExplosionHandlers.detonate(this.getExplosiveType(), this.m_9236_(), this.m_20182_(), (Entity)this.owner);
            }
        } else if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.2, this.m_20189_(), 0.0, 0.0, 0.0);
        } else if (fuse % 5 == 0) {
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 0.2f, 1.0f);
        }
    }

    public void setFuse(int fuse) {
        this.f_19804_.m_135381_(DATA_FUSE, (Object)fuse);
    }

    public int getFuse() {
        return (Integer)this.f_19804_.m_135370_(DATA_FUSE);
    }

    public BallistixExplosiveType getExplosiveType() {
        int ordinal = (Integer)this.f_19804_.m_135370_(DATA_TYPE);
        BallistixExplosiveType[] values = BallistixExplosiveType.values();
        return values[Math.max(0, Math.min(values.length - 1, ordinal))];
    }

    public void setExplosiveType(BallistixExplosiveType type) {
        this.f_19804_.m_135381_(DATA_TYPE, (Object)type.ordinal());
    }

    @Nullable
    public LivingEntity getOwner() {
        return this.owner;
    }

    public BlockState getRenderState() {
        return ((BallistixExplosiveBlock)((Object)BallistixBlocks.EXPLOSIVES.get((Object)this.getExplosiveType()).get())).m_49966_();
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

