/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.compat.bigexplosives;

import com.hbm.init.BigExplosivesModEntities;
import com.hbm.init.BigExplosivesModItems;
import com.hbm.init.BigExplosivesModParticleTypes;
import com.hbm.init.BigExplosivesModSounds;
import com.hbm.init.BigExplosivesModTabs;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class BigExplosivesMod {
    public static final String MODID = "big_explosives";
    public static final Logger LOGGER = LogManager.getLogger((String)"BigExplosives");
    private static final ServerScheduler SERVER_SCHEDULER = new ServerScheduler();

    private BigExplosivesMod() {
    }

    public static void register(IEventBus modEventBus) {
        BigExplosivesModItems.REGISTRY.register(modEventBus);
        BigExplosivesModEntities.REGISTRY.register(modEventBus);
        BigExplosivesModParticleTypes.REGISTRY.register(modEventBus);
        BigExplosivesModSounds.REGISTRY.register(modEventBus);
        BigExplosivesModTabs.REGISTRY.register(modEventBus);
    }

    public static void queueServerWork(int ticks, Runnable action) {
        SERVER_SCHEDULER.submit(ticks, Objects.requireNonNull(action, "action"));
    }

    private static final class ServerScheduler {
        private final Object lock = new Object();
        private final List<ScheduledTask> tasks = new ArrayList<ScheduledTask>();
        private boolean subscribed;

        private ServerScheduler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void submit(int ticks, Runnable action) {
            if (ticks <= 0) {
                action.run();
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                this.tasks.add(new ScheduledTask(ticks, action));
                this.ensureSubscribed();
            }
        }

        private void ensureSubscribed() {
            if (!this.subscribed) {
                MinecraftForge.EVENT_BUS.register((Object)this);
                this.subscribed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SubscribeEvent
        public void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                Iterator<ScheduledTask> iterator = this.tasks.iterator();
                while (iterator.hasNext()) {
                    ScheduledTask task = iterator.next();
                    if (!task.shouldRun()) continue;
                    try {
                        task.run();
                    }
                    catch (Throwable ex) {
                        LOGGER.error("Big Explosives scheduled task failed", ex);
                    }
                    finally {
                        iterator.remove();
                    }
                }
                if (this.tasks.isEmpty() && this.subscribed) {
                    MinecraftForge.EVENT_BUS.unregister((Object)this);
                    this.subscribed = false;
                }
            }
        }
    }

    private static final class ScheduledTask {
        private int remainingTicks;
        private final Runnable action;

        private ScheduledTask(int remainingTicks, Runnable action) {
            this.remainingTicks = remainingTicks;
            this.action = action;
        }

        boolean shouldRun() {
            return --this.remainingTicks <= 0;
        }

        void run() {
            this.action.run();
        }
    }
}

