/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.compat.jei;

import com.hbm.HBM;
import com.hbm.item.HBMComponent;
import com.hbm.item.HBMItems;
import com.hbm.item.icf.ItemICFPellet;
import com.hbm.registries.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class JEIICFPelletCategory
extends AbstractRecipeCategory<PelletRecipe> {
    public static final RecipeType<PelletRecipe> TYPE = RecipeType.create((String)"hbm", (String)"icf_pellet", PelletRecipe.class);
    private static final ResourceLocation TEXTURE = HBM.rl("textures/gui/processing/gui_icf_press.png");
    private final IDrawable background;

    public JEIICFPelletCategory(IGuiHelper guiHelper) {
        super(TYPE, (Component)Component.m_237115_((String)"jei.hbm.icf_press"), guiHelper.createDrawableItemLike((ItemLike)ModBlocks.machine_icf_press.get()), 176, 186);
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 176, 186);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PelletRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 98, 17).addItemStack(new ItemStack((ItemLike)HBMItems.icf_pellet_empty.get()))).setStandardSlotBackground();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 62, 53).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, recipe.leftInputs)).setStandardSlotBackground();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 134, 53).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, recipe.rightInputs)).setStandardSlotBackground();
        if (recipe.requiresMuon) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 8, 17).addItemStack(new ItemStack((ItemLike)HBMComponent.PARTICLE_MUON.get()))).setStandardSlotBackground();
        } else {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 8, 17).addItemStack(new ItemStack((ItemLike)HBMComponent.PARTICLE_EMPTY.get()))).setStandardSlotBackground();
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 98, 53).addItemStack(recipe.result.m_41777_())).setOutputSlotBackground();
    }

    public static List<PelletRecipe> createRecipes() {
        ArrayList<PelletRecipe> list = new ArrayList<PelletRecipe>();
        JEIICFPelletCategory.addPair(list, ItemICFPellet.FuelType.DEUTERIUM, ItemICFPellet.FuelType.TRITIUM, false);
        JEIICFPelletCategory.addPair(list, ItemICFPellet.FuelType.HELIUM3, ItemICFPellet.FuelType.HELIUM4, false);
        JEIICFPelletCategory.addPair(list, ItemICFPellet.FuelType.LITHIUM, ItemICFPellet.FuelType.OXYGEN, false);
        JEIICFPelletCategory.addPair(list, ItemICFPellet.FuelType.BERYLLIUM, ItemICFPellet.FuelType.CALCIUM, true);
        JEIICFPelletCategory.addPair(list, ItemICFPellet.FuelType.SODIUM, ItemICFPellet.FuelType.CHLORINE, true);
        return list;
    }

    private static void addPair(List<PelletRecipe> list, ItemICFPellet.FuelType one, ItemICFPellet.FuelType two, boolean muon) {
        if (!ItemICFPellet.isSupportedFuel(one) || !ItemICFPellet.isSupportedFuel(two)) {
            return;
        }
        List<ItemStack> left = ItemICFPellet.getFuelItems(one);
        List<ItemStack> right = ItemICFPellet.getFuelItems(two);
        if (left.isEmpty()) {
            left = ItemICFPellet.getFluidDisplays(one);
        }
        if (right.isEmpty()) {
            right = ItemICFPellet.getFluidDisplays(two);
        }
        if (left.isEmpty() || right.isEmpty()) {
            return;
        }
        list.add(new PelletRecipe(left, right, ItemICFPellet.createStack(one, two, muon), muon));
    }

    public record PelletRecipe(List<ItemStack> leftInputs, List<ItemStack> rightInputs, ItemStack result, boolean requiresMuon) {
    }
}

