/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.hbm.config.CommonConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.event.config.ModConfigEvent;

public final class ConfigRBMK {
    public static int columnHeight = 4;
    public static double passiveCooling = 1.0;
    public static double columnHeatFlow = 0.2;
    public static double reactivityModifier = 1.0;
    public static double meltdownHeat = 10000.0;
    public static double meltdownExplosionStrength = 6.0;

    private ConfigRBMK() {
    }

    public static void addConfig(ForgeConfigSpec.Builder builder) {
        builder.push("19_rbmk");
        CommonConfig.addInt(builder, "columnHeight", columnHeight, 2, 16, "RBMK \u4e3b\u4f53\u7684\u9ed8\u8ba4\u9ad8\u5ea6\uff08\u4e0d\u542b\u76d6\u677f\uff09\u3002");
        builder.comment("\u63a7\u5236\u88ab\u52a8\u51b7\u5374\u500d\u7387\uff0c\u7528\u4e8e\u5c1a\u672a\u63a5\u5165\u5916\u90e8\u51b7\u5374\u56de\u8def\u65f6\u7684\u7a33\u5b9a\u5ea6\u3002").defineInRange("passiveCooling", passiveCooling, 0.0, 10.0);
        builder.comment("\u67f1\u4f53\u4e4b\u95f4\u7684\u70ed\u91cf\u4f20\u9012\u6548\u7387\uff0c\u6570\u503c\u8d8a\u9ad8\uff0c\u70ed\u5e73\u8861\u8d8a\u5feb\u3002").defineInRange("columnHeatFlow", columnHeatFlow, 0.0, 1.0);
        builder.comment("\u53cd\u5e94\u5ea6\u4fee\u6b63\u7cfb\u6570\uff0c\u53ef\u7528\u4e8e\u6574\u4f53\u589e/\u51cf\u8f93\u51fa\u3002").defineInRange("reactivityModifier", reactivityModifier, 0.0, 10.0);
        builder.comment("\u5f53\u67f1\u4f53\u70ed\u91cf\u8d85\u8fc7\u8be5\u9608\u503c\u65f6\u89e6\u53d1\u7194\u6bc1/\u7206\u70b8\uff080 = \u7981\u7528\uff09\u3002").defineInRange("meltdownHeat", meltdownHeat, 0.0, 1.0E12);
        builder.comment("\u7194\u6bc1\u7206\u70b8\u5f3a\u5ea6\uff0c\u8d8a\u9ad8\u7834\u574f\u8303\u56f4\u8d8a\u5927\u3002").defineInRange("meltdownExplosionStrength", meltdownExplosionStrength, 0.0, 50.0);
        builder.pop();
    }

    public static void loadConfig(ModConfigEvent event) {
        CommentedConfig root = event.getConfig().getConfigData();
        if (!root.contains("19_rbmk")) {
            return;
        }
        Object categoryRaw = root.get("19_rbmk");
        if (!(categoryRaw instanceof CommentedConfig)) {
            return;
        }
        CommentedConfig category = (CommentedConfig)categoryRaw;
        columnHeight = Math.max(2, ((Number)category.get("columnHeight")).intValue());
        passiveCooling = Math.max(0.0, ((Number)category.get("passiveCooling")).doubleValue());
        columnHeatFlow = ConfigRBMK.clamp01(((Number)category.get("columnHeatFlow")).doubleValue());
        reactivityModifier = Math.max(0.0, ((Number)category.get("reactivityModifier")).doubleValue());
        meltdownHeat = Math.max(0.0, ((Number)category.get("meltdownHeat")).doubleValue());
        meltdownExplosionStrength = Math.max(0.0, ((Number)category.get("meltdownExplosionStrength")).doubleValue());
    }

    private static double clamp01(double value) {
        if (value < 0.0) {
            return 0.0;
        }
        if (value > 1.0) {
            return 1.0;
        }
        return value;
    }
}

