/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.config;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.HBM;
import com.hbm.datagen.recipe.ingredient.CountableIngredient;
import com.hbm.item.HBMComponent;
import com.hbm.registries.OreDictManager;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class CustomMachineConfigJSON {
    public static final Gson gson = new Gson();
    public static HashMap<String, MachineConfiguration> customMachines = new HashMap();
    public static List<MachineConfiguration> niceList = new ArrayList<MachineConfiguration>();

    public static void initialize() {
        File config = HBM.CONFIG_PATH.resolve("hbmCustomMachines.json").toFile();
        if (!config.exists()) {
            CustomMachineConfigJSON.writeDefault(config);
        }
        CustomMachineConfigJSON.readConfig(config);
    }

    public static void writeDefault(File config) {
        try {
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(config));
            writer.setIndent("  ");
            writer.beginObject();
            writer.name("machines").beginArray();
            writer.beginObject();
            writer.name("recipeKey").value("paperPress");
            writer.name("unlocalizedName").value("paperPress");
            writer.name("localization").beginObject();
            writer.name("de_DE").value("Papierpresse");
            writer.endObject();
            writer.name("localizedName").value("Paper Press");
            writer.name("fluidInCount").value(1L);
            writer.name("fluidInCap").value(1000L);
            writer.name("itemInCount").value(1L);
            writer.name("fluidOutCount").value(0L);
            writer.name("fluidOutCap").value(0L);
            writer.name("itemOutCount").value(1L);
            writer.name("generatorMode").value(false);
            writer.name("maxPollutionCap").value(100L);
            writer.name("fluxMode").value(false);
            writer.name("recipeSpeedMult").value(1.0);
            writer.name("recipeConsumptionMult").value(1.0);
            writer.name("maxPower").value(10000L);
            writer.name("maxHeat").value(0L);
            writer.name("recipeShape").beginArray();
            writer.value("IPI").value("PCP").value("IPI");
            writer.endArray();
            writer.name("recipeParts").beginArray().setIndent("");
            writer.value("I");
            CountableIngredient.writeConfigJson(CountableIngredient.of(OreDictManager.STEEL.ingot()), writer);
            writer.setIndent("");
            writer.value("P");
            CountableIngredient.writeConfigJson(CountableIngredient.of(OreDictManager.STEEL.plate()), writer);
            writer.setIndent("");
            writer.value("C");
            CountableIngredient.writeConfigJson(CountableIngredient.of((ItemLike)HBMComponent.CIRCUIT_BASIC.get(), 1), writer);
            writer.endArray().setIndent("  ");
            writer.name("components").beginArray();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = 0; z <= 2; ++z) {
                        if (x == 0 && y == 0 && z == 1 || x == 0 && z == 0) continue;
                        writer.beginObject().setIndent("");
                        writer.name("block").value(y == 0 ? "hbm:tile.cm_sheet" : "hbm:tile.cm_block");
                        writer.name("x").value((long)x);
                        writer.name("y").value((long)y);
                        writer.name("z").value((long)z);
                        writer.name("metas").beginArray();
                        writer.value(0L);
                        writer.endArray();
                        writer.endObject().setIndent("  ");
                    }
                }
            }
            writer.beginObject().setIndent("");
            writer.name("block").value("hbm:tile.cm_port");
            writer.name("x").value(0L);
            writer.name("y").value(-1L);
            writer.name("z").value(0L);
            writer.name("metas").beginArray();
            writer.value(0L);
            writer.endArray();
            writer.endObject().setIndent("  ");
            writer.beginObject().setIndent("");
            writer.name("block").value("hbm:tile.cm_port");
            writer.name("x").value(0L);
            writer.name("y").value(1L);
            writer.name("z").value(0L);
            writer.name("metas").beginArray();
            writer.value(0L);
            writer.endArray();
            writer.endObject().setIndent("  ");
            writer.endArray();
            writer.endObject();
            writer.endArray();
            writer.endObject();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void readConfig(File config) {
        try {
            JsonObject json = (JsonObject)gson.fromJson((Reader)new FileReader(config), JsonObject.class);
            JsonArray machines = json.get("machines").getAsJsonArray();
            for (int i = 0; i < machines.size(); ++i) {
                JsonObject machineObject = machines.get(i).getAsJsonObject();
                MachineConfiguration configuration = new MachineConfiguration();
                configuration.recipeKey = machineObject.get("recipeKey").getAsString();
                configuration.unlocalizedName = machineObject.get("unlocalizedName").getAsString();
                configuration.localizedName = machineObject.get("localizedName").getAsString();
                if (machineObject.has("localization")) {
                    JsonObject localization = machineObject.get("localization").getAsJsonObject();
                    for (Map.Entry entry : localization.entrySet()) {
                        configuration.localization.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                    }
                }
                configuration.fluidInCount = machineObject.get("fluidInCount").getAsInt();
                configuration.fluidInCap = machineObject.get("fluidInCap").getAsInt();
                configuration.itemInCount = machineObject.get("itemInCount").getAsInt();
                configuration.fluidOutCount = machineObject.get("fluidOutCount").getAsInt();
                configuration.fluidOutCap = machineObject.get("fluidOutCap").getAsInt();
                configuration.itemOutCount = machineObject.get("itemOutCount").getAsInt();
                configuration.generatorMode = machineObject.get("generatorMode").getAsBoolean();
                if (machineObject.has("maxPollutionCap")) {
                    configuration.maxPollutionCap = machineObject.get("maxPollutionCap").getAsInt();
                }
                if (machineObject.has("fluxMode")) {
                    configuration.fluxMode = machineObject.get("fluxMode").getAsBoolean();
                }
                configuration.recipeSpeedMult = machineObject.get("recipeSpeedMult").getAsDouble();
                configuration.recipeConsumptionMult = machineObject.get("recipeConsumptionMult").getAsDouble();
                configuration.maxPower = machineObject.get("maxPower").getAsLong();
                if (machineObject.has("maxHeat")) {
                    configuration.maxHeat = machineObject.get("maxHeat").getAsInt();
                }
                if (machineObject.has("recipeShape") && machineObject.has("recipeParts")) {
                    try {
                        int j;
                        JsonArray recipeShape = machineObject.get("recipeShape").getAsJsonArray();
                        JsonArray recipeParts = machineObject.get("recipeParts").getAsJsonArray();
                        Object[] parts = new Object[recipeShape.size() + recipeParts.size()];
                        for (j = 0; j < recipeShape.size(); ++j) {
                            parts[j] = recipeShape.get(j).getAsString();
                        }
                        for (j = 0; j < recipeParts.size(); ++j) {
                            Character o = null;
                            if (j % 2 == 0) {
                                o = Character.valueOf(recipeParts.get(j).getAsString().charAt(0));
                            } else {
                                CountableIngredient.readConfigJson(recipeParts.get(j).getAsJsonArray());
                            }
                            parts[j + recipeShape.size()] = o;
                        }
                    }
                    catch (Exception ex) {
                        HBM.LOGGER.error("Caught exception trying to parse core recipe for custom machine " + configuration.unlocalizedName);
                        HBM.LOGGER.error("recipeShape was" + machineObject.get("recipeShape").toString());
                        HBM.LOGGER.error("recipeParts was" + machineObject.get("recipeParts").toString());
                    }
                }
                JsonArray components = machineObject.get("components").getAsJsonArray();
                configuration.components = new ArrayList<MachineConfiguration.ComponentDefinition>();
                for (int j = 0; j < components.size(); ++j) {
                    JsonObject compObject = components.get(j).getAsJsonObject();
                    MachineConfiguration.ComponentDefinition compDef = new MachineConfiguration.ComponentDefinition();
                    compDef.x = compObject.get("x").getAsInt();
                    compDef.y = compObject.get("y").getAsInt();
                    compDef.z = compObject.get("z").getAsInt();
                    compDef.allowedMetas = new HashSet<Integer>();
                    compDef.metas = compObject.get("metas").getAsJsonArray();
                    for (int k = 0; k < compDef.metas.size(); ++k) {
                        compDef.allowedMetas.add(compDef.metas.get(k).getAsInt());
                    }
                    configuration.components.add(compDef);
                }
                customMachines.put(configuration.unlocalizedName, configuration);
                niceList.add(configuration);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class MachineConfiguration {
        public String recipeKey;
        public String unlocalizedName;
        public String localizedName;
        public HashMap<String, String> localization = new HashMap();
        public int fluidInCount;
        public int fluidInCap;
        public int itemInCount;
        public int fluidOutCount;
        public int fluidOutCap;
        public int itemOutCount;
        public boolean generatorMode;
        public int maxPollutionCap;
        public boolean fluxMode;
        public double recipeSpeedMult = 1.0;
        public double recipeConsumptionMult = 1.0;
        public long maxPower;
        public int maxHeat;
        public List<ComponentDefinition> components;

        public static class ComponentDefinition {
            public Block block;
            public Set<Integer> allowedMetas;
            public JsonArray metas;
            public int x;
            public int y;
            public int z;
        }
    }
}

