/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.HBM;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RunningConfig {
    public static final Gson gson = new Gson();

    public static File getConfig(String name) {
        return HBM.CONFIG_PATH.resolve(name).toFile();
    }

    public static void readConfig(File config, HashMap<String, ConfigWrapper> configMap) {
        try {
            JsonObject json = (JsonObject)gson.fromJson((Reader)new FileReader(config), JsonObject.class);
            for (Map.Entry<String, ConfigWrapper> line : configMap.entrySet()) {
                if (!json.has(line.getKey())) continue;
                JsonElement value = json.get(line.getKey());
                try {
                    if (!configMap.containsKey(line.getKey())) continue;
                    if (line.getValue().value instanceof String) {
                        configMap.get(line.getKey()).set(value.getAsString());
                    }
                    if (line.getValue().value instanceof Float) {
                        configMap.get(line.getKey()).set(Float.valueOf(value.getAsFloat()));
                    }
                    if (line.getValue().value instanceof Double) {
                        configMap.get(line.getKey()).set(value.getAsDouble());
                    }
                    if (line.getValue().value instanceof Integer) {
                        configMap.get(line.getKey()).set(value.getAsInt());
                    }
                    if (!(line.getValue().value instanceof Boolean)) continue;
                    configMap.get(line.getKey()).set(value.getAsBoolean());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void writeConfig(File config, HashMap<String, ConfigWrapper> configMap, String info) {
        try {
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(config));
            writer.setIndent("  ");
            writer.beginObject();
            writer.name("info").value(info);
            ArrayList<String> keys = new ArrayList<String>();
            keys.addAll(configMap.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                ConfigWrapper wrapper = configMap.get(key);
                Object value = wrapper.value;
                if (value instanceof String) {
                    writer.name(key).value((String)value);
                }
                if (value instanceof Float) {
                    writer.name(key).value((Number)((Float)value));
                }
                if (value instanceof Double) {
                    writer.name(key).value((Number)((Double)value));
                }
                if (value instanceof Integer) {
                    writer.name(key).value((Number)((Integer)value));
                }
                if (!(value instanceof Boolean)) continue;
                writer.name(key).value((Boolean)value);
            }
            writer.endObject();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class ConfigWrapper<T> {
        public T value;

        public ConfigWrapper(T o) {
            this.value = o;
        }

        public T get() {
            return this.value;
        }

        public void set(T value) {
            this.value = value;
        }

        public void update(String param) {
            Object stupidBufferObject = null;
            if (this.value instanceof String) {
                stupidBufferObject = param;
            }
            if (this.value instanceof Float) {
                stupidBufferObject = Float.valueOf(Float.parseFloat(param));
            }
            if (this.value instanceof Double) {
                stupidBufferObject = Double.parseDouble(param);
            }
            if (this.value instanceof Integer) {
                stupidBufferObject = Integer.parseInt(param);
            }
            if (this.value instanceof Boolean) {
                stupidBufferObject = Boolean.parseBoolean(param);
            }
            if (stupidBufferObject != null) {
                this.value = stupidBufferObject;
            }
        }
    }
}

