/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hbm.HBM;
import com.hbm.particle.ModParticleTypes;
import com.hbm.registries.HBMDamage;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DeathMessageType;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.VisibleForTesting;

public class HBMJsonProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final PackOutput output;
    protected final String modid;
    public final boolean isClient;
    @VisibleForTesting
    public final Map<ResourceLocation, JsonElement> dataToGenerate = new HashMap<ResourceLocation, JsonElement>();
    @VisibleForTesting
    public final ExistingFileHelper existingFileHelper;
    public final ResourceLocation particleRl = HBM.rl("particles/");
    public final ResourceLocation damageTypeRl = HBM.rl("damage_type/");

    public HBMJsonProvider(PackOutput output, String modid, ExistingFileHelper existingFileHelper, boolean isClient) {
        this.output = output;
        this.modid = modid;
        this.existingFileHelper = existingFileHelper;
        this.isClient = isClient;
    }

    private void registerData() {
        this.particleFile();
        this.damageType();
    }

    private void particleFile() {
        ModParticleTypes.generateJson(this);
    }

    public void simpleParticle(String name) {
        ResourceLocation rl = this.particleRl.m_266382_(name);
        JsonObject root = new JsonObject();
        JsonArray texture = new JsonArray();
        texture.add(HBM.rl(name).toString());
        root.add("textures", (JsonElement)texture);
        this.dataToGenerate.put(rl, (JsonElement)root);
    }

    private void damageType() {
        HBMDamage.damageTypeJson(this);
    }

    public void damageType(DamageType damageType) {
        ResourceLocation rl = this.damageTypeRl.m_266382_(damageType.f_268677_());
        JsonObject json = new JsonObject();
        json.addProperty("exhaustion", (Number)Float.valueOf(damageType.f_268663_()));
        json.addProperty("message_id", damageType.f_268677_());
        json.addProperty("scaling", damageType.f_268501_().m_7912_());
        if (damageType.f_268686_() != DamageEffects.HURT) {
            json.addProperty("effects", damageType.f_268686_().m_7912_());
        }
        if (damageType.f_268472_() != DeathMessageType.DEFAULT) {
            json.addProperty("death_message_type", damageType.f_268472_().m_7912_());
        }
        this.dataToGenerate.put(rl, (JsonElement)json);
    }

    public CompletableFuture<?> m_213708_(CachedOutput pOutput) {
        this.registerData();
        CompletableFuture[] futures = new CompletableFuture[this.dataToGenerate.size()];
        int i = 0;
        for (Map.Entry<ResourceLocation, JsonElement> entry : this.dataToGenerate.entrySet()) {
            Path target = this.getPath(entry.getKey());
            futures[i++] = DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)entry.getValue(), (Path)target);
        }
        return CompletableFuture.allOf(futures);
    }

    public String m_6055_() {
        return this.isClient ? "hbm_json" : "hbm_json_server";
    }

    protected Path getPath(ResourceLocation loc) {
        return this.output.m_247566_(PackOutput.Target.RESOURCE_PACK).resolve(loc.m_135827_()).resolve(loc.m_135815_() + ".json");
    }
}

