/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.datagen.model;

import com.hbm.HBM;
import com.hbm.block.env.BedRockOre;
import com.hbm.datagen.model.DecorateBlockStateProvider;
import com.hbm.datagen.model.ICategoryStateProvider;
import com.hbm.datagen.model.ObjMachineBlockStateProvider;
import com.hbm.registries.ModBlocks;
import com.hbm.render.model.Models;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockStateGen
extends BlockStateProvider {
    private List<ICategoryStateProvider> categoryStateProviders = new ArrayList<ICategoryStateProvider>();

    public BlockStateGen(PackOutput output, String modid, ExistingFileHelper exFileHelper) {
        super(output, modid, exFileHelper);
        this.categoryStateProviders.add(new DecorateBlockStateProvider(this));
        this.categoryStateProviders.add(new ObjMachineBlockStateProvider(this));
    }

    protected void registerStatesAndModels() {
        HBM.LOGGER.info("HBM BlockStateGen: generating block and item models");
        for (ICategoryStateProvider categoryStateProvider : this.categoryStateProviders) {
            categoryStateProvider.registerStatesAndModels();
        }
        ModBlocks.genModel(this);
        this.horizontalBlockWithItem((Block)ModBlocks.machine_battery.get(), (ModelFile)this.models().orientable("machine_battery", new ResourceLocation("hbm", "block/battery_side"), new ResourceLocation("hbm", "block/battery_front"), new ResourceLocation("hbm", "block/battery_top")));
        this.horizontalBlockWithItem((Block)ModBlocks.machine_lithium_battery.get(), (ModelFile)this.models().orientable("machine_lithium_battery", new ResourceLocation("hbm", "block/battery_lithium_side"), new ResourceLocation("hbm", "block/battery_lithium_front"), new ResourceLocation("hbm", "block/battery_lithium_top")));
        this.horizontalBlockWithItem((Block)ModBlocks.machine_schrabidium_battery.get(), (ModelFile)this.models().orientable("machine_schrabidium_battery", new ResourceLocation("hbm", "block/battery_schrabidium_side"), new ResourceLocation("hbm", "block/battery_schrabidium_front"), new ResourceLocation("hbm", "block/battery_schrabidium_top")));
        this.horizontalBlockWithItem((Block)ModBlocks.machine_dineutronium_battery.get(), (ModelFile)this.models().orientable("machine_dineutronium_battery", new ResourceLocation("hbm", "block/battery_dineutronium_side"), new ResourceLocation("hbm", "block/battery_dineutronium_front"), new ResourceLocation("hbm", "block/battery_dineutronium_top")));
        this.horizontalBlockWithItem((Block)ModBlocks.machine_shredder.get(), (ModelFile)this.models().orientableWithBottom("machine_shredder", new ResourceLocation("hbm", "block/machine_shredder_side"), new ResourceLocation("hbm", "block/machine_shredder_front"), new ResourceLocation("hbm", "block/machine_shredder_bottom"), new ResourceLocation("hbm", "block/machine_shredder_top")));
        ResourceLocation tokamakSide = new ResourceLocation("hbm", "block/tokamak_coil");
        ResourceLocation tokamakFront = new ResourceLocation("hbm", "block/tokamak_controller_front");
        ModelBuilder tokamakController = this.models().orientableWithBottom("tokamak_controller", tokamakSide, tokamakFront, tokamakSide, tokamakSide);
        this.horizontalBlockWithItem((Block)ModBlocks.tokamak_controller.get(), (ModelFile)tokamakController);
        this.simpleBlockWithItem((Block)ModBlocks.tokamak_casing.get(), (ModelFile)this.models().cubeAll("tokamak_casing", new ResourceLocation("hbm", "block/block_steel")));
        this.simpleBlockWithItem((Block)ModBlocks.tokamak_coil.get(), (ModelFile)this.models().cubeAll("tokamak_coil", tokamakSide));
        this.simpleBlockWithItem((Block)ModBlocks.tokamak_heater.get(), (ModelFile)this.models().cubeAll("tokamak_heater", tokamakSide));
        this.simpleBlockWithItem((Block)ModBlocks.tokamak_injector.get(), (ModelFile)this.models().cubeAll("tokamak_injector", tokamakSide));
        this.simpleBlockWithItem((Block)ModBlocks.tokamak_port.get(), (ModelFile)this.models().cubeAll("tokamak_port", tokamakSide));
        ModelFile.ExistingModelFile conveyorModel = this.models().getExistingFile(new ResourceLocation("hbm", "block/conveyor"));
        this.horizontalBlock((Block)ModBlocks.conveyor.get(), (ModelFile)conveyorModel);
        this.simpleBlockItem((Block)ModBlocks.conveyor.get(), (ModelFile)conveyorModel);
        BlockModelBuilder machineDifurnace_off = (BlockModelBuilder)this.models().orientableWithBottom("machine_difurnace_off", new ResourceLocation("hbm", "block/difurnace_side"), new ResourceLocation("hbm", "block/difurnace_front_off"), new ResourceLocation("hbm", "block/difurnace_bottom"), new ResourceLocation("hbm", "block/difurnace_top_off"));
        BlockModelBuilder machineDifurnace_on = (BlockModelBuilder)this.models().orientableWithBottom("machine_difurnace_on", new ResourceLocation("hbm", "block/difurnace_side"), new ResourceLocation("hbm", "block/difurnace_front_on"), new ResourceLocation("hbm", "block/difurnace_bottom"), new ResourceLocation("hbm", "block/difurnace_top_on"));
        this.addBooleanStateWithFace((Block)ModBlocks.machine_difurnace.get(), BlockStateProperties.f_61443_, (ModelFile)machineDifurnace_off, (ModelFile)machineDifurnace_on);
        BlockModelBuilder machineElectricFurnaceOff = (BlockModelBuilder)this.models().orientableWithBottom("machine_electric_furnace_off", new ResourceLocation("hbm", "block/machine_electric_furnace_side"), new ResourceLocation("hbm", "block/machine_electric_furnace_front_off"), new ResourceLocation("hbm", "block/machine_electric_furnace_bottom"), new ResourceLocation("hbm", "block/machine_electric_furnace_top"));
        BlockModelBuilder machineElectricFurnaceOn = (BlockModelBuilder)this.models().orientableWithBottom("machine_electric_furnace_on", new ResourceLocation("hbm", "block/machine_electric_furnace_side"), new ResourceLocation("hbm", "block/machine_electric_furnace_front_on"), new ResourceLocation("hbm", "block/machine_electric_furnace_bottom"), new ResourceLocation("hbm", "block/machine_electric_furnace_top"));
        this.addBooleanStateWithFace((Block)ModBlocks.machine_electric_furnace.get(), BlockStateProperties.f_61443_, (ModelFile)machineElectricFurnaceOff, (ModelFile)machineElectricFurnaceOn);
        BlockModelBuilder machine_boiler_off = (BlockModelBuilder)this.models().orientable("machine_boiler_off", new ResourceLocation("hbm", "block/machine_boiler_side"), new ResourceLocation("hbm", "block/machine_boiler_front"), new ResourceLocation("hbm", "block/machine_boiler_top"));
        BlockModelBuilder machine_boiler_on = (BlockModelBuilder)this.models().orientable("machine_boiler_on", new ResourceLocation("hbm", "block/machine_boiler_side"), new ResourceLocation("hbm", "block/machine_boiler_front_lit"), new ResourceLocation("hbm", "block/machine_boiler_top"));
        this.addBooleanStateWithFace((Block)ModBlocks.machine_boiler.get(), BlockStateProperties.f_61443_, (ModelFile)machine_boiler_off, (ModelFile)machine_boiler_on);
        BlockModelBuilder machine_electric_boiler_off = (BlockModelBuilder)this.models().orientable("machine_electric_boiler_off", new ResourceLocation("hbm", "block/machine_boiler_side"), new ResourceLocation("hbm", "block/machine_boiler_electric_front"), new ResourceLocation("hbm", "block/machine_boiler_electric_top"));
        BlockModelBuilder machine_electric_boiler_on = (BlockModelBuilder)this.models().orientable("machine_electric_boiler_on", new ResourceLocation("hbm", "block/machine_boiler_side"), new ResourceLocation("hbm", "block/machine_boiler_electric_front_lit"), new ResourceLocation("hbm", "block/machine_boiler_electric_top"));
        this.addBooleanStateWithFace((Block)ModBlocks.machine_electric_boiler.get(), BlockStateProperties.f_61443_, (ModelFile)machine_electric_boiler_off, (ModelFile)machine_electric_boiler_on);
        BlockModelBuilder machine_nuclear_boiler_off = (BlockModelBuilder)this.models().orientable("machine_nuclear_boiler_off", new ResourceLocation("hbm", "block/machine_boiler_nuclear_side"), new ResourceLocation("hbm", "block/machine_boiler_nuclear_front"), new ResourceLocation("hbm", "block/machine_boiler_top"));
        BlockModelBuilder machine_nuclear_boiler_on = (BlockModelBuilder)this.models().orientable("machine_nuclear_boiler_on", new ResourceLocation("hbm", "block/machine_boiler_nuclear_side"), new ResourceLocation("hbm", "block/machine_boiler_nuclear_front_lit"), new ResourceLocation("hbm", "block/machine_boiler_top"));
        this.addBooleanStateWithFace((Block)ModBlocks.machine_nuclear_boiler.get(), BlockStateProperties.f_61443_, (ModelFile)machine_nuclear_boiler_off, (ModelFile)machine_nuclear_boiler_on);
        this.addObjHorizonalModel((Block)ModBlocks.anvil_iron.get(), "block/anvil/anvil_iron");
        this.addObjHorizonalModel((Block)ModBlocks.anvil_bismuth.get(), "block/anvil/anvil_bismuth");
        this.addObjHorizonalModel((Block)ModBlocks.anvil_desh.get(), "block/anvil/anvil_desh");
        this.addObjHorizonalModel((Block)ModBlocks.machine_cracking_tower.get(), "block/cracking_tower/machine_cracking_tower");
        ModelFile.ExistingModelFile press_body_model = this.models().getExistingFile(new ResourceLocation("hbm", "block/press/press_body"));
        ModelFile.ExistingModelFile press_head_model = this.models().getExistingFile(new ResourceLocation("hbm", "block/press/press_head"));
        this.simpleBlockWithItem((Block)ModBlocks.machine_press.get(), (ModelFile)press_body_model);
        this.simpleBlock((Block)ModBlocks.part_press_head.get(), (ModelFile)press_head_model);
        ModelFile.ExistingModelFile crucible_model = this.models().getExistingFile(Models.CRUCIBLE);
        this.horizontalBlock((Block)ModBlocks.machine_crucible.get(), (ModelFile)crucible_model);
        this.simpleBlockItem((Block)ModBlocks.machine_crucible.get(), (ModelFile)crucible_model);
        ModelFile.ExistingModelFile bomb_model_fatman = this.models().getExistingFile(new ResourceLocation("hbm", "block/bomb/fat_man"));
        this.simpleBlockItem((Block)ModBlocks.bomb_fat_man.get(), (ModelFile)bomb_model_fatman);
        ModelFile.ExistingModelFile bomb_model_boy = this.models().getExistingFile(HBM.rl("block/bomb/boy"));
        this.simpleBlockItem((Block)ModBlocks.bomb_boy.get(), (ModelFile)bomb_model_boy);
        ModelFile.ExistingModelFile bomb_model_custom = this.models().getExistingFile(HBM.rl("block/bomb/custom"));
        this.simpleBlockItem((Block)ModBlocks.bomb_custom.get(), (ModelFile)bomb_model_custom);
        this.cableBlockWithItem();
    }

    public void simpleBlockWithItem(Block block, String path) {
        ModelFile.ExistingModelFile model = this.models().getExistingFile(HBM.rl(path));
        this.simpleBlockWithItem(block, (ModelFile)model);
    }

    public void horizontalBlockWithItem(Block block) {
        this.horizontalBlockWithItem(block, this.key(block).m_135815_());
    }

    public void horizontalBlockWithItem(Block block, String path) {
        ModelFile.ExistingModelFile model = this.models().getExistingFile(HBM.rl(path));
        this.horizontalBlockWithItem(block, (ModelFile)model);
    }

    public void horizontalBlockWithItem(Block block, ModelFile model) {
        this.horizontalBlock(block, model);
        this.simpleBlockItem(block, model);
    }

    public void addObjHorizonalModel(Block block, String name) {
        ModelFile.ExistingModelFile existingFile = this.models().getExistingFile(new ResourceLocation("hbm", name));
        this.horizontalBlock(block, (ModelFile)existingFile);
        this.simpleBlockItem(block, (ModelFile)existingFile);
    }

    private void addBooleanStateWithFace(Block block, BooleanProperty booleanProperty, ModelFile model1, ModelFile model2) {
        this.getVariantBuilder(block).forAllStates(state -> {
            Boolean value = (Boolean)state.m_61143_((Property)booleanProperty);
            return ConfiguredModel.builder().modelFile(value == Boolean.FALSE ? model1 : model2).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build();
        });
        this.simpleBlockItem(block, model1);
    }

    public <E extends Enum<E>> void addEnumStateBlock(Block block, EnumProperty<E> enumProperty, Function<Enum<E>, ModelFile> enumModelFileFunction) {
        this.getVariantBuilder(block).forAllStates(state -> {
            Enum value = (Enum)((Object)state.m_61143_((Property)enumProperty));
            return ConfiguredModel.builder().modelFile((ModelFile)enumModelFileFunction.apply(value)).build();
        });
    }

    public void addIntStateCubeAllBlock(Block block, IntegerProperty integerProperty) {
        ResourceLocation blockTexture = this.blockTexture(block);
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        VariantBlockStateBuilder.PartialBlockstate partialState = variantBuilder.partialState();
        for (Integer value : integerProperty.m_6908_()) {
            partialState.with((Property)integerProperty, (Comparable)value).addModels(new ConfiguredModel[]{ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeAll(this.name(block) + "_" + value, blockTexture.m_266382_("_" + value))).buildLast()});
        }
    }

    public ModelFile enumModelFileFunction_BedRockOreType(BedRockOre.BedRockOreType value) {
        return switch (value) {
            case BedRockOre.BedRockOreType.IRON -> this.models().getExistingFile(HBM.rl("block/env/bedrock_ore_iron"));
            case BedRockOre.BedRockOreType.COPPER -> this.models().getExistingFile(HBM.rl("block/env/bedrock_ore_copper"));
            default -> null;
        };
    }

    private void cableBlockWithItem() {
        ModelFile.ExistingModelFile inventory = this.models().getExistingFile(HBM.rl("block/pipes/cable_neo"));
        ModelFile.ExistingModelFile core = this.models().getExistingFile(HBM.rl("block/pipes/cable_core"));
        ModelFile.ExistingModelFile side = this.models().getExistingFile(HBM.rl("block/pipes/cable_side"));
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)ModBlocks.RED_CABLE.get()).part().modelFile((ModelFile)core).addModel()).end();
        this.sixWayMultipart(builder, (ModelFile)side);
        this.simpleBlockItem((Block)ModBlocks.RED_CABLE.get(), (ModelFile)inventory);
    }

    public void sixWayMultipart(MultiPartBlockStateBuilder builder, ModelFile side) {
        PipeBlock.f_55154_.entrySet().forEach(e -> {
            Direction dir = (Direction)e.getKey();
            if (dir.m_122434_().m_122479_()) {
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side).rotationY(((int)dir.m_122435_() + 180) % 360).uvLock(true).addModel()).condition((Property)e.getValue(), (Comparable[])new Boolean[]{true});
            } else {
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side).rotationX(dir == Direction.UP ? -90 : 90).uvLock(true).addModel()).condition((Property)e.getValue(), (Comparable[])new Boolean[]{true});
            }
        });
    }

    public String path(Block block) {
        return this.key(block).m_135815_();
    }

    public ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public String name(Block block) {
        return this.key(block).m_135815_();
    }
}

