/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.datagen.model;

import com.hbm.HBM;
import com.hbm.Inventory.fluid.ModFluids;
import com.hbm.item.HBMCombat;
import com.hbm.item.HBMComponent;
import com.hbm.item.HBMItems;
import com.hbm.item.HBMWeapon;
import com.hbm.item.HBMtools;
import com.hbm.registries.ModItems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemModelGen
extends ItemModelProvider {
    private final Set<ResourceLocation> generatedModels = new HashSet<ResourceLocation>();

    public ItemModelGen(PackOutput output, String modid, ExistingFileHelper existingFileHelper) {
        super(output, modid, existingFileHelper);
    }

    protected void registerModels() {
        ModItems.genModel(this);
        HBMtools.genModel(this);
        HBMComponent.genModel(this);
        HBMWeapon.genModel(this);
        HBMCombat.genModel(this);
        ModFluids.bucketModel(this);
        this.basicItem((Item)HBMItems.overlay_my_fluid.get());
        this.basicItem((Item)HBMItems.BEDROCK_ORE.get());
        this.basicItem((Item)HBMItems.SCREWDRIVER.get());
        this.generateMissingSimpleItemModels();
        ResourceLocation u238m2 = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)((Item)HBMItems.INGOT_U238M2.get())));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(u238m2.toString()).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", new ResourceLocation(u238m2.m_135827_(), "item/ingot_u238m2"))).override().predicate(HBM.rl("stage"), 1.0f).model((ModelFile)this.basicItem(HBM.rl("item/hs-elements"))).predicate(HBM.rl("stage"), 2.0f).model((ModelFile)this.basicItem(HBM.rl("item/hs-arsenic"))).predicate(HBM.rl("stage"), 3.0f).model((ModelFile)this.basicItem(HBM.rl("item/hs-vault"))).end();
    }

    public void registerOrdinaryItemModel(String key) {
        this.singleTexture(key, new ResourceLocation("item/generated"), "layer0", new ResourceLocation("hbm", "item/" + key));
    }

    public void builtinModel(Item item) {
        ResourceLocation resourceLocation = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item));
        this.withExistingParent(resourceLocation.toString(), "builtin/entity");
    }

    public ItemModelBuilder basicItem(Item item) {
        ItemModelBuilder builder = super.basicItem(item);
        this.markGenerated(ForgeRegistries.ITEMS.getKey((Object)item));
        return builder;
    }

    public ItemModelBuilder withExistingParent(String name, ResourceLocation parent) {
        ItemModelBuilder builder = (ItemModelBuilder)super.withExistingParent(name, parent);
        this.markGenerated(this.resolveName(name));
        return builder;
    }

    public ItemModelBuilder getBuilder(String name) {
        ItemModelBuilder builder = (ItemModelBuilder)super.getBuilder(name);
        this.markGenerated(this.resolveName(name));
        return builder;
    }

    private void markGenerated(ResourceLocation id) {
        if (id != null && "hbm".equals(id.m_135827_())) {
            this.generatedModels.add(id);
        }
    }

    private ResourceLocation resolveName(String name) {
        return name.contains(":") ? new ResourceLocation(name) : new ResourceLocation("hbm", name);
    }

    private void generateMissingSimpleItemModels() {
        Path manualModelDir = Paths.get("src", "main", "resources", "assets", "hbm", "models", "item");
        ForgeRegistries.ITEMS.getValues().forEach(item -> {
            if (item == null) {
                return;
            }
            ResourceLocation id = ForgeRegistries.ITEMS.getKey(item);
            if (id == null || !"hbm".equals(id.m_135827_())) {
                return;
            }
            if (this.generatedModels.contains(id)) {
                return;
            }
            if (Files.exists(manualModelDir.resolve(id.m_135815_() + ".json"), new LinkOption[0])) {
                return;
            }
            ResourceLocation manualModel = new ResourceLocation(id.m_135827_(), "models/item/" + id.m_135815_() + ".json");
            if (this.existingFileHelper != null && this.existingFileHelper.exists(manualModel, PackType.CLIENT_RESOURCES)) {
                return;
            }
            this.basicItem((Item)item);
        });
    }
}

