/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.datagen.recipe;

import com.hbm.Inventory.recipe.BlastFurnaceRecipe;
import com.hbm.datagen.recipe.ISubRecipeProvider;
import com.hbm.datagen.recipe.provider.AssemblerRecipeProvider;
import com.hbm.datagen.recipe.provider.ChemplantRecipeProvider;
import com.hbm.datagen.recipe.provider.MachineBlockRecipeProvider;
import com.hbm.datagen.recipe.provider.ShredderRecipeProvider;
import com.hbm.item.HBMItems;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class RecipeGen
extends RecipeProvider {
    private static Consumer<FinishedRecipe> pwriter;
    private final ExistingFileHelper existingFileHelper;
    private final List<ISubRecipeProvider> compatProviders = new ArrayList<ISubRecipeProvider>();
    public static int recipeCnt;

    public RecipeGen(PackOutput pOutput, ExistingFileHelper existingFileHelper, String modid) {
        super(pOutput);
        recipeCnt = 0;
        this.existingFileHelper = existingFileHelper;
    }

    protected void m_245200_(Consumer<FinishedRecipe> pWriter) {
        pwriter = pWriter;
        this.getSubRecipeProviders().forEach(subRecipeProvider -> subRecipeProvider.addRecipes(pwriter));
        BlastFurnaceRecipe.addDefaultRecipe(pWriter);
        RecipeGen.addShapelessRecipe((ItemLike)HBMItems.NUGGET_ZIRCONIUM.get(), 9, (ItemLike)HBMItems.INGOT_ZIRCONIUM.get(), HBMItems.INGOT_ZIRCONIUM.get(), 1);
        RecipeGen.addShapelessRecipe((ItemLike)HBMItems.INGOT_ZIRCONIUM.get(), 1, (ItemLike)HBMItems.INGOT_ZIRCONIUM.get(), HBMItems.NUGGET_ZIRCONIUM.get(), 9);
        RecipeGen.m_247434_(pWriter, (String)"smoking", (RecipeSerializer)RecipeSerializer.f_44093_, (int)100, (ItemLike)((ItemLike)HBMItems.GLYPHID_MEAT.get()), (ItemLike)((ItemLike)HBMItems.GLYPHID_MEAT_GRILLED.get()), (float)0.35f);
    }

    protected List<ISubRecipeProvider> getSubRecipeProviders() {
        return List.of(new AssemblerRecipeProvider(), new ChemplantRecipeProvider(), new ShredderRecipeProvider(), new MachineBlockRecipeProvider());
    }

    private static void addShapedRecipe(ItemLike output, int outnum, ItemLike crit, String pattern, Object ... input) {
        Object[] aobject = input;
        LinkedList in = new LinkedList();
        for (int j = 0; j < input.length; ++j) {
            if (aobject[j] instanceof Character) {
                in.offer(new TwoTuple((Character)aobject[j]));
                continue;
            }
            if (!(aobject[j] instanceof ItemLike)) continue;
            assert (in.peek() != null);
            ((TwoTuple)in.peek()).b = (ItemLike)aobject[j];
        }
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)outnum);
        builder = builder.m_126130_(pattern.substring(0, 3)).m_126130_(pattern.substring(3, 6)).m_126130_(pattern.substring(6));
        while (!in.isEmpty()) {
            TwoTuple tuple = (TwoTuple)in.poll();
            builder = builder.m_126127_((Character)tuple.a, (ItemLike)tuple.b);
        }
        builder = builder.m_126132_(RecipeProvider.m_176602_((ItemLike)crit), (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)crit));
        builder.m_126140_(pwriter, new ResourceLocation("hbm", RecipeGen.itemName(output) + "_" + recipeCnt++));
    }

    private static void addShapelessRecipe(ItemLike output, int outnum, ItemLike crit, Object ... input) {
        LinkedList in = new LinkedList();
        Object[] aobject = input;
        for (int j = 0; j < input.length; ++j) {
            if (aobject[j] instanceof ItemLike) {
                in.offer(new TwoTuple((ItemLike)aobject[j]));
                continue;
            }
            if (!(aobject[j] instanceof Integer)) continue;
            assert (in.peek() != null);
            ((TwoTuple)in.peek()).b = (Integer)aobject[j];
        }
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)outnum);
        while (!in.isEmpty()) {
            TwoTuple tuple = (TwoTuple)in.poll();
            builder = builder.m_126211_((ItemLike)tuple.a, ((Integer)tuple.b).intValue());
        }
        builder = builder.m_126132_(RecipeProvider.m_176602_((ItemLike)crit), (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)crit));
        builder.m_126140_(pwriter, new ResourceLocation("hbm", RecipeGen.itemName(output) + "_" + recipeCnt++));
    }

    private static String itemName(ItemLike item) {
        if (item instanceof Item) {
            return ForgeRegistries.ITEMS.getKey((Object)((Item)item).m_5456_()).m_135815_();
        }
        if (item instanceof Block) {
            return ForgeRegistries.BLOCKS.getKey((Object)((Block)item)).m_135815_();
        }
        return "";
    }

    private static class TwoTuple<A, B> {
        A a;
        B b;

        TwoTuple(A a) {
            this.a = a;
        }

        TwoTuple(A a, B b) {
            this.a = a;
            this.b = b;
        }
    }
}

