/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.datagen.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hbm.HBM;
import com.hbm.Inventory.recipe.ModRecipes;
import com.hbm.datagen.recipe.ingredient.CountableIngredient;
import com.hbm.datagen.recipe.ingredient.FluidStackIngredient;
import com.hbm.handler.pollution.PollutionType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class ItemFluidRecipeBuilder
implements FinishedRecipe {
    private ResourceLocation id = null;
    protected List<ItemStack> resultItems = new ArrayList<ItemStack>();
    protected List<FluidStack> resultFluids = new ArrayList<FluidStack>();
    protected List<CountableIngredient> rawItems = new ArrayList<CountableIngredient>();
    protected List<FluidStackIngredient> rawFluids = new ArrayList<FluidStackIngredient>();
    public int duration = -1;
    public int consumptionPerTick = -1;
    public PollutionType pollutionType = PollutionType.NONE;
    public float pollutionAmount = -1.0f;
    public float radiationAmount = -1.0f;
    public int flux = -1;
    public int heat = -1;
    private RecipeCategory category = RecipeCategory.MISC;
    private String group = "";
    private static int counter = 0;

    public static ItemFluidRecipeBuilder of(ResourceLocation id) {
        ItemFluidRecipeBuilder builder = new ItemFluidRecipeBuilder();
        builder.id = id;
        return builder;
    }

    public static ItemFluidRecipeBuilder of(RecipeCategory category) {
        ItemFluidRecipeBuilder builder = new ItemFluidRecipeBuilder();
        builder.category = category;
        return builder;
    }

    public ItemFluidRecipeBuilder resultItems(ItemStack ... itemStacks) {
        this.resultItems = Arrays.stream(itemStacks).toList();
        return this;
    }

    public ItemFluidRecipeBuilder resultFluids(FluidStack ... fluidStacks) {
        this.resultFluids = Arrays.stream(fluidStacks).toList();
        return this;
    }

    public ItemFluidRecipeBuilder requireItems(ItemStack ... itemStacks) {
        Arrays.stream(itemStacks).forEach(itemStack -> this.rawItems.add(CountableIngredient.of(itemStack)));
        return this;
    }

    public ItemFluidRecipeBuilder requireItemTag(TagKey<Item> tag, int count) {
        this.rawItems.add(CountableIngredient.of(tag, count));
        return this;
    }

    public ItemFluidRecipeBuilder requireFluids(FluidStack ... fluidStacks) {
        Arrays.stream(fluidStacks).forEach(fluidStack -> this.rawFluids.add(FluidStackIngredient.of(fluidStack)));
        return this;
    }

    public ItemFluidRecipeBuilder requireFluidTag(TagKey<Fluid> tag, int amount) {
        this.rawFluids.add(FluidStackIngredient.of(tag, amount));
        return this;
    }

    public ItemFluidRecipeBuilder duration(int duration) {
        this.duration = duration;
        return this;
    }

    public ItemFluidRecipeBuilder tickPower(int tickPower) {
        this.consumptionPerTick = tickPower;
        return this;
    }

    public ItemFluidRecipeBuilder pollution(PollutionType type, float pollutionAmount) {
        this.pollutionType = type;
        this.pollutionAmount = pollutionAmount;
        return this;
    }

    public ItemFluidRecipeBuilder rad(float radiationAmount) {
        this.radiationAmount = radiationAmount;
        return this;
    }

    public ItemFluidRecipeBuilder flux(int flux) {
        this.flux = flux;
        return this;
    }

    public ItemFluidRecipeBuilder heat(int heat) {
        this.heat = heat;
        return this;
    }

    public ItemFluidRecipeBuilder group(String group) {
        this.group = group;
        return this;
    }

    public void save(Consumer<FinishedRecipe> pFinishedRecipeConsumer) {
        if (this.id == null) {
            this.id = HBM.rl("chemplant_recipe_" + counter);
        }
        pFinishedRecipeConsumer.accept(this);
        ++counter;
    }

    public void m_7917_(JsonObject pJson) {
        if (!this.group.isEmpty()) {
            pJson.addProperty("group", this.group);
        }
        JsonArray jsonarray = new JsonArray();
        for (CountableIngredient countableIngredient : this.rawItems) {
            jsonarray.add(countableIngredient.m_43942_());
        }
        pJson.add("inputItems", (JsonElement)jsonarray);
        JsonArray jsonarray1 = new JsonArray();
        for (FluidStackIngredient rawFluid : this.rawFluids) {
            jsonarray1.add((JsonElement)rawFluid.toJson());
        }
        pJson.add("inputFluids", (JsonElement)jsonarray1);
        JsonArray jsonArray2 = new JsonArray();
        for (ItemStack resultItem : this.resultItems) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)resultItem.m_41720_()).toString());
            if (resultItem.m_41613_() > 1) {
                jsonObject.addProperty("count", (Number)resultItem.m_41613_());
            }
            jsonArray2.add((JsonElement)jsonObject.deepCopy());
        }
        pJson.add("resultItems", (JsonElement)jsonArray2.deepCopy());
        for (FluidStack fluidStack : this.resultFluids) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("fluids", BuiltInRegistries.f_257020_.m_7981_((Object)fluidStack.getFluid()).toString());
            jsonObject.addProperty("amount", (Number)fluidStack.getAmount());
            jsonArray2.add((JsonElement)jsonObject.deepCopy());
        }
        pJson.add("resultFluids", (JsonElement)jsonArray2);
        if (this.duration >= 0) {
            pJson.addProperty("duration", (Number)this.duration);
        }
        if (this.consumptionPerTick >= 0) {
            pJson.addProperty("tick_power", (Number)this.consumptionPerTick);
        }
        if (!this.pollutionType.equals((Object)PollutionType.NONE) && this.pollutionAmount >= 0.0f) {
            pJson.addProperty("pollution_type", (Number)this.pollutionType.ordinal());
            pJson.addProperty("pollution", (Number)Float.valueOf(this.pollutionAmount));
        }
        if (this.radiationAmount >= 0.0f) {
            pJson.addProperty("radiation", (Number)Float.valueOf(this.radiationAmount));
        }
        if (this.flux >= 0) {
            pJson.addProperty("flux", (Number)this.flux);
        }
        if (this.heat >= 0) {
            pJson.addProperty("heat", (Number)this.heat);
        }
    }

    public ResourceLocation m_6445_() {
        return this.id;
    }

    public RecipeSerializer<?> m_6637_() {
        return (RecipeSerializer)ModRecipes.CHEMPLANT.serializer().get();
    }

    @Nullable
    public JsonObject m_5860_() {
        return null;
    }

    @Nullable
    public ResourceLocation m_6448_() {
        return null;
    }
}

