/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.datagen.recipe.builder;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hbm.HBM;
import com.hbm.Inventory.recipe.ModRecipes;
import com.hbm.datagen.recipe.ingredient.CountableIngredient;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShapelessItemRecipeBuilder
implements RecipeBuilder {
    protected final Item result;
    protected final int count;
    private long number;
    private RecipeCategory category = RecipeCategory.MISC;
    private final List<CountableIngredient> ingredients = Lists.newArrayList();
    @Nullable
    private String group = "";

    protected ShapelessItemRecipeBuilder(RecipeCategory pCategory, ItemLike result, int count) {
        this.result = result.m_5456_();
        this.count = count;
    }

    public static ShapelessItemRecipeBuilder assembler(ItemLike pResult) {
        return new ShapelessItemRecipeBuilder(RecipeCategory.MISC, pResult, 1);
    }

    public static ShapelessItemRecipeBuilder assembler(ItemLike pResult, int pCount) {
        return new ShapelessItemRecipeBuilder(RecipeCategory.MISC, pResult, pCount);
    }

    public ShapelessItemRecipeBuilder num(long number) {
        this.number = number;
        return this;
    }

    public ShapelessItemRecipeBuilder requires(TagKey<Item> pTag) {
        return this.requires(CountableIngredient.of(pTag));
    }

    public ShapelessItemRecipeBuilder requires(TagKey<Item> pTag, int count) {
        return this.requires(CountableIngredient.of(pTag, count));
    }

    public ShapelessItemRecipeBuilder requires(ItemLike pItem) {
        return this.requires(pItem, 1);
    }

    public ShapelessItemRecipeBuilder requires(ItemLike pItem, int pQuantity) {
        this.requires(CountableIngredient.of(pItem, pQuantity));
        return this;
    }

    public ShapelessItemRecipeBuilder requires(CountableIngredient pIngredient) {
        this.ingredients.add(pIngredient);
        return this;
    }

    public RecipeBuilder m_126132_(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    @NotNull
    public Item m_142372_() {
        return this.result;
    }

    public void m_176500_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, String path) {
        pFinishedRecipeConsumer.accept(new Result(HBM.rl(path), this.result, this.count, this.group, this.category, this.ingredients, this.number));
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.result, this.count, this.group, this.category, this.ingredients, this.number));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final long number;
        private final String group;
        private final List<CountableIngredient> ingredients;

        public Result(ResourceLocation pId, Item pResult, int pCount, String pGroup, RecipeCategory pCategory, List<CountableIngredient> pIngredients, long number) {
            this.id = pId;
            this.result = pResult;
            this.count = pCount;
            this.group = pGroup;
            this.ingredients = pIngredients;
            this.number = number;
        }

        public void m_7917_(JsonObject pJson) {
            if (!this.group.isEmpty()) {
                pJson.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (CountableIngredient ingredient : this.ingredients) {
                jsonarray.add(ingredient.m_43942_());
            }
            pJson.add("ingredients", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).toString());
            if (this.count > 1) {
                jsonobject.addProperty("count", (Number)this.count);
            }
            pJson.add("result", (JsonElement)jsonobject);
            pJson.addProperty("number", (Number)this.number);
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipes.ASSEMBLER.serializer().get();
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @javax.annotation.Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @javax.annotation.Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

