/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.datagen.recipe.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hbm.Inventory.recipe.ModRecipes;
import com.hbm.datagen.recipe.ingredient.CountableIngredient;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleItemRecipeBuilder
implements RecipeBuilder {
    private final Item result;
    private final int count;
    private final RecipeSerializer<?> serializer;
    private CountableIngredient ingredient;
    private int duration = 60;

    protected SingleItemRecipeBuilder(ItemLike result, int count, RecipeSerializer<?> serializer) {
        this.result = result.m_5456_();
        this.count = count;
        this.serializer = serializer;
    }

    public static SingleItemRecipeBuilder shredder(ItemLike result) {
        return new SingleItemRecipeBuilder(result, 1, (RecipeSerializer)ModRecipes.SHREDDER.serializer().get());
    }

    public static SingleItemRecipeBuilder shredder(ItemLike result, int count) {
        return new SingleItemRecipeBuilder(result, count, (RecipeSerializer)ModRecipes.SHREDDER.serializer().get());
    }

    public SingleItemRecipeBuilder requires(ItemLike item) {
        return this.requires(item, 1);
    }

    public SingleItemRecipeBuilder requires(ItemLike item, int count) {
        return this.requires(CountableIngredient.of(item, count));
    }

    public SingleItemRecipeBuilder requires(TagKey<Item> tag) {
        return this.requires(tag, 1);
    }

    public SingleItemRecipeBuilder requires(TagKey<Item> tag, int count) {
        return this.requires(CountableIngredient.of(tag, count));
    }

    public SingleItemRecipeBuilder requires(CountableIngredient ingredient) {
        this.ingredient = ingredient;
        return this;
    }

    public SingleItemRecipeBuilder duration(int ticks) {
        this.duration = ticks;
        return this;
    }

    public RecipeBuilder m_126132_(String name, CriterionTriggerInstance trigger) {
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String groupName) {
        return this;
    }

    @NotNull
    public Item m_142372_() {
        return this.result;
    }

    public void m_176500_(Consumer<FinishedRecipe> consumer, String path) {
        this.m_126140_(consumer, new ResourceLocation("hbm", path));
    }

    public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.ingredient == null) {
            throw new IllegalStateException("Missing ingredient for recipe " + String.valueOf(id));
        }
        consumer.accept(new Result(id, this.ingredient, this.result, this.count, this.duration, this.serializer));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final CountableIngredient ingredient;
        private final Item result;
        private final int count;
        private final int duration;
        private final RecipeSerializer<?> serializer;

        private Result(ResourceLocation id, CountableIngredient ingredient, Item result, int count, int duration, RecipeSerializer<?> serializer) {
            this.id = id;
            this.ingredient = ingredient;
            this.result = result;
            this.count = count;
            this.duration = duration;
            this.serializer = serializer;
        }

        public void m_7917_(JsonObject json) {
            json.add("ingredient", this.ingredient.m_43942_());
            JsonObject resultObj = new JsonObject();
            resultObj.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).toString());
            if (this.count > 1) {
                resultObj.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)resultObj);
            json.addProperty("duration", (Number)this.duration);
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

