/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.datagen.recipe.ingredient;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonWriter;
import com.hbm.HBM;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.Nullable;

public class CountableIngredient
extends AbstractIngredient {
    public final Value value;
    public static final CountableIngredient EMPTY = new CountableIngredient(new Value());

    public static CountableIngredient of(ItemStack itemStack) {
        return new CountableIngredient(Value.item(itemStack));
    }

    public static CountableIngredient of(ItemLike itemLike, int count) {
        return new CountableIngredient(Value.item(new ItemStack(itemLike, count)));
    }

    public static CountableIngredient of(TagKey<Item> key) {
        return new CountableIngredient(Value.tag(key));
    }

    public static CountableIngredient of(TagKey<Item> key, int count) {
        return new CountableIngredient(Value.tag(key, count));
    }

    public CountableIngredient(Value value) {
        this.value = value;
    }

    public boolean isSimple() {
        return false;
    }

    public boolean test(@Nullable ItemStack pStack) {
        if (pStack == null) {
            return false;
        }
        if (!this.value.flagTag) {
            return this.value.itemStack.m_150930_(pStack.m_41720_());
        }
        boolean flag = false;
        for (ItemStack itemStack : this.value.m_6223_()) {
            if (!itemStack.m_150930_(pStack.m_41720_())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        return this.value.m_6544_();
    }

    public boolean m_43947_() {
        return this.value.isEmpty();
    }

    public ItemStack[] m_43908_() {
        return this.value.m_6223_().toArray(new ItemStack[0]);
    }

    static TagKey<Item> parseTagKey(String s) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(s.substring(s.indexOf(" / ") + 3, s.length() - 1)));
    }

    public static void writeConfigJson(CountableIngredient ingredient, JsonWriter writer) throws IOException {
        writer.beginArray();
        writer.setIndent("");
        Value value = ingredient.value;
        if (!value.flagTag) {
            writer.value("item");
            writer.value(BuiltInRegistries.f_257033_.m_7981_((Object)value.itemStack.m_41720_()).toString());
            if (value.itemStack.m_41763_()) {
                writer.value((long)value.itemStack.m_41773_());
            }
        } else {
            writer.value("tag");
            writer.value(value.tagKey.f_203868_().toString());
        }
        if (value.count != 1) {
            writer.value((long)value.count);
        }
        writer.endArray();
        writer.setIndent("  ");
    }

    public static CountableIngredient readConfigJson(JsonArray array) {
        try {
            int stacksize;
            String type = array.get(0).getAsString();
            int n = stacksize = array.size() > 2 ? array.get(2).getAsInt() : 1;
            if ("item".equals(type)) {
                Item item = ShapedRecipe.m_151278_((JsonObject)array.get(1).getAsJsonObject());
                int meta = array.size() > 3 ? array.get(3).getAsInt() : 0;
                ItemStack itemStack = new ItemStack((ItemLike)item, stacksize);
                itemStack.m_41721_(meta);
                return CountableIngredient.of(itemStack);
            }
            if ("tag".equals(type)) {
                ResourceLocation resourcelocation = new ResourceLocation(array.get(1).getAsString());
                TagKey tagkey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)resourcelocation);
                return CountableIngredient.of((TagKey<Item>)tagkey, stacksize);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        HBM.LOGGER.error("Error reading stack array " + array.toString());
        return CountableIngredient.of(ItemStack.f_41583_);
    }

    public static class Value
    implements Ingredient.Value {
        public boolean flagTag = false;
        public ItemStack itemStack = null;
        public TagKey<Item> tagKey = null;
        public int count = 0;

        public static Value item(ItemStack itemStack) {
            Value value = new Value();
            value.itemStack = itemStack;
            value.count = itemStack.m_41613_();
            return value;
        }

        public static Value tag(TagKey<Item> pTag) {
            return Value.tag(pTag, 1);
        }

        public static Value tag(TagKey<Item> pTag, int count) {
            Value value = new Value();
            value.flagTag = true;
            value.tagKey = pTag;
            value.count = count;
            return value;
        }

        public boolean isEmpty() {
            return this.itemStack == null && this.tagKey == null;
        }

        public Collection<ItemStack> m_6223_() {
            if (!this.flagTag) {
                return Collections.singleton(this.itemStack);
            }
            ArrayList list = Lists.newArrayList();
            for (Holder holder : BuiltInRegistries.f_257033_.m_206058_(this.tagKey)) {
                list.add(new ItemStack(holder));
            }
            if (list.isEmpty()) {
                list.add(new ItemStack((ItemLike)Blocks.f_50375_).m_41714_((Component)Component.m_237110_((String)"msg.hbm.empty_tag", (Object[])new Object[]{this.tagKey.f_203868_().toString()})));
            }
            return list;
        }

        public int getCount() {
            return this.count;
        }

        public JsonObject m_6544_() {
            JsonObject jsonobject = new JsonObject();
            if (!this.flagTag) {
                jsonobject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.itemStack.m_41720_()).toString());
                jsonobject.addProperty("count", (Number)this.count);
            } else {
                jsonobject.addProperty("tag", this.tagKey.f_203868_().toString());
                jsonobject.addProperty("count", (Number)this.count);
            }
            return jsonobject;
        }
    }

    public static class Serializer
    implements IIngredientSerializer<CountableIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public CountableIngredient parse(FriendlyByteBuf buffer) {
            Value value1 = new Value();
            boolean flag = buffer.readBoolean();
            int count = buffer.readInt();
            value1.flagTag = flag;
            if (flag) {
                int byteslen = buffer.readInt();
                String string = buffer.readBytes(byteslen).toString();
                TagKey<Item> tagKey = CountableIngredient.parseTagKey(string);
                value1.tagKey = tagKey;
            } else {
                ItemStack itemStack = buffer.m_130267_();
                itemStack.m_41764_(count);
                value1.itemStack = itemStack;
            }
            return new CountableIngredient(value1);
        }

        public CountableIngredient parse(JsonObject json) {
            if (json.has("item") && json.has("tag")) {
                throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
            }
            if (json.has("item")) {
                Item item = ShapedRecipe.m_151278_((JsonObject)json);
                int count = json.get("count").getAsInt();
                return CountableIngredient.of(new ItemStack((ItemLike)item, count));
            }
            if (json.has("tag")) {
                ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag"));
                TagKey tagkey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)resourcelocation);
                int count = json.get("count").getAsInt();
                return CountableIngredient.of((TagKey<Item>)tagkey, count);
            }
            throw new JsonParseException("An ingredient entry needs either a tag or an item");
        }

        public void write(FriendlyByteBuf buffer, CountableIngredient ingredient) {
            buffer.writeBoolean(ingredient.value.flagTag);
            buffer.writeInt(ingredient.value.getCount());
            if (ingredient.value.flagTag) {
                byte[] bytes = ingredient.value.tagKey.toString().getBytes();
                buffer.writeInt(bytes.length);
                buffer.writeBytes(bytes);
            } else {
                buffer.m_130055_(ingredient.value.itemStack);
            }
        }
    }
}

