/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.datagen.recipe.ingredient;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.hbm.Inventory.recipe.RecipeHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public class FluidStackIngredient {
    public static final FluidStackIngredient EMPTY = new FluidStackIngredient();
    public boolean flagTag = false;
    public FluidStack fluidStack = null;
    public TagKey<Fluid> tagKey = null;
    public int volume = 0;

    public static FluidStackIngredient of(FluidStack fluidStack) {
        FluidStackIngredient value = new FluidStackIngredient();
        value.fluidStack = fluidStack;
        value.volume = fluidStack.getAmount();
        return value;
    }

    public static FluidStackIngredient of(TagKey<Fluid> pTag) {
        return FluidStackIngredient.of(pTag, 1000);
    }

    public static FluidStackIngredient of(TagKey<Fluid> pTag, int count) {
        FluidStackIngredient value = new FluidStackIngredient();
        value.flagTag = true;
        value.tagKey = pTag;
        value.volume = count;
        return value;
    }

    public boolean isEmpty() {
        return this.fluidStack == null && this.tagKey == null;
    }

    public Collection<FluidStack> getFluids() {
        if (!this.flagTag) {
            return Collections.singleton(this.fluidStack);
        }
        ArrayList list = Lists.newArrayList();
        for (Holder holder : BuiltInRegistries.f_257020_.m_206058_(this.tagKey)) {
            list.add(new FluidStack((Fluid)holder.get(), this.volume));
        }
        return list;
    }

    public int getVolume() {
        return this.volume;
    }

    public boolean test(FluidStack pStack) {
        if (pStack == null) {
            return false;
        }
        if (!this.flagTag) {
            return this.fluidStack.isFluidEqual(pStack);
        }
        for (Holder fluidHolder : BuiltInRegistries.f_257020_.m_206058_(this.tagKey)) {
            if (!((Fluid)fluidHolder.m_203334_()).m_6212_(pStack.getFluid())) continue;
            return true;
        }
        return false;
    }

    public JsonObject toJson() {
        JsonObject jsonobject = new JsonObject();
        if (!this.flagTag) {
            jsonobject.addProperty("fluids", BuiltInRegistries.f_257020_.m_7981_((Object)this.fluidStack.getFluid()).toString());
        } else {
            jsonobject.addProperty("tag", this.tagKey.f_203868_().toString());
        }
        jsonobject.addProperty("volume", (Number)this.volume);
        return jsonobject;
    }

    public static FluidStackIngredient fromJson(JsonObject json) {
        if (json.has("fluids") && json.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an fluidStack, not both");
        }
        if (json.has("fluids")) {
            Fluid fluid = RecipeHelper.fluidFromJson(json);
            int count = json.get("volume").getAsInt();
            return FluidStackIngredient.of(new FluidStack(fluid, count));
        }
        if (json.has("tag")) {
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag"));
            TagKey tagkey = TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)resourcelocation);
            int count = json.get("volume").getAsInt();
            return FluidStackIngredient.of((TagKey<Fluid>)tagkey, count);
        }
        throw new JsonParseException("An ingredient entry needs either a tag or an item");
    }

    public static void toNetwork(FriendlyByteBuf buffer, FluidStackIngredient ingredient) {
        buffer.writeBoolean(ingredient.flagTag);
        if (ingredient.flagTag) {
            buffer.m_130085_(ingredient.tagKey.f_203868_());
        } else {
            buffer.writeFluidStack(ingredient.fluidStack);
        }
        buffer.writeInt(ingredient.volume);
    }

    public static FluidStackIngredient fromNetwork(FriendlyByteBuf buffer) {
        FluidStackIngredient ingredient = new FluidStackIngredient();
        ingredient.flagTag = buffer.readBoolean();
        if (ingredient.flagTag) {
            ResourceLocation resourceLocation = buffer.m_130281_();
            ingredient.tagKey = new TagKey(Registries.f_256808_, resourceLocation);
            if (!Fluids.f_76193_.m_205069_().m_203656_(ingredient.tagKey)) {
                throw new JsonParseException("An ingredient entry failed to load fluid tag");
            }
        } else {
            ingredient.fluidStack = buffer.readFluidStack();
        }
        ingredient.volume = buffer.readInt();
        return ingredient;
    }
}

