/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dev;

import com.hbm.HBM;
import com.hbm.render.model.BaseObjModel;
import com.hbm.render.model.entity.ModelGlyphid;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ModelValidator {
    private static final Logger LOGGER = LogManager.getLogger((String)"HBM-ModelValidator");
    private static final String PROPERTY = "hbm.modelValidate";

    private ModelValidator() {
    }

    public static void runIfRequested() {
        if (!Boolean.parseBoolean(System.getProperty(PROPERTY, "false"))) {
            return;
        }
        if (Minecraft.m_91087_() == null || Minecraft.m_91087_().m_91098_() == null) {
            LOGGER.warn("Minecraft resources unavailable; skipping model validation.");
            return;
        }
        LOGGER.info("HBM model validator enabled via -D{}=true", (Object)PROPERTY);
        ModelValidator.validateGlyphid();
    }

    private static void validateGlyphid() {
        try {
            ModelGlyphid glyphid = new ModelGlyphid();
            ResourceLocation json = HBM.modelRl("entity/glyphid");
            glyphid.parseJson(json);
            BaseObjModel root = glyphid.getRootModel();
            if (root == null) {
                LOGGER.warn("Glyphid model '{}' failed to load.", (Object)json);
                return;
            }
            HashSet<String> available = new HashSet<String>();
            ModelValidator.collectGroups(root, available);
            List<String> required = glyphid.trackedGroups();
            for (String group : required) {
                if (group == null || group.isEmpty() || available.contains(group)) continue;
                LOGGER.warn("Glyphid model '{}' missing group '{}'. OBJ / JSON mismatch detected.", (Object)root.getModelIdentifier(), (Object)group);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Glyphid model validation failed", (Throwable)ex);
        }
    }

    private static void collectGroups(BaseObjModel model, Set<String> groups) {
        if (model == null) {
            return;
        }
        if (model.name != null && !model.name.isEmpty()) {
            groups.add(model.name);
        }
        for (BaseObjModel child : model.children.values()) {
            ModelValidator.collectGroups(child, groups);
        }
    }
}

