/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.effect;

import com.hbm.entity.ModEntityType;
import com.hbm.particle.ModParticleTypes;
import com.hbm.particle.type.HBMSmokeParticle;
import com.hbm.utils.BobMth;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityNukeTorex
extends Entity {
    public static final EntityDataAccessor<Float> DATA_SCALE = SynchedEntityData.m_135353_(EntityNukeTorex.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> DATA_TYPE = SynchedEntityData.m_135353_(EntityNukeTorex.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public double coreHeight = 3.0;
    public double convectionHeight = 3.0;
    public double torusWidth = 3.0;
    public double rollerSize = 1.0;
    public double heat = 1.0;
    public double lastSpawnY = -1.0;
    public ArrayList<Cloudlet> cloudlets = new ArrayList();
    public boolean didPlaySound = false;
    public boolean didShake = false;

    public EntityNukeTorex(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public EntityNukeTorex(Level pLevel) {
        super((EntityType)ModEntityType.ENTITY_NUKE_TOREX.get(), pLevel);
    }

    public EntityNukeTorex(Level pLevel, Vec3 pos, float scale) {
        this(pLevel);
        this.m_146884_(pos);
        this.setScale(Mth.m_14036_((float)((float)BobMth.squirt((double)scale * 0.01) * 1.5f), (float)0.5f, (float)5.0f));
    }

    public EntityNukeTorex(Level pLevel, Vec3 pos, float scale, boolean type) {
        this(pLevel, pos, scale);
        if (type) {
            this.f_19804_.m_135381_(DATA_TYPE, (Object)1);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        double posX = this.m_20182_().f_82479_;
        double posY = this.m_20182_().f_82480_;
        double posZ = this.m_20182_().f_82481_;
        double s = 1.5;
        double cs = 1.5;
        int maxAge = this.getMaxAge();
        if (this.m_9236_().f_46443_) {
            int i;
            if (this.f_19797_ == 1) {
                this.setScale((float)s);
            }
            if (this.lastSpawnY == -1.0) {
                this.lastSpawnY = this.m_20182_().f_82480_ - 3.0;
            }
            int spawnTarget = Math.max(this.m_9236_().m_6924_(Heightmap.Types.WORLD_SURFACE, (int)Math.floor(this.m_20182_().f_82479_), (int)Math.floor(this.m_20182_().f_82481_)) - 3, 1);
            double moveSpeed = 0.5;
            this.lastSpawnY = Math.abs((double)spawnTarget - this.lastSpawnY) < moveSpeed ? (double)spawnTarget : (this.lastSpawnY += moveSpeed * Math.signum((double)spawnTarget - this.lastSpawnY));
            double range = (this.torusWidth - this.rollerSize) * 0.25;
            double simSpeed = this.getSimulationSpeed();
            int toSpawn = (int)Math.ceil(10.0 * simSpeed * simSpeed);
            int lifetime = Math.min(this.f_19797_ * this.f_19797_ + 200, maxAge - this.f_19797_ + 200);
            for (i = 0; i < toSpawn; ++i) {
                double x2 = posX + this.f_19796_.m_188583_() * range;
                double z = posZ + this.f_19796_.m_188583_() * range;
                Cloudlet cloud = new Cloudlet(x2, this.lastSpawnY, z, (float)(this.f_19796_.m_188500_() * 2.0 * Math.PI), 0, lifetime);
                cloud.setScale(1.0f + (float)this.f_19797_ * 0.005f * (float)cs, 5.0f * (float)cs);
                this.cloudlets.add(cloud);
            }
            if (this.f_19797_ < 150) {
                int cloudCount = this.f_19797_ * 5;
                int shockLife = Math.max(300 - this.f_19797_ * 20, 50);
                for (int i2 = 0; i2 < cloudCount; ++i2) {
                    Vec3 vec = new Vec3(((double)this.f_19797_ * 1.5 + this.f_19796_.m_188500_()) * 1.5, 0.0, 0.0);
                    float rot = (float)(Math.PI * 2 * this.f_19796_.m_188500_());
                    vec = vec.m_82524_(rot);
                    this.cloudlets.add(new Cloudlet(vec.f_82479_ + posX, this.m_9236_().m_6924_(Heightmap.Types.WORLD_SURFACE, (int)(vec.f_82479_ + posX) + 1, (int)(vec.f_82481_ + posZ)), vec.f_82481_ + posZ, rot, 0, shockLife, TorexType.SHOCK).setScale(7.0f, 2.0f).setMotion(this.f_19797_ > 15 ? 0.75 : 0.0));
                }
            }
            if ((double)this.f_19797_ < 130.0 * s) {
                lifetime = (int)((double)lifetime * s);
                for (i = 0; i < 2; ++i) {
                    Cloudlet cloud = new Cloudlet(posX, posY + this.coreHeight, posZ, (float)(this.f_19796_.m_188500_() * 2.0 * Math.PI), 0, lifetime, TorexType.RING);
                    cloud.setScale(1.0f + (float)this.f_19797_ * 0.0025f * (float)(cs * cs), 3.0f * (float)(cs * cs));
                    this.cloudlets.add(cloud);
                }
            }
            if ((double)this.f_19797_ > 130.0 * s && (double)this.f_19797_ < 600.0 * s) {
                for (i = 0; i < 20; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        float angle = (float)(Math.PI * 2 * this.f_19796_.m_188500_());
                        Vec3 vec = new Vec3(this.torusWidth + this.rollerSize * (5.0 + this.f_19796_.m_188500_()), 0.0, 0.0);
                        vec = vec.m_82535_((float)(0.06981317007977318 * (double)j)).m_82524_(angle);
                        Cloudlet cloud = new Cloudlet(posX + vec.f_82479_, posY + this.coreHeight - 5.0 + (double)j * s, posZ + vec.f_82481_, angle, 0, (int)((double)(20 + this.f_19797_ / 10) * (1.0 + this.f_19796_.m_188500_() * 0.1)), TorexType.CONDENSATION);
                        cloud.setScale(0.125f * (float)cs, 3.0f * (float)cs);
                        this.cloudlets.add(cloud);
                    }
                }
            }
            if ((double)this.f_19797_ > 200.0 * s && (double)this.f_19797_ < 600.0 * s) {
                for (i = 0; i < 20; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        float angle = (float)(Math.PI * 2 * this.f_19796_.m_188500_());
                        Vec3 vec = new Vec3(this.torusWidth + this.rollerSize * (3.0 + this.f_19796_.m_188500_() * 0.5), 0.0, 0.0);
                        vec = vec.m_82535_((float)(0.06981317007977318 * (double)j)).m_82524_(angle);
                        Cloudlet cloud = new Cloudlet(posX + vec.f_82479_, posY + this.coreHeight + 25.0 + (double)j * cs, posZ + vec.f_82481_, angle, 0, (int)((double)(20 + this.f_19797_ / 10) * (1.0 + this.f_19796_.m_188500_() * 0.1)), TorexType.CONDENSATION);
                        cloud.setScale(0.125f * (float)cs, 3.0f * (float)cs);
                        this.cloudlets.add(cloud);
                    }
                }
            }
            for (Cloudlet cloud : this.cloudlets) {
                cloud.update();
            }
            this.coreHeight += 0.15 / s;
            this.torusWidth += 0.05 / s;
            this.rollerSize = this.torusWidth * 0.35;
            this.convectionHeight = this.coreHeight + this.rollerSize;
            int maxHeat = (int)(50.0 * cs);
            this.heat = (double)maxHeat - Math.pow((double)(maxHeat * this.f_19797_) / (double)maxAge, 1.0);
            this.cloudlets.removeIf(x -> x.isDead);
        }
        if (!this.m_9236_().f_46443_ && this.f_19797_ > maxAge) {
            this.m_146870_();
        }
    }

    private float getScale() {
        return ((Float)this.f_19804_.m_135370_(DATA_SCALE)).floatValue();
    }

    private EntityNukeTorex setScale(float scale) {
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(DATA_SCALE, (Object)Float.valueOf(scale));
        }
        this.coreHeight = this.coreHeight / 1.5 * (double)scale;
        this.convectionHeight = this.convectionHeight / 1.5 * (double)scale;
        this.torusWidth = this.torusWidth / 1.5 * (double)scale;
        this.rollerSize = this.rollerSize / 1.5 * (double)scale;
        return this;
    }

    public double getGreying() {
        int lifetime = this.getMaxAge();
        int greying = lifetime * 3 / 4;
        if (this.f_19797_ > greying) {
            return 1.0 + (double)(this.f_19797_ - greying) / (double)(lifetime - greying);
        }
        return 1.0;
    }

    public float getAlpha() {
        int life = this.f_19797_;
        int lifetime = this.getMaxAge();
        int fadeOut = lifetime * 3 / 4;
        if (life > fadeOut) {
            float fac = (float)(life - fadeOut) / (float)(lifetime - fadeOut);
            return 1.0f - fac;
        }
        return 1.0f;
    }

    private int getMaxAge() {
        double s = this.getScale();
        return (int)(900.0 * s);
    }

    public double getSimulationSpeed() {
        int lifetime = this.getMaxAge();
        int simSlow = lifetime / 4;
        int life = this.f_19797_;
        int simStop = lifetime / 2;
        if (life > simStop) {
            return 0.0;
        }
        if (life > simSlow) {
            return 1.0 - (double)(life - simSlow) / (double)(simStop - simSlow);
        }
        return 1.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double pDistance) {
        return true;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_SCALE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(DATA_TYPE, (Object)0);
    }

    protected void m_7378_(CompoundTag pCompound) {
        this.setScale(pCompound.m_128457_("scale"));
        this.f_19804_.m_135381_(DATA_TYPE, (Object)pCompound.m_128451_("type"));
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128350_("scale", this.getScale());
        pCompound.m_128405_("type", ((Integer)this.f_19804_.m_135370_(DATA_TYPE)).intValue());
    }

    public class Cloudlet {
        public double posX;
        public double posY;
        public double posZ;
        public double prevPosX;
        public double prevPosY;
        public double prevPosZ;
        public double motionX;
        public double motionY;
        public double motionZ;
        public int age;
        public int cloudletLife;
        public float angle;
        public boolean isDead = false;
        float rangeMod = 1.0f;
        public float colorMod = 1.0f;
        public Vec3 color;
        public Vec3 prevColor;
        public TorexType type;
        private float startingScale = 1.0f;
        private float growingScale = 5.0f;
        private double motionMult = 1.0;

        public Cloudlet(double posX, double posY, double posZ, float angle, int age, int maxAge) {
            this(posX, posY, posZ, angle, age, maxAge, TorexType.STANDARD);
        }

        public Cloudlet(double posX, double posY, double posZ, float angle, int age, int maxAge, TorexType type) {
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.age = age;
            this.cloudletLife = maxAge;
            this.angle = angle;
            this.rangeMod = 0.3f + EntityNukeTorex.this.f_19796_.m_188501_() * 0.7f;
            this.colorMod = 0.8f + EntityNukeTorex.this.f_19796_.m_188501_() * 0.2f;
            this.type = type;
            this.updateColor();
        }

        private void update() {
            ++this.age;
            if (this.age > this.cloudletLife) {
                this.isDead = true;
            }
            this.prevPosX = this.posX;
            this.prevPosY = this.posY;
            this.prevPosZ = this.posZ;
            Vec3 simPos = new Vec3(EntityNukeTorex.this.m_20182_().f_82479_ - this.posX, 0.0, EntityNukeTorex.this.m_20182_().f_82481_ - this.posZ);
            double simPosX = EntityNukeTorex.this.m_20182_().f_82479_ + simPos.m_82553_();
            double simPosZ = EntityNukeTorex.this.m_20182_().f_82481_ + 0.0;
            if (this.type == TorexType.STANDARD) {
                Vec3 convection = this.getConvectionMotion(simPosX, simPosZ);
                Vec3 lift = this.getLiftMotion(simPosX, simPosZ);
                double factor = Mth.m_14008_((double)((this.posY - EntityNukeTorex.this.m_20182_().f_82479_) / EntityNukeTorex.this.coreHeight), (double)0.0, (double)1.0);
                this.motionX = convection.f_82479_ * factor + lift.f_82479_ * (1.0 - factor);
                this.motionY = convection.f_82480_ * factor + lift.f_82480_ * (1.0 - factor);
                this.motionZ = convection.f_82481_ * factor + lift.f_82481_ * (1.0 - factor);
            } else if (this.type == TorexType.SHOCK) {
                double factor = Mth.m_14008_((double)((this.posY - EntityNukeTorex.this.m_20182_().f_82480_) / EntityNukeTorex.this.coreHeight), (double)0.0, (double)1.0);
                Vec3 motion = new Vec3(1.0, 0.0, 0.0).m_82524_(this.angle);
                this.motionX = motion.f_82479_ * factor;
                this.motionY = motion.f_82480_ * factor;
                this.motionZ = motion.f_82481_ * factor;
            } else if (this.type == TorexType.RING) {
                motion = this.getRingMotion(simPosX, simPosZ);
                this.motionX = motion.f_82479_;
                this.motionY = motion.f_82480_;
                this.motionZ = motion.f_82481_;
            } else if (this.type == TorexType.CONDENSATION) {
                motion = this.getCondensationMotion();
                this.motionX = motion.f_82479_;
                this.motionY = motion.f_82480_;
                this.motionZ = motion.f_82481_;
            }
            double mult = this.motionMult * EntityNukeTorex.this.getSimulationSpeed();
            this.posX += this.motionX * mult;
            this.posY += this.motionY * mult;
            this.posZ += this.motionZ * mult;
            this.updateColor();
            try {
                ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
                HBMSmokeParticle particle = (HBMSmokeParticle)particleEngine.m_107395_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HBM_SMOKE.get()), this.posX, this.posY, this.posZ, this.motionX, this.motionY, this.motionZ);
                float brightness = this.type == TorexType.CONDENSATION ? 0.9f : 0.75f * this.colorMod;
                Vec3 vecColor = this.getInterpColor(0.5f).m_82490_((double)brightness);
                vecColor = new Vec3(Mth.m_14008_((double)vecColor.f_82479_, (double)0.0, (double)1.0), Mth.m_14008_((double)vecColor.f_82480_, (double)0.0, (double)1.0), Mth.m_14008_((double)vecColor.f_82481_, (double)0.0, (double)1.0));
                assert (particle != null);
                particle.m_107253_((float)vecColor.f_82479_, (float)vecColor.f_82480_, (float)vecColor.f_82481_);
                particle.m_6569_(this.getScale());
                particle.m_107271_(this.getAlpha());
                particleEngine.m_107344_((Particle)particle);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private Vec3 getCondensationMotion() {
            Vec3 delta = new Vec3(this.posX - EntityNukeTorex.this.m_20182_().f_82479_, 0.0, this.posZ - EntityNukeTorex.this.m_20182_().f_82481_);
            double speed = 2.0E-5 * (double)EntityNukeTorex.this.f_19797_;
            delta = new Vec3(delta.f_82479_ * speed, delta.f_82480_, delta.f_82481_ * speed);
            return delta;
        }

        private Vec3 getRingMotion(double simPosX, double simPosZ) {
            if (simPosX > EntityNukeTorex.this.m_20182_().f_82479_ + EntityNukeTorex.this.torusWidth * 2.0) {
                return new Vec3(0.0, 0.0, 0.0);
            }
            Vec3 torusPos = new Vec3(EntityNukeTorex.this.m_20182_().f_82479_ + EntityNukeTorex.this.torusWidth, EntityNukeTorex.this.m_20182_().f_82480_ + EntityNukeTorex.this.coreHeight * 0.5, EntityNukeTorex.this.m_20182_().f_82481_);
            Vec3 delta = new Vec3(torusPos.f_82479_ - simPosX, torusPos.f_82480_ - this.posY, torusPos.f_82481_ - simPosZ);
            double roller = EntityNukeTorex.this.rollerSize * (double)this.rangeMod * 0.25;
            double dist = delta.m_82553_() / roller - 1.0;
            double func = 1.0 - Math.pow(Math.E, -dist);
            float angle = (float)(func * Math.PI * 0.5);
            Vec3 rot = new Vec3(-delta.f_82479_ / dist, -delta.f_82480_ / dist, -delta.f_82481_ / dist);
            rot = rot.m_82535_(angle);
            Vec3 motion = new Vec3(torusPos.f_82479_ + rot.f_82479_ - simPosX, torusPos.f_82480_ + rot.f_82480_ - this.posY, torusPos.f_82481_ + rot.f_82481_ - simPosZ);
            double speed = 0.001;
            motion = motion.m_82490_(speed).m_82541_().m_82524_(this.angle);
            return motion;
        }

        private Vec3 getConvectionMotion(double simPosX, double simPosZ) {
            Vec3 torusPos = new Vec3(EntityNukeTorex.this.m_20182_().f_82479_ + EntityNukeTorex.this.torusWidth, EntityNukeTorex.this.m_20182_().f_82480_ + EntityNukeTorex.this.coreHeight, EntityNukeTorex.this.m_20182_().f_82481_);
            Vec3 delta = new Vec3(torusPos.f_82479_ - simPosX, torusPos.f_82480_ - this.posY, torusPos.f_82481_ - simPosZ);
            double roller = EntityNukeTorex.this.rollerSize * (double)this.rangeMod;
            double dist = delta.m_82553_() / roller - 1.0;
            double func = 1.0 - Math.pow(Math.E, -dist);
            float angle = (float)(func * Math.PI * 0.5);
            Vec3 rot = new Vec3(-delta.f_82479_ / dist, -delta.f_82480_ / dist, -delta.f_82481_ / dist);
            rot = rot.m_82535_(angle);
            Vec3 motion = new Vec3(torusPos.f_82479_ + rot.f_82479_ - simPosX, torusPos.f_82480_ + rot.f_82480_ - this.posY, torusPos.f_82481_ + rot.f_82481_ - simPosZ);
            motion = motion.m_82541_();
            motion = motion.m_82524_(this.angle);
            return motion;
        }

        private Vec3 getLiftMotion(double simPosX, double simPosZ) {
            double scale = Mth.m_14008_((double)(1.0 - (simPosX - (EntityNukeTorex.this.m_20182_().f_82479_ + EntityNukeTorex.this.torusWidth))), (double)0.0, (double)1.0);
            Vec3 motion = new Vec3(EntityNukeTorex.this.m_20182_().f_82479_ - this.posX, EntityNukeTorex.this.m_20182_().f_82480_ + EntityNukeTorex.this.convectionHeight - this.posY, EntityNukeTorex.this.m_20182_().f_82481_ - this.posZ);
            motion = motion.m_82541_().m_82490_(scale);
            return motion;
        }

        private void updateColor() {
            this.prevColor = this.color;
            double exX = EntityNukeTorex.this.m_20182_().f_82479_;
            double exY = EntityNukeTorex.this.m_20182_().f_82480_ + EntityNukeTorex.this.coreHeight;
            double exZ = EntityNukeTorex.this.m_20182_().f_82481_;
            double distX = exX - this.posX;
            double distY = exY - this.posY;
            double distZ = exZ - this.posZ;
            double distSq = distX * distX + distY * distY + distZ * distZ;
            double dist = Math.sqrt(distSq /= EntityNukeTorex.this.heat);
            dist = Math.max(dist, 1.0);
            double col = 2.0 / dist;
            int type = (Integer)EntityNukeTorex.this.f_19804_.m_135370_(DATA_TYPE);
            if (type == 1) {
                this.color = new Vec3(Math.max(col * 1.0, 0.25), Math.max(col * 2.0, 0.25), Math.max(col * 0.5, 0.25));
            } else if (type == 2) {
                Color color = Color.getHSBColor(this.angle / 2.0f / (float)Math.PI, 1.0f, 1.0f);
                this.color = this.type == TorexType.RING ? new Vec3(Math.max(col * 1.0, 0.25), Math.max(col * 1.0, 0.25), Math.max(col * 1.0, 0.25)) : new Vec3((double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0);
            } else {
                this.color = new Vec3(Math.max(col * 2.0, 0.25), Math.max(col * 1.5, 0.25), Math.max(col * 0.5, 0.25));
            }
        }

        public Vec3 getInterpPos(float interp) {
            float scale = EntityNukeTorex.this.getScale();
            Vec3 base = new Vec3(this.prevPosX + (this.posX - this.prevPosX) * (double)interp, this.prevPosY + (this.posY - this.prevPosY) * (double)interp, this.prevPosZ + (this.posZ - this.prevPosZ) * (double)interp);
            if (this.type != TorexType.SHOCK) {
                base = base.m_82546_(EntityNukeTorex.this.m_20182_()).m_82490_((double)scale).m_82549_(EntityNukeTorex.this.m_20182_());
            }
            return base;
        }

        public Vec3 getInterpColor(float interp) {
            if (this.type == TorexType.CONDENSATION) {
                return new Vec3(1.0, 1.0, 1.0);
            }
            double greying = EntityNukeTorex.this.getGreying();
            if (this.type == TorexType.RING) {
                greying += 1.0;
            }
            return new Vec3((this.prevColor.f_82479_ + (this.color.f_82479_ - this.prevColor.f_82479_) * (double)interp) * greying, (this.prevColor.f_82480_ + (this.color.f_82480_ - this.prevColor.f_82480_) * (double)interp) * greying, (this.prevColor.f_82481_ + (this.color.f_82481_ - this.prevColor.f_82481_) * (double)interp) * greying);
        }

        public float getAlpha() {
            float alpha = (1.0f - (float)this.age / (float)this.cloudletLife) * EntityNukeTorex.this.getAlpha();
            if (this.type == TorexType.CONDENSATION) {
                alpha = (float)((double)alpha * 0.25);
            }
            return alpha;
        }

        public float getScale() {
            float base = this.startingScale + (float)this.age / (float)this.cloudletLife * this.growingScale;
            if (this.type != TorexType.SHOCK) {
                base *= EntityNukeTorex.this.getScale();
            }
            return base;
        }

        public Cloudlet setScale(float start, float grow) {
            this.startingScale = start;
            this.growingScale = grow;
            return this;
        }

        public Cloudlet setMotion(double mult) {
            this.motionMult = mult;
            return this;
        }
    }

    public static enum TorexType {
        STANDARD,
        SHOCK,
        RING,
        CONDENSATION;

    }
}

