/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.logic;

import com.hbm.api.badthing.ContaminationUtil;
import com.hbm.config.ConfigBomb;
import com.hbm.entity.ModEntityType;
import com.hbm.entity.logic.EntityExplosionChunkLoading;
import com.hbm.explosion.ExplosionNukeGeneric;
import com.hbm.explosion.ExplosionNukeRayBatched;
import com.hbm.explosion.ExplosionNukeRayParallelized;
import com.hbm.explosion.IExplosionRay;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityNukeExplosionMK5
extends EntityExplosionChunkLoading {
    private static final int default_explode_strength = 100;
    public static final EntityDataAccessor<Integer> EXPLODE_STRENGTH = SynchedEntityData.m_135353_(EntityNukeExplosionMK5.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> EXPLODE_RADIUS = SynchedEntityData.m_135353_(EntityNukeExplosionMK5.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> RADIATION_SPEED = SynchedEntityData.m_135353_(EntityNukeExplosionMK5.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    IExplosionRay explosion;

    public EntityNukeExplosionMK5(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public EntityNukeExplosionMK5(Level pLevel) {
        super((EntityType)ModEntityType.ENTITY_NUKE_EXPLOSION_MK5.get(), pLevel);
    }

    public EntityNukeExplosionMK5(Level pLevel, Vec3 location, int strength, int radius, int speed) {
        super((EntityType)ModEntityType.ENTITY_NUKE_EXPLOSION_MK5.get(), pLevel);
        this.setStrength(strength);
        this.setRadius(radius);
        this.setSpeed(speed);
        this.m_146884_(location);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getStrength() == 0) {
            this.clearChunkLoader();
            this.m_146870_();
            return;
        }
        if (!this.m_9236_().f_46443_) {
            this.loadChunk((int)Math.floor(this.m_20182_().f_82479_ / 16.0), (int)Math.floor(this.m_20182_().f_82480_ / 16.0));
            this.radiate(2500000.0f / (float)(this.f_19797_ * 5 + 1), this.getRadius() * 2);
            ExplosionNukeGeneric.dealDamage(this.m_9236_(), this.m_20182_(), this.getRadius());
            if (this.explosion == null) {
                this.explosion = ConfigBomb.explosionAlgorithm == 1 ? new ExplosionNukeRayParallelized((ServerLevel)this.m_9236_(), this.m_20183_(), this.getStrength(), this.getRadius()) : new ExplosionNukeRayBatched(this.m_9236_(), this.m_20183_(), this.getStrength(), this.getSpeed(), this.getRadius());
            }
            if (!this.explosion.isComplete()) {
                this.explosion.cacheChunksTick(ConfigBomb.mk5);
                this.explosion.destructionTick(ConfigBomb.mk5);
            } else {
                this.clearChunkLoader();
                this.m_146870_();
            }
        }
    }

    private void radiate(float rads, double range) {
        List entities = this.m_9236_().m_45976_(LivingEntity.class, new AABB(this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_).m_82377_(range, range, range));
        for (LivingEntity e : entities) {
            Vec3 vec = new Vec3(e.m_20182_().f_82479_ - this.m_20182_().f_82479_, e.m_20182_().f_82480_ + (double)e.m_20192_() - this.m_20182_().f_82480_, e.m_20182_().f_82481_ - this.m_20182_().f_82481_);
            double len = vec.m_82553_();
            vec = vec.m_82541_();
            float res = 0.0f;
            int i = 1;
            while ((double)i < len) {
                int ix = (int)Math.floor(this.m_20182_().f_82479_ + vec.f_82479_ * (double)i);
                int iy = (int)Math.floor(this.m_20182_().f_82480_ + vec.f_82480_ * (double)i);
                int iz = (int)Math.floor(this.m_20182_().f_82481_ + vec.f_82481_ * (double)i);
                res += this.m_9236_().m_8055_(new BlockPos(ix, iy, iz)).m_60734_().m_7325_();
                ++i;
            }
            if (res < 1.0f) {
                res = 1.0f;
            }
            float eRads = rads;
            eRads /= res;
            ContaminationUtil.contaminate(e, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.RAD_BYPASS, eRads /= (float)(len * len));
        }
    }

    public static EntityNukeExplosionMK5 statFac(Level level, int r, Vec3 location) {
        int strength = r = r == 0 ? 25 : 2 * r;
        int speed = (int)Math.ceil(100000.0 / (double)strength);
        int radius = strength / 2;
        return new EntityNukeExplosionMK5(level, location, strength, radius, speed);
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        if (this.explosion != null) {
            this.explosion.cancel();
        }
        super.m_142687_(pReason);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(EXPLODE_STRENGTH, (Object)100);
        this.f_19804_.m_135372_(EXPLODE_RADIUS, (Object)100);
        this.f_19804_.m_135372_(RADIATION_SPEED, (Object)0);
    }

    protected void m_7378_(CompoundTag pCompound) {
        pCompound.m_128405_("strength", this.getStrength());
        pCompound.m_128405_("radius", this.getRadius());
        pCompound.m_128405_("speed", this.getSpeed());
    }

    protected void m_7380_(CompoundTag pCompound) {
        this.setStrength(pCompound.m_128451_("strength"));
        this.setRadius(pCompound.m_128451_("radius"));
        this.setSpeed(pCompound.m_128451_("speed"));
    }

    protected int getStrength() {
        return (Integer)this.f_19804_.m_135370_(EXPLODE_STRENGTH);
    }

    protected void setStrength(int strength) {
        this.f_19804_.m_135381_(EXPLODE_STRENGTH, (Object)strength);
    }

    protected int getRadius() {
        return (Integer)this.f_19804_.m_135370_(EXPLODE_RADIUS);
    }

    protected void setRadius(int radius) {
        this.f_19804_.m_135381_(EXPLODE_RADIUS, (Object)radius);
    }

    protected int getSpeed() {
        return (Integer)this.f_19804_.m_135370_(RADIATION_SPEED);
    }

    protected void setSpeed(int speed) {
        this.f_19804_.m_135381_(RADIATION_SPEED, (Object)speed);
    }
}

