/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob;

import com.hbm.api.entity.IResistanceProvider;
import com.hbm.config.MobConfig;
import com.hbm.entity.ModEntityType;
import com.hbm.entity.mob.GlyphidStatus;
import com.hbm.main.ResourceManager;
import com.hbm.registries.HBMDamage;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityGlyphid
extends Monster
implements IResistanceProvider {
    public BlockPos home = null;
    public int blastSize = Math.min((int)(3.0f * this.m_6134_()) / 2, 5);
    public int blastResToDig = Math.min((int)(50.0f * (this.m_6134_() * 2.0f)), 150);
    public boolean shouldDig;
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_INFECTED = 1;
    public static final int TYPE_RADIOACTIVE = 2;
    public static final EntityDataAccessor<Byte> DATA_WALL = SynchedEntityData.m_135353_(EntityGlyphid.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final EntityDataAccessor<Byte> DATA_ARMOR = SynchedEntityData.m_135353_(EntityGlyphid.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final EntityDataAccessor<Byte> DATA_SUBTYPE = SynchedEntityData.m_135353_(EntityGlyphid.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public EntityGlyphid(EntityType<? extends Monster> entityType, Level level) {
        this(level);
    }

    public EntityGlyphid(Level level) {
        super((EntityType)ModEntityType.GLYPHID.get(), level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_WALL, (Object)0);
        this.f_19804_.m_135372_(DATA_ARMOR, (Object)31);
        this.f_19804_.m_135372_(DATA_SUBTYPE, (Object)0);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder m_21552_() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, GlyphidStatus.GRUND.health).m_22268_(Attributes.f_22279_, GlyphidStatus.GRUND.speed).m_22268_(Attributes.f_22281_, GlyphidStatus.GRUND.damage);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new GoHomeGoal((PathfinderMob)this, 0.6));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public ResourceLocation getSkin() {
        return ResourceManager.glyphid_tex;
    }

    public float m_6134_() {
        return super.m_6134_();
    }

    public GlyphidStatus getStats() {
        return GlyphidStatus.GRUND;
    }

    @Override
    public float[] getCurrentDTDR(DamageSource damage, float amount, float pierceDT, float pierce) {
        if (damage.m_276093_(DamageTypes.f_268441_)) {
            return new float[]{0.0f, 0.0f};
        }
        GlyphidStatus stats = this.getStats();
        float threshold = stats.thresholdMultForArmor * (float)this.getGlyphidArmor() / 5.0f;
        if (damage.m_269533_(DamageTypeTags.f_268745_)) {
            return new float[]{0.0f, stats.resistanceMult * 0.2f};
        }
        if (damage.m_269533_(DamageTypeTags.f_268415_)) {
            return new float[]{threshold * 0.5f, stats.resistanceMult * 0.35f};
        }
        if (damage.m_276093_(HBMDamage.NUKE)) {
            return new float[]{threshold * 0.25f, 0.0f};
        }
        if (damage.m_269415_().equals((Object)((Registry)this.m_9236_().m_9598_().m_6632_(Registries.f_268580_).get()).m_246971_(HBMDamage.LASER).getType())) {
            return new float[]{threshold * 0.5f, stats.resistanceMult * 0.5f};
        }
        if (damage.m_269415_().equals((Object)((Registry)this.m_9236_().m_9598_().m_6632_(Registries.f_268580_).get()).m_246971_(HBMDamage.ELECTRIC).getType())) {
            return new float[]{threshold * 0.25f, stats.resistanceMult * 0.25f};
        }
        if (damage.m_269415_().equals((Object)((Registry)this.m_9236_().m_9598_().m_6632_(Registries.f_268580_).get()).m_246971_(HBMDamage.SUBAUTOMIC).getType())) {
            return new float[]{0.0f, stats.resistanceMult * 0.1f};
        }
        return new float[]{threshold, stats.resistanceMult};
    }

    @Override
    public void onDamageDealt(DamageSource damage, float amount) {
        if (this.isArmorBroken(amount)) {
            this.breakOffArmor();
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return super.m_6469_(pSource, pAmount);
    }

    protected boolean canDig() {
        return MobConfig.rampantDig;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.home == null) {
            this.home = this.m_20183_();
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.home != null) {
            pCompound.m_128365_("position", (Tag)NbtUtils.m_129224_((BlockPos)this.home));
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("position", 10)) {
            this.home = NbtUtils.m_129239_((CompoundTag)pCompound.m_128469_("position"));
        }
    }

    public boolean isArmorBroken(float amount) {
        return (double)this.f_19796_.m_188503_(100) <= Math.min(Math.pow((double)amount * 0.6, 2.0), 100.0);
    }

    public void breakOffArmor() {
        byte armor = (Byte)this.f_19804_.m_135370_(DATA_ARMOR);
        List<Integer> indices = Arrays.asList(0, 1, 2, 3, 4);
        Collections.shuffle(indices);
        for (Integer i : indices) {
            byte bit = (byte)(1 << i);
            if ((armor & bit) <= 0) continue;
            armor = (byte)(armor & ~bit);
            armor = (byte)(armor & 0x1F);
            this.f_19804_.m_135381_(DATA_ARMOR, (Object)armor);
            this.m_9236_().m_5594_(null, this.m_20097_(), SoundEvents.f_12630_, SoundSource.BLOCKS, 1.0f, 1.25f);
            break;
        }
    }

    public int getGlyphidArmor() {
        int total = 0;
        byte armor = (Byte)this.f_19804_.m_135370_(DATA_ARMOR);
        List<Integer> indices = Arrays.asList(0, 1, 2, 3, 4);
        for (Integer i : indices) {
            total += (armor & 1 << i) != 0 ? 1 : 0;
        }
        return total;
    }

    public boolean getCanSpawnHere() {
        return this.m_9236_().m_8055_(this.m_20183_()).m_247087_();
    }

    public static class GoHomeGoal
    extends Goal {
        public static final int DEFAULT_INTERVAL = 120;
        protected final PathfinderMob mob;
        protected final double speedModifier;
        protected Vec3 target = null;

        public GoHomeGoal(PathfinderMob pMob, double pSpeedModifier) {
            this.mob = pMob;
            this.speedModifier = pSpeedModifier;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.mob.m_20160_()) {
                return false;
            }
            PathfinderMob pathfinderMob = this.mob;
            if (pathfinderMob instanceof EntityGlyphid) {
                EntityGlyphid glyphid = (EntityGlyphid)pathfinderMob;
                Vec3 vec3 = this.target = glyphid.home == null ? null : glyphid.home.m_252807_();
            }
            if (this.target != null) {
                double dist2Home = this.mob.m_20182_().m_82554_(this.target);
                return dist2Home > 64.0;
            }
            return false;
        }

        public boolean m_8045_() {
            if (this.mob.m_20160_()) {
                return false;
            }
            if (this.target != null) {
                double dist2Home = this.mob.m_20182_().m_82554_(this.target);
                return dist2Home > 15.0;
            }
            return false;
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26519_(this.target.f_82479_, this.target.f_82480_, this.target.f_82481_, this.speedModifier);
        }

        public void m_8041_() {
            this.mob.m_21573_().m_26573_();
            super.m_8041_();
        }
    }

    public static class DigableChaseGoal
    extends HurtByTargetGoal {
        public DigableChaseGoal(PathfinderMob pMob, Class<?> ... pToIgnoreDamage) {
            super(pMob, (Class[])pToIgnoreDamage);
        }
    }

    public static class TerraformGoal
    extends Goal {
        public boolean m_8036_() {
            return false;
        }
    }

    public static class CommunicateGoal
    extends Goal {
        public boolean m_8036_() {
            return false;
        }
    }

    public static class BuildHiveGoal
    extends Goal {
        public boolean m_8036_() {
            return false;
        }
    }
}

