/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.projectile;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class EntityThrowableNT
extends ThrowableProjectile {
    public int ticksInGround;

    protected EntityThrowableNT(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public EntityThrowableNT(EntityType<? extends ThrowableProjectile> pEntityType, Level level, LivingEntity thrower) {
        this(pEntityType, level);
        this.m_5602_((Entity)thrower);
        this.m_20011_(this.setSize(0.25, 0.25));
        double deltaX = Mth.m_14089_((float)(this.m_146909_() * ((float)Math.PI / 180) * 0.16f));
        double deltaY = 0.1;
        double deltaZ = Mth.m_14031_((float)(this.m_146909_() * ((float)Math.PI / 180) * 0.16f));
        this.m_20182_().m_82492_(deltaX, deltaY, deltaZ);
        this.f_19855_ = 0.0;
        float velocity = 0.4f;
        this.m_37251_(this.m_19749_(), 1.0f, 1.0f, 1.0f, this.throwForce(), (float)(0.0172275 / this.headingForceMult()));
        this.ticksInGround = 0;
    }

    public EntityThrowableNT(EntityType<? extends ThrowableProjectile> pEntityType, Level level, double x, double y, double z) {
        this(pEntityType, level);
        this.m_6034_(x, y, z);
        this.m_20011_(this.setSize(0.25, 0.25));
        this.f_19855_ = 0.0;
        this.ticksInGround = 0;
    }

    protected float throwForce() {
        return 1.5f;
    }

    protected double headingForceMult() {
        return 0.0075;
    }

    protected float throwAngle() {
        return 0.0f;
    }

    protected double motionMult() {
        return 1.0;
    }

    private AABB setSize(double width, double height) {
        return AABB.m_165882_((Vec3)new Vec3(0.5, 0.5, 0.5), (double)width, (double)height, (double)width);
    }

    public void m_20334_(double pX, double pY, double pZ) {
        super.m_20334_(pX, pY, pZ);
        if (this.f_19859_ == 0.0f && this.f_19860_ == 0.0f) {
            float hyp = Mth.m_14116_((float)((float)(pX * pX + pZ * pZ)));
            this.f_19859_ = (float)(Math.atan2(pX, pZ) * 180.0 / Math.PI);
            this.m_146922_(this.f_19859_);
            this.f_19860_ = (float)(Math.atan2(pY, hyp) * 180.0 / Math.PI);
            this.m_146926_(this.f_19860_);
        }
    }

    public boolean doesImpactEntities() {
        return true;
    }

    public boolean doesPenetrate() {
        return false;
    }

    public boolean isSpectral() {
        return false;
    }

    public int selfDamageDelay() {
        return 5;
    }

    protected float getAirDrag() {
        return 0.99f;
    }

    protected float getWaterDrag() {
        return 0.8f;
    }

    protected int groundDespawn() {
        return 1200;
    }
}

