/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.weapon.grenade;

import com.hbm.item.HBMItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public abstract class ThrownGrenade
extends Projectile
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> DATA_GRENADE_STACK = SynchedEntityData.m_135353_(ThrownGrenade.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Integer> DATA_FUSE_ID = SynchedEntityData.m_135353_(ThrownGrenade.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ThrownGrenade(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ThrownGrenade(EntityType<?> pEntityType, double pX, double pY, double pZ, Level pLevel) {
        this(pEntityType, pLevel);
        this.m_6034_(pX, pY, pZ);
    }

    public ThrownGrenade(EntityType<?> pEntityType, LivingEntity pShooter, Level pLevel) {
        this(pEntityType, pShooter.m_20185_(), pShooter.m_20188_() - (double)0.1f, pShooter.m_20189_(), pLevel);
        this.m_5602_((Entity)pShooter);
    }

    protected void m_6532_(HitResult pResult) {
        super.m_6532_(pResult);
    }

    public void m_8119_() {
        float f;
        super.m_8119_();
        boolean bounce = false;
        HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        boolean flag = false;
        if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockpos = ((BlockHitResult)hitresult).m_82425_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (blockstate.m_60713_(Blocks.f_50142_)) {
                this.m_20221_(blockpos);
                flag = true;
            } else if (blockstate.m_60713_(Blocks.f_50446_)) {
                BlockEntity blockentity = this.m_9236_().m_7702_(blockpos);
                if (blockentity instanceof TheEndGatewayBlockEntity && TheEndGatewayBlockEntity.m_59940_((Entity)this)) {
                    TheEndGatewayBlockEntity.m_155828_((Level)this.m_9236_(), (BlockPos)blockpos, (BlockState)blockstate, (Entity)this, (TheEndGatewayBlockEntity)((TheEndGatewayBlockEntity)blockentity));
                }
                flag = true;
            }
            boolean bl = bounce = !flag;
        }
        if (hitresult.m_6662_() != HitResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.m_6532_(hitresult);
        }
        this.m_20101_();
        Vec3 vec3 = this.m_20184_();
        double d0 = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        if (!bounce) {
            d2 = this.m_20185_() + vec3.f_82479_;
            d0 = this.m_20186_() + vec3.f_82480_;
            d1 = this.m_20189_() + vec3.f_82481_;
        } else {
            BlockHitResult blockHitResult = (BlockHitResult)hitresult;
            d2 = this.m_20185_() + (blockHitResult.m_82450_().f_82479_ - this.m_20185_()) * 0.6;
            d0 = this.m_20186_() + (blockHitResult.m_82450_().f_82480_ - this.m_20186_()) * 0.6;
            d1 = this.m_20189_() + (blockHitResult.m_82450_().f_82481_ - this.m_20189_()) * 0.6;
            vec3 = switch (blockHitResult.m_82434_()) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.DOWN, Direction.UP -> new Vec3(vec3.f_82479_, -1.0 * vec3.f_82480_, vec3.f_82481_);
                case Direction.NORTH, Direction.SOUTH -> new Vec3(vec3.f_82479_, vec3.f_82480_, -1.0 * vec3.f_82481_);
                case Direction.EAST, Direction.WEST -> new Vec3(-1.0 * vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            };
            vec3 = vec3.m_82490_(this.getBounceMod());
        }
        this.m_37283_();
        if (this.m_20069_()) {
            for (int i = 0; i < 4; ++i) {
                float f1 = 0.25f;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, d2 - vec3.f_82479_ * 0.25, d0 - vec3.f_82480_ * 0.25, d1 - vec3.f_82481_ * 0.25, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            }
            f = 0.8f;
        } else {
            f = 0.99f;
        }
        this.m_20256_(vec3.m_82490_((double)f));
        if (!this.m_20068_() && !this.m_20096_()) {
            Vec3 vec31 = this.m_20184_();
            this.m_20334_(vec31.f_82479_, vec31.f_82480_ - (double)this.getGravity(), vec31.f_82481_);
        }
        this.m_6034_(d2, d0, d1);
        this.countDown();
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_GRENADE_STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_FUSE_ID, (Object)this.getDefaultFuseTime());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("Item"));
        this.setItem(itemstack);
        this.setFuse(pCompound.m_128448_("fuse"));
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        ItemStack itemstack = this.getItemRaw();
        if (!itemstack.m_41619_()) {
            pCompound.m_128365_("Item", (Tag)itemstack.m_41739_(new CompoundTag()));
        }
        pCompound.m_128376_("fuse", (short)this.getFuse());
    }

    public void setItem(ItemStack pStack) {
        if (!pStack.m_150930_(this.getDefaultItem()) || pStack.m_41782_()) {
            this.m_20088_().m_135381_(DATA_GRENADE_STACK, (Object)pStack.m_255036_(1));
        }
    }

    protected ItemStack getItemRaw() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_GRENADE_STACK);
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)HBMItems.grenade_generic.get();
    }

    @NotNull
    public ItemStack m_7846_() {
        ItemStack itemstack = this.getItemRaw();
        return itemstack.m_41619_() ? new ItemStack((ItemLike)this.getDefaultItem()) : itemstack;
    }

    public void setFuse(int pLife) {
        this.f_19804_.m_135381_(DATA_FUSE_ID, (Object)pLife);
    }

    public int getFuse() {
        return (Integer)this.f_19804_.m_135370_(DATA_FUSE_ID);
    }

    public boolean m_6783_(double pDistance) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return pDistance < (d0 *= 64.0) * d0;
    }

    protected float getGravity() {
        return 0.03f;
    }

    public abstract double getBounceMod();

    public abstract int getDefaultFuseTime();

    public void countDown() {
        int i = this.getFuse();
        if (i <= 0) {
            if (!this.m_9236_().f_46443_) {
                this.explode();
            }
        } else {
            this.setFuse(i - 1);
        }
    }

    public abstract void explode();
}

