/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.weapon.missile;

import com.hbm.entity.IRadarDetectableNT;
import com.hbm.entity.projectile.EntityThrowableNT;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.standard.BlockAllocatorStandard;
import com.hbm.explosion.vanillant.standard.PlayerProcessorStandard;
import com.hbm.item.weapon.ItemMissilePart;
import com.hbm.particle.ParticleSystem;
import com.hbm.utils.chunk.ChunkLoadHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.world.ForgeChunkManager;

public abstract class EntityMissile
extends EntityThrowableNT
implements IRadarDetectableNT {
    public BlockPos start;
    public BlockPos target;
    public double velocity;
    public double yV0;
    public double decelY;
    public double accelXZ;
    public boolean startAcc = true;
    public boolean isCluster = false;
    public static final EntityDataAccessor<Byte> DATA_MISSILE_1 = SynchedEntityData.m_135353_(EntityMissile.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public int health = 50;
    List<ChunkPos> loadedChunks = new ArrayList<ChunkPos>();

    public EntityMissile(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.start = this.target = this.m_20183_();
        if (!this.m_9236_().f_46443_) {
            ChunkLoadHelper.register((Entity)this);
        }
    }

    public EntityMissile(EntityType<? extends ThrowableProjectile> pEntityType, Level level, float x, float y, float z, BlockPos target) {
        this(pEntityType, level);
        this.entityInit();
        this.m_6034_(x, y, z);
        this.start = new BlockPos((int)x, (int)y, (int)z);
        this.target = target;
        this.yV0 = this.getyV0(x, y, z, target);
        this.m_20334_(this.m_20184_().f_82479_, 0.0, this.m_20184_().f_82481_);
        Vec3 vector = new Vec3((double)(target.m_123341_() - this.start.m_123341_()), 0.0, (double)(target.m_123343_() - this.start.m_123343_()));
        this.accelXZ = this.decelY = 1.0 / vector.m_82553_();
        this.velocity = 0.0;
        this.setSize(1.5, 1.5);
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }

    public abstract ItemStack getMissileItemForInfo();

    @Override
    public boolean canBeSeenBy(Object radar) {
        return true;
    }

    @Override
    public boolean paramsApplicable(IRadarDetectableNT.RadarScanParams params) {
        return params.scanMissiles;
    }

    @Override
    public boolean suppliesRedstone(IRadarDetectableNT.RadarScanParams params) {
        return params.smartMode && this.m_20184_().f_82480_ >= 0.0;
    }

    @Override
    protected double motionMult() {
        return this.velocity;
    }

    @Override
    public boolean doesImpactEntities() {
        return false;
    }

    public void m_8119_() {
        if (this.velocity < 4.0 && !this.startAcc) {
            this.velocity += Mth.m_14008_((double)((double)this.f_19797_ / 60.0 * 0.05), (double)0.0, (double)0.05);
        }
        if (!this.m_9236_().f_46443_) {
            double motionX = this.m_20184_().f_82479_;
            double motionY = this.m_20184_().f_82480_;
            double motionZ = this.m_20184_().f_82481_;
            if (this.hasPropulsion()) {
                if (this.startAcc) {
                    if ((motionY += 0.05) >= this.yV0) {
                        this.startAcc = false;
                    }
                } else {
                    motionY -= this.decelY * this.velocity;
                    double f = 2.0 * this.accelXZ * this.velocity;
                    motionX = (this.target.m_252807_().f_82479_ - this.m_20185_()) * f;
                    motionZ = (this.target.m_252807_().f_82481_ - this.m_20189_()) * f;
                }
            } else if (motionY > -1.5) {
                motionY -= 0.2;
            }
            if (motionY < -this.velocity && this.isCluster) {
                this.cluster();
                this.setDead();
                return;
            }
            this.m_20334_(motionX, motionY, motionZ);
        }
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.spawnContrail();
        }
        this.loadNeighboringChunks((int)Math.floor(this.m_20185_() / 16.0), (int)Math.floor(this.m_20189_() / 16.0));
    }

    public boolean hasPropulsion() {
        return true;
    }

    public double getyV0(float x, float y, float z, BlockPos target) {
        float dist0 = Mth.m_14116_((float)((float)target.m_203198_((double)x, (double)y, (double)z)));
        return Mth.m_14008_((double)(dist0 / 100.0f), (double)1.0, (double)3.5);
    }

    protected void spawnContrail() {
        this.spawnContraolWithOffset(0.0, 0.0, 0.0);
    }

    protected void spawnContraolWithOffset(double offsetX, double offsetY, double offsetZ) {
        Vec3 vec = this.m_20182_().m_82492_(this.f_19790_, this.f_19791_, this.f_19792_);
        double len = vec.m_82553_();
        vec = vec.m_82541_();
        Vec3 thrust = new Vec3(0.0, 1.0, 0.0);
        thrust.m_82496_((this.m_146909_() - 90.0f) * (float)Math.PI / 180.0f);
        thrust.m_82524_(this.m_146908_() * (float)Math.PI / 180.0f);
        int i = 0;
        while ((double)i < Math.max(Math.min(len, 10.0), 1.0)) {
            double j = (double)i - len;
            ParticleSystem.addRocketFlame(this.m_20182_().f_82479_ - vec.f_82479_ * j + offsetX, this.m_20182_().f_82480_ - vec.f_82480_ * j + offsetY, this.m_20182_().f_82481_ - vec.f_82481_ * j + offsetZ, -thrust.f_82479_, -thrust.f_82480_, -thrust.f_82481_, Float.valueOf(this.getContrailScale()), 60 + this.m_9236_().m_213780_().m_188503_(20));
            ++i;
        }
    }

    protected void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.decelY = nbt.m_128459_("decel");
        this.accelXZ = nbt.m_128459_("accel");
        this.target = new BlockPos(nbt.m_128451_("tX"), 0, nbt.m_128451_("tZ"));
        this.start = new BlockPos(nbt.m_128451_("sX"), 0, nbt.m_128451_("sZ"));
        this.velocity = nbt.m_128459_("veloc");
    }

    protected void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128347_("decel", this.decelY);
        nbt.m_128347_("accel", this.accelXZ);
        nbt.m_128405_("tX", this.target.m_123341_());
        nbt.m_128405_("tZ", this.target.m_123343_());
        nbt.m_128405_("sX", this.start.m_123341_());
        nbt.m_128405_("sZ", this.start.m_123343_());
        nbt.m_128347_("veloc", this.velocity);
    }

    protected float getContrailScale() {
        return 1.0f;
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_20147_()) {
            return false;
        }
        if (this.health > 0 && !this.m_9236_().f_46443_) {
            this.health -= (int)pAmount;
            if (this.health <= 0) {
                this.killMissile();
            }
        }
        return true;
    }

    protected void killMissile() {
        if (!this.m_6084_()) {
            this.setDead();
        }
    }

    public boolean m_6783_(double pDistance) {
        return true;
    }

    protected void m_6532_(HitResult pResult) {
        if (this.m_19749_() != null) {
            this.m_19749_().m_213846_((Component)Component.m_237110_((String)"msg.hbm.hit_on", (Object[])new Object[]{pResult.m_82450_().toString()}));
        }
        if (pResult.m_6662_() == HitResult.Type.BLOCK) {
            this.onMissileImpact(pResult);
            this.setDead();
        }
    }

    public abstract void onMissileImpact(HitResult var1);

    public abstract List<ItemStack> getDebris();

    public abstract ItemStack getDebrisRareDrop();

    public void cluster() {
    }

    protected float m_7139_() {
        return 0.0f;
    }

    @Override
    protected float getAirDrag() {
        return 1.0f;
    }

    @Override
    protected float getWaterDrag() {
        return 1.0f;
    }

    public void setDead() {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
        if (!this.m_9236_().m_5776_()) {
            ChunkLoadHelper.unRegister((Entity)this);
        }
    }

    public void onRemovedFromWorld() {
        if (!this.m_9236_().m_5776_()) {
            ChunkLoadHelper.unRegister((Entity)this);
        }
        super.onRemovedFromWorld();
    }

    private void setSize(double width, double height) {
        this.m_20011_(AABB.m_165882_((Vec3)new Vec3(0.5, 0.5, 0.5), (double)width, (double)height, (double)width));
    }

    protected void entityInit() {
        if (!this.m_9236_().m_5776_()) {
            ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.m_9236_()), (String)"hbm", (BlockPos)this.m_20183_(), (int)this.m_146902_().f_45578_, (int)this.m_146902_().f_45579_, (boolean)true, (boolean)true);
        }
    }

    public void explodeStandard(float strength, int resolution, boolean fire) {
        ExplosionVNT xnt = new ExplosionVNT(this.m_9236_(), this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, strength);
        xnt.setBlockAllocator(new BlockAllocatorStandard(resolution));
        xnt.setPlayerProcessor(new PlayerProcessorStandard());
        xnt.explode();
    }

    public void loadNeighboringChunks(int newChunkX, int newChunkZ) {
        if (!this.m_9236_().m_5776_()) {
            this.clearChunkLoader();
            this.loadedChunks.clear();
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ));
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.m_9236_()), (String)"hbm", (Entity)this, (int)chunk.f_45578_, (int)chunk.f_45579_, (boolean)true, (boolean)true);
            }
        }
    }

    public void clearChunkLoader() {
        if (!this.m_9236_().m_5776_()) {
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.m_9236_()), (String)"hbm", (Entity)this, (int)chunk.f_45578_, (int)chunk.f_45579_, (boolean)false, (boolean)false);
            }
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_MISSILE_1, (Object)Byte.valueOf("5"));
    }

    @Override
    public String getUnlocalizedName() {
        ItemStack item = this.getMissileItemForInfo();
        if (item != null && item.m_41720_() instanceof ItemMissilePart) {
            ItemMissilePart missile = (ItemMissilePart)item.m_41720_();
            switch (missile.tier) {
                case TIER0: {
                    return "radar.target.tier0";
                }
                case TIER1: {
                    return "radar.target.tier1";
                }
                case TIER2: {
                    return "radar.target.tier2";
                }
                case TIER3: {
                    return "radar.target.tier3";
                }
                case TIER4: {
                    return "radar.target.tier4";
                }
            }
            return "Unknown";
        }
        return "Unknown";
    }

    @Override
    public int getBlipLevel() {
        ItemStack item = this.getMissileItemForInfo();
        if (item != null && item.m_41720_() instanceof ItemMissilePart) {
            ItemMissilePart missile = (ItemMissilePart)item.m_41720_();
            switch (missile.tier) {
                case TIER0: {
                    return 0;
                }
                case TIER1: {
                    return 1;
                }
                case TIER2: {
                    return 2;
                }
                case TIER3: {
                    return 3;
                }
                case TIER4: {
                    return 4;
                }
            }
            return 13;
        }
        return 13;
    }

    @FunctionalInterface
    public static interface MissileCreator<T extends EntityMissile> {
        public T create(Level var1, float var2, float var3, float var4, BlockPos var5);
    }
}

