/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ExplosionNukeGeneric {
    public static void dealDamage(Level level, Vec3 pos, double radius) {
        ExplosionNukeGeneric.dealDamage(level, pos, radius, 250.0f);
    }

    public static void dealDamage(Level level, Vec3 pos, double radius, float maxDamage) {
        List entities = level.m_6249_((Entity)null, new AABB(pos, pos).m_82363_(radius, radius, radius), Entity::m_6084_);
        for (Entity entity : entities) {
            double dist = entity.m_20238_(pos);
            if (!(dist <= radius)) continue;
            Vec3 eyePosition = entity.m_146892_();
            if (ExplosionNukeGeneric.isExplosionExempt(entity) || !ExplosionNukeGeneric.isObstructed(level, pos, eyePosition)) continue;
            double damage = (double)maxDamage * (radius - dist) / radius;
            entity.m_6469_(level.m_269111_().m_269264_(), (float)damage);
            entity.m_20254_(5);
            Vec3 knock = eyePosition.m_82546_(pos).m_82541_().m_82490_(0.2);
            entity.m_246865_(knock);
        }
    }

    private static boolean isExplosionExempt(Entity entity) {
        return entity.m_6128_();
    }

    public static boolean isObstructed(Level level, Vec3 start, Vec3 end) {
        return level.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null)).m_6662_() == HitResult.Type.MISS;
    }
}

