/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.explosion.IExplosionRay;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class ExplosionNukeRayBatched
implements IExplosionRay {
    private final HashMap<ChunkPos, List<Vec3>> perChunk = new HashMap();
    private final List<ChunkPos> orderedChunks = new ArrayList<ChunkPos>();
    private final CoordComparator comparator = new CoordComparator();
    private final BlockPos pos;
    private final ChunkPos chunkPos;
    private final Level level;
    private final int strength;
    private final int radius;
    private final int speed;
    private final int gspNumMax;
    private int gspNum;
    private double theta;
    private double phi;
    private boolean isAusf3Complete = false;
    int collectTipCnt = 0;
    int processChunkCnt = 0;

    public ExplosionNukeRayBatched(Level level, BlockPos pos, int strength, int speed, int radius) {
        this.level = level;
        this.pos = pos;
        this.chunkPos = new ChunkPos(pos);
        this.strength = strength;
        this.radius = radius;
        this.speed = speed;
        this.gspNumMax = (int)(7.853981633974483 * Math.pow(this.strength, 2.0));
        this.gspNum = 1;
        this.theta = Math.PI;
        this.phi = 0.0;
    }

    public void collectTip(int count) {
        int amountProcessed = 0;
        while (this.gspNumMax >= this.gspNum) {
            Vec3 vec = ExplosionNukeRayBatched.spherical2cartesian(new Vec2((float)this.theta, (float)this.phi));
            int length = (int)Math.ceil(this.strength);
            float res = this.strength;
            Vec3 endPoint = null;
            HashSet<ChunkPos> chunkCoords = new HashSet<ChunkPos>();
            for (int i = 0; i < length && i < this.radius && res > 0.0f; ++i) {
                Vec3 dirVec = new Vec3((double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_()).m_82549_(vec.m_82490_((double)i));
                BlockPos dirPos = new BlockPos((int)Math.floor(dirVec.f_82479_), (int)Math.floor(dirVec.f_82480_), (int)Math.floor(dirVec.f_82481_));
                BlockState blockState = this.level.m_8055_(dirPos);
                double fac = 100.0 - (double)i / (double)length * 100.0;
                fac *= 0.07;
                if (blockState.m_247087_()) {
                    this.level.m_6933_(this.pos, Blocks.f_50016_.m_49966_(), 2, 0);
                }
                if (!blockState.m_278721_()) {
                    res -= (float)Math.pow(blockState.m_60734_().m_7325_(), 7.5 - fac);
                }
                if (!(res > 0.0f) || blockState.m_60795_()) continue;
                endPoint = dirVec;
                chunkCoords.add(new ChunkPos(dirPos));
            }
            for (ChunkPos pos : chunkCoords) {
                List endList = this.perChunk.computeIfAbsent(pos, k -> new ArrayList());
                endList.add(endPoint);
            }
            this.generateGspUp();
            if (++amountProcessed < count) continue;
            return;
        }
        this.orderedChunks.addAll(this.perChunk.keySet());
        this.orderedChunks.sort(this.comparator);
        this.isAusf3Complete = true;
    }

    public void processChunk() {
        if (this.perChunk.isEmpty()) {
            return;
        }
        ChunkPos coord = this.orderedChunks.get(0);
        List<Vec3> list = this.perChunk.get(coord);
        HashSet<BlockPos> toRem = new HashSet<BlockPos>();
        HashSet<BlockPos> toRemTips = new HashSet<BlockPos>();
        int enter = Math.min(Math.abs(this.pos.m_123341_() - (coord.f_45578_ << 4)), Math.abs(this.pos.m_123343_() - (coord.f_45579_ << 4))) - 16;
        enter = Math.max(enter, 0);
        block0: for (Vec3 triplet : list) {
            Vec3 vec = triplet.m_82546_(this.pos.m_252807_());
            double vecLen = vec.m_82553_();
            vec = vec.m_82541_();
            BlockPos tip = new BlockPos((int)Math.floor(triplet.f_82479_), (int)Math.floor(triplet.f_82480_), (int)Math.floor(triplet.f_82481_));
            boolean inChunk = false;
            int i = enter;
            while ((double)i < vecLen) {
                BlockPos pos1 = new BlockPos((int)Math.floor((double)this.pos.m_123341_() + vec.f_82479_ * (double)i), (int)Math.floor((double)this.pos.m_123342_() + vec.f_82480_ * (double)i), (int)Math.floor((double)this.pos.m_123343_() + vec.f_82481_ * (double)i));
                if (pos1.m_123341_() >> 4 != coord.f_45578_ || pos1.m_123343_() >> 4 != coord.f_45579_) {
                    if (inChunk) {
                        continue block0;
                    }
                } else {
                    inChunk = true;
                    if (!this.level.m_8055_(pos1).m_60795_()) {
                        if (pos1.equals((Object)tip)) {
                            toRemTips.add(pos1);
                        }
                        toRem.add(pos1);
                    }
                }
                ++i;
            }
        }
        for (BlockPos pos : toRem) {
            if (toRemTips.contains(pos)) {
                this.handleTip(pos);
                continue;
            }
            this.level.m_6933_(pos, Blocks.f_50016_.m_49966_(), 2, 0);
        }
        this.perChunk.remove(coord);
        this.orderedChunks.remove(0);
    }

    protected void handleTip(BlockPos blockPos) {
        this.level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
    }

    private static Vec3 spherical2cartesian(Vec2 sPos) {
        return new Vec3(Math.sin(sPos.f_82470_) * Math.cos(sPos.f_82471_), Math.cos(sPos.f_82470_), Math.sin(sPos.f_82470_) * Math.sin(sPos.f_82471_));
    }

    private void generateGspUp() {
        if (this.gspNum < this.gspNumMax) {
            int k = this.gspNum + 1;
            double hk = -1.0 + 2.0 * ((double)k - 1.0) / ((double)this.gspNumMax - 1.0);
            this.theta = Math.acos(hk);
            double prev_lon = this.phi;
            double lon = prev_lon + 3.6 / Math.sqrt(this.gspNumMax) / Math.sqrt(1.0 - hk * hk);
            this.phi = lon % (Math.PI * 2);
        } else {
            this.theta = 0.0;
            this.phi = 0.0;
        }
        ++this.gspNum;
    }

    @Override
    public void cacheChunksTick(int processTimeMs) {
        if (!this.isAusf3Complete) {
            this.collectTip(this.speed * 10);
        }
    }

    @Override
    public void destructionTick(int processTimeMs) {
        if (!this.isAusf3Complete) {
            return;
        }
        long start = System.currentTimeMillis();
        while (!this.perChunk.isEmpty() && System.currentTimeMillis() < start + (long)processTimeMs) {
            this.processChunk();
        }
    }

    @Override
    public void cancel() {
        this.isAusf3Complete = true;
        this.perChunk.clear();
        this.orderedChunks.clear();
    }

    @Override
    public boolean isComplete() {
        return this.isAusf3Complete && this.perChunk.isEmpty();
    }

    @Deprecated
    private static BlockPos OutsideRound(BlockPos pos, Vec3 vec, int i) {
        double x0 = vec.f_82479_ < 0.0 ? Math.ceil((double)pos.m_123341_() + vec.f_82479_ * (double)i) : Math.floor((double)pos.m_123341_() + vec.f_82479_ * (double)i);
        double y0 = vec.f_82480_ < 0.0 ? Math.ceil((double)pos.m_123342_() + vec.f_82480_ * (double)i) : Math.floor((double)pos.m_123342_() + vec.f_82480_ * (double)i);
        double z0 = vec.f_82481_ < 0.0 ? Math.ceil((double)pos.m_123343_() + vec.f_82481_ * (double)i) : Math.floor((double)pos.m_123343_() + vec.f_82481_ * (double)i);
        return new BlockPos((int)x0, (int)y0, (int)z0);
    }

    public class CoordComparator
    implements Comparator<ChunkPos> {
        @Override
        public int compare(ChunkPos o1, ChunkPos o2) {
            int diff1 = Math.abs(ExplosionNukeRayBatched.this.chunkPos.f_45578_ - o1.f_45578_) + Math.abs(ExplosionNukeRayBatched.this.chunkPos.f_45579_ - o1.f_45579_);
            int diff2 = Math.abs(ExplosionNukeRayBatched.this.chunkPos.f_45578_ - o2.f_45578_) + Math.abs(ExplosionNukeRayBatched.this.chunkPos.f_45579_ - o2.f_45579_);
            return diff1 - diff2;
        }
    }
}

