/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.HBM;
import com.hbm.config.ConfigBomb;
import com.hbm.explosion.IExplosionRay;
import com.hbm.utils.ConcurrentBitSet;
import com.hbm.utils.SubChunkKey;
import com.hbm.utils.SubChunkSnapshot;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.DoubleAdder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.Vec3;

public class ExplosionNukeRayParallelized
implements IExplosionRay {
    private static final float NUKE_RESISTANCE_CUTOFF = 2000000.0f;
    private static final float INITIAL_ENERGY_FACTOR = 0.3f;
    private static final double RESOLUTION_FACTOR = 1.0;
    private final int minY;
    private final int worldHeight;
    private final int bitsetSize;
    private final int sectionsCount;
    private final ServerLevel level;
    private final int originX;
    private final int originY;
    private final int originZ;
    private final int strength;
    private final int radius;
    private final CompletableFuture<List<Vec3>> directionsFuture;
    private final ConcurrentMap<ChunkPos, ConcurrentBitSet> destructionMap;
    private final ConcurrentMap<ChunkPos, ConcurrentMap<Integer, DoubleAdder>> damageMap;
    private final ConcurrentMap<SubChunkKey, SubChunkSnapshot> snapshots;
    private final ConcurrentMap<SubChunkKey, ConcurrentLinkedQueue<RayTask>> waitingRoom;
    private final BlockingQueue<RayTask> rayQueue;
    private final ExecutorService pool;
    private final CountDownLatch latch;
    private final Thread latchWatcherThread;
    private final List<ChunkPos> orderedChunks;
    private final BlockingQueue<SubChunkKey> highPriorityReactiveQueue;
    private final Iterator<SubChunkKey> lowPriorityProactiveIterator;
    private volatile List<Vec3> directions;
    private volatile boolean collectFinished = false;
    private volatile boolean consolidationFinished = false;
    private volatile boolean destroyFinished = false;

    public ExplosionNukeRayParallelized(ServerLevel level, BlockPos origin, int strength, int radius) {
        this.level = level;
        this.originX = origin.m_123341_();
        this.originY = origin.m_123342_();
        this.originZ = origin.m_123343_();
        this.strength = strength;
        this.radius = radius;
        this.minY = level.m_141937_();
        this.worldHeight = level.m_141928_();
        this.bitsetSize = 16 * this.worldHeight * 16;
        this.sectionsCount = level.m_151559_();
        int rayCount = Math.max(0, (int)(7.853981633974483 * (double)strength * (double)strength * 1.0));
        this.latch = new CountDownLatch(rayCount);
        List<SubChunkKey> sortedSubChunks = this.getAllSubChunks();
        this.lowPriorityProactiveIterator = sortedSubChunks.iterator();
        this.highPriorityReactiveQueue = new LinkedBlockingQueue<SubChunkKey>();
        int initialChunkCapacity = (int)sortedSubChunks.stream().map(SubChunkKey::getPos).distinct().count();
        this.destructionMap = new ConcurrentHashMap<ChunkPos, ConcurrentBitSet>(initialChunkCapacity);
        this.damageMap = new ConcurrentHashMap<ChunkPos, ConcurrentMap<Integer, DoubleAdder>>(initialChunkCapacity);
        int subChunkCount = sortedSubChunks.size();
        this.snapshots = new ConcurrentHashMap<SubChunkKey, SubChunkSnapshot>(subChunkCount);
        this.waitingRoom = new ConcurrentHashMap<SubChunkKey, ConcurrentLinkedQueue<RayTask>>(subChunkCount);
        this.orderedChunks = new ArrayList<ChunkPos>();
        ArrayList<RayTask> initialRayTasks = new ArrayList<RayTask>(rayCount);
        for (int i = 0; i < rayCount; ++i) {
            initialRayTasks.add(new RayTask(i));
        }
        this.rayQueue = new LinkedBlockingQueue<RayTask>(initialRayTasks);
        int workers = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
        this.pool = Executors.newWorkStealingPool(workers);
        this.directionsFuture = CompletableFuture.supplyAsync(() -> this.generateSphereRays(rayCount));
        for (int i = 0; i < workers; ++i) {
            this.pool.submit(new Worker());
        }
        this.latchWatcherThread = new Thread(() -> {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.collectFinished = true;
                if (ConfigBomb.explosionAlgorithm == 2) {
                    this.pool.submit(this::runConsolidation);
                } else {
                    this.consolidationFinished = true;
                }
            }
        }, "ExplosionNuke-LatchWatcher-" + System.nanoTime());
        this.latchWatcherThread.setDaemon(true);
        this.latchWatcherThread.start();
    }

    private static float getNukeResistance(Block b) {
        if (b.m_49966_().m_278721_()) {
            return 0.1f;
        }
        if (b == Blocks.f_50062_) {
            return Blocks.f_50069_.m_7325_();
        }
        if (b == Blocks.f_50080_) {
            return Blocks.f_50069_.m_7325_() * 3.0f;
        }
        return b.m_7325_();
    }

    private List<SubChunkKey> getAllSubChunks() {
        ArrayList<SubChunkKey> keys = new ArrayList<SubChunkKey>();
        int cr = this.radius + 15 >> 4;
        int originCX = SectionPos.m_123171_((int)this.originX);
        int originCZ = SectionPos.m_123171_((int)this.originZ);
        int minCX = originCX - cr;
        int maxCX = originCX + cr;
        int minCZ = originCZ - cr;
        int maxCZ = originCZ + cr;
        int minExplosionY = Math.max(this.minY, this.originY - this.radius);
        int maxExplosionY = Math.min(this.minY + this.worldHeight - 1, this.originY + this.radius);
        int minSectionY = this.level.m_151564_(minExplosionY);
        int maxSectionY = this.level.m_151564_(maxExplosionY);
        int originSectionY = this.level.m_151564_(this.originY);
        for (int cx = minCX; cx <= maxCX; ++cx) {
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                for (int sectionY = minSectionY; sectionY <= maxSectionY; ++sectionY) {
                    int chunkCenterZ;
                    double dz;
                    int chunkCenterX = (cx << 4) + 8;
                    double dx = chunkCenterX - this.originX;
                    int sectionYBlock = this.level.m_151568_(sectionY) * 16;
                    int chunkCenterY = sectionYBlock + 8;
                    double dy = chunkCenterY - this.originY;
                    if (!(dx * dx + dy * dy + (dz = (double)((chunkCenterZ = (cz << 4) + 8) - this.originZ)) * dz <= (double)((this.radius + 14) * (this.radius + 14)))) continue;
                    keys.add(new SubChunkKey(cx, cz, sectionY));
                }
            }
        }
        keys.sort(Comparator.comparingInt(key -> {
            int distCX = key.getChunkX() - originCX;
            int distCZ = key.getChunkZ() - originCZ;
            int distSubY = key.getSectionY() - originSectionY;
            return distCX * distCX + distCZ * distCZ + distSubY * distSubY;
        }));
        return keys;
    }

    @Override
    public void cacheChunksTick(int timeBudgetMs) {
        SubChunkKey ck;
        if (this.collectFinished) {
            return;
        }
        long deadline = System.nanoTime() + (long)timeBudgetMs * 1000000L;
        while (System.nanoTime() < deadline && (ck = (SubChunkKey)this.highPriorityReactiveQueue.poll()) != null) {
            this.processCacheKey(ck);
        }
        while (System.nanoTime() < deadline && this.lowPriorityProactiveIterator.hasNext()) {
            ck = this.lowPriorityProactiveIterator.next();
            this.processCacheKey(ck);
        }
    }

    private void processCacheKey(SubChunkKey ck) {
        if (this.snapshots.containsKey(ck)) {
            return;
        }
        this.snapshots.put(ck, SubChunkSnapshot.getSnapshot(this.level, ck, ConfigBomb.chunkloading));
        ConcurrentLinkedQueue waiters = (ConcurrentLinkedQueue)this.waitingRoom.remove(ck);
        if (waiters != null) {
            this.rayQueue.addAll(waiters);
        }
    }

    @Override
    public void destructionTick(int timeBudgetMs) {
        if (!this.collectFinished || !this.consolidationFinished || this.destroyFinished) {
            return;
        }
        long deadline = System.nanoTime() + (long)timeBudgetMs * 1000000L;
        if (this.orderedChunks.isEmpty() && !this.destructionMap.isEmpty()) {
            this.orderedChunks.addAll(this.destructionMap.keySet());
            int originCX = SectionPos.m_123171_((int)this.originX);
            int originCZ = SectionPos.m_123171_((int)this.originZ);
            this.orderedChunks.sort(Comparator.comparingInt(c -> Math.abs(originCX - c.f_45578_) + Math.abs(originCZ - c.f_45579_)));
        }
        Iterator<ChunkPos> it = this.orderedChunks.iterator();
        while (it.hasNext() && System.nanoTime() < deadline) {
            ChunkPos cp = it.next();
            ConcurrentBitSet bs = (ConcurrentBitSet)this.destructionMap.get(cp);
            if (bs == null) {
                it.remove();
                continue;
            }
            LevelChunk chunk = this.level.m_6325_(cp.f_45578_, cp.f_45579_);
            LevelChunkSection[] sections = chunk.m_7103_();
            boolean chunkModified = false;
            int bitIndex = bs.nextSetBit(0);
            while (bitIndex >= 0 && System.nanoTime() < deadline) {
                LevelChunkSection section;
                int xLocal = bitIndex & 0xF;
                int zLocal = bitIndex >> 4 & 0xF;
                int yNorm = bitIndex >> 8;
                int yGlobal = yNorm + this.minY;
                int sectionY = this.level.m_151564_(yGlobal);
                if (sectionY >= 0 && sectionY < sections.length && (section = sections[sectionY]) != null) {
                    int yLocal = SectionPos.m_123207_((int)yGlobal);
                    if (!section.m_62982_(xLocal, yLocal, zLocal).m_60795_()) {
                        BlockPos pos = new BlockPos(cp.f_45578_ << 4 | xLocal, yGlobal, cp.f_45579_ << 4 | zLocal);
                        if (this.level.m_7702_(pos) != null) {
                            this.level.m_46747_(pos);
                        }
                        section.m_62991_(xLocal, yLocal, zLocal, Blocks.f_50016_.m_49966_(), false);
                        chunkModified = true;
                        this.level.m_7726_().m_8450_(pos);
                        this.level.m_5518_().m_7174_(pos);
                    }
                    bs.clear(bitIndex);
                }
                bitIndex = bs.nextSetBit(bitIndex + 1);
            }
            if (chunkModified) {
                chunk.m_8092_(true);
            }
            if (!bs.isEmpty()) continue;
            this.destructionMap.remove(cp);
            for (int sectionY = 0; sectionY < this.sectionsCount; ++sectionY) {
                this.snapshots.remove(new SubChunkKey(cp, sectionY));
            }
            it.remove();
        }
        if (this.orderedChunks.isEmpty() && this.destructionMap.isEmpty()) {
            this.destroyFinished = true;
            if (this.pool != null) {
                this.pool.shutdown();
            }
        }
    }

    @Override
    public boolean isComplete() {
        return this.collectFinished && this.consolidationFinished && this.destroyFinished;
    }

    @Override
    public void cancel() {
        block13: {
            this.collectFinished = true;
            this.consolidationFinished = true;
            this.destroyFinished = true;
            if (this.rayQueue != null) {
                this.rayQueue.clear();
            }
            if (this.waitingRoom != null) {
                this.waitingRoom.clear();
            }
            if (this.latch != null) {
                while (this.latch.getCount() > 0L) {
                    this.latch.countDown();
                }
            }
            if (this.latchWatcherThread != null && this.latchWatcherThread.isAlive()) {
                this.latchWatcherThread.interrupt();
            }
            if (this.pool != null && !this.pool.isShutdown()) {
                this.pool.shutdownNow();
                try {
                    if (!this.pool.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                        HBM.LOGGER.error("ExplosionNukeRayParallelized thread pool did not terminate promptly on cancel.");
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    if (this.pool.isShutdown()) break block13;
                    this.pool.shutdownNow();
                }
            }
        }
        if (this.destructionMap != null) {
            this.destructionMap.clear();
        }
        if (this.damageMap != null) {
            this.damageMap.clear();
        }
        if (this.snapshots != null) {
            this.snapshots.clear();
        }
        if (this.orderedChunks != null) {
            this.orderedChunks.clear();
        }
    }

    private List<Vec3> generateSphereRays(int count) {
        ArrayList<Vec3> list = new ArrayList<Vec3>(count);
        if (count == 0) {
            return list;
        }
        if (count == 1) {
            list.add(new Vec3(1.0, 0.0, 0.0));
            return list;
        }
        double phi = Math.PI * (3.0 - Math.sqrt(5.0));
        for (int i = 0; i < count; ++i) {
            double y = 1.0 - (double)i / (double)(count - 1) * 2.0;
            double r = Math.sqrt(1.0 - y * y);
            double t = phi * (double)i;
            list.add(new Vec3(Math.cos(t) * r, y, Math.sin(t) * r).m_82541_());
        }
        return list;
    }

    private void runConsolidation() {
        this.damageMap.forEach((cp, innerDamageMap) -> {
            if (innerDamageMap.isEmpty()) {
                this.damageMap.remove(cp);
                return;
            }
            ConcurrentBitSet chunkDestructionBitSet = this.destructionMap.computeIfAbsent((ChunkPos)cp, k -> new ConcurrentBitSet(this.bitsetSize));
            innerDamageMap.forEach((bitIndex, accumulatedDamageAdder) -> {
                float accumulatedDamage = (float)accumulatedDamageAdder.sum();
                if (accumulatedDamage <= 0.0f) {
                    innerDamageMap.remove(bitIndex);
                    return;
                }
                int yNorm = bitIndex >> 8;
                int yGlobal = yNorm + this.minY;
                int sectionY = this.level.m_151564_(yGlobal);
                if (sectionY < 0 || sectionY >= this.sectionsCount) {
                    innerDamageMap.remove(bitIndex);
                    return;
                }
                SubChunkKey snapshotKey = new SubChunkKey((ChunkPos)cp, sectionY);
                SubChunkSnapshot snap = (SubChunkSnapshot)this.snapshots.get(snapshotKey);
                if (snap == null || snap == SubChunkSnapshot.EMPTY) {
                    innerDamageMap.remove(bitIndex);
                    return;
                }
                int xLocal = bitIndex & 0xF;
                int zLocal = bitIndex >> 4 & 0xF;
                Block originalBlock = snap.getBlock(xLocal, SectionPos.m_123207_((int)yGlobal), zLocal);
                if (originalBlock == Blocks.f_50016_) {
                    innerDamageMap.remove(bitIndex);
                    return;
                }
                float resistance = ExplosionNukeRayParallelized.getNukeResistance(originalBlock);
                if ((double)accumulatedDamage >= (double)resistance * 1.0) {
                    chunkDestructionBitSet.set((int)bitIndex);
                }
                innerDamageMap.remove(bitIndex);
            });
            if (innerDamageMap.isEmpty()) {
                this.damageMap.remove(cp);
            }
        });
        this.damageMap.clear();
        this.consolidationFinished = true;
    }

    private class RayTask {
        private static final double RAY_DIRECTION_EPSILON = 1.0E-6;
        private static final double PROCESSING_EPSILON = 1.0E-9;
        private static final float MIN_EFFECTIVE_DIST_FOR_ENERGY_CALC = 0.01f;
        final int dirIndex;
        int x;
        int y;
        int z;
        float energy;
        double tMaxX;
        double tMaxY;
        double tMaxZ;
        double tDeltaX;
        double tDeltaY;
        double tDeltaZ;
        int stepX;
        int stepY;
        int stepZ;
        boolean initialised = false;
        double currentRayPosition;
        private int lastCX = Integer.MIN_VALUE;
        private int lastCZ = Integer.MIN_VALUE;
        private int lastSectionY = Integer.MIN_VALUE;
        private SubChunkKey currentSubChunkKey = null;

        RayTask(int dirIdx) {
            this.dirIndex = dirIdx;
        }

        void init() {
            if (ExplosionNukeRayParallelized.this.directions == null) {
                ExplosionNukeRayParallelized.this.directions = ExplosionNukeRayParallelized.this.directionsFuture.join();
            }
            Vec3 dir = ExplosionNukeRayParallelized.this.directions.get(this.dirIndex);
            this.energy = (float)ExplosionNukeRayParallelized.this.strength * 0.3f;
            this.x = ExplosionNukeRayParallelized.this.originX;
            this.y = ExplosionNukeRayParallelized.this.originY;
            this.z = ExplosionNukeRayParallelized.this.originZ;
            this.currentRayPosition = 0.0;
            double dirX = dir.m_7096_();
            double dirY = dir.m_7098_();
            double dirZ = dir.m_7094_();
            this.stepX = Math.abs(dirX) < 1.0E-6 ? 0 : (dirX > 0.0 ? 1 : -1);
            double d = this.tDeltaX = this.stepX == 0 ? Double.POSITIVE_INFINITY : 1.0 / Math.abs(dirX);
            double d2 = this.stepX == 0 ? Double.POSITIVE_INFINITY : (this.tMaxX = this.tDeltaX * (double)(this.stepX > 0 ? 1 : 0));
            this.stepY = Math.abs(dirY) < 1.0E-6 ? 0 : (dirY > 0.0 ? 1 : -1);
            double d3 = this.tDeltaY = this.stepY == 0 ? Double.POSITIVE_INFINITY : 1.0 / Math.abs(dirY);
            double d4 = this.stepY == 0 ? Double.POSITIVE_INFINITY : (this.tMaxY = this.tDeltaY * (double)(this.stepY > 0 ? 1 : 0));
            this.stepZ = Math.abs(dirZ) < 1.0E-6 ? 0 : (dirZ > 0.0 ? 1 : -1);
            double d5 = this.tDeltaZ = this.stepZ == 0 ? Double.POSITIVE_INFINITY : 1.0 / Math.abs(dirZ);
            this.tMaxZ = this.stepZ == 0 ? Double.POSITIVE_INFINITY : this.tDeltaZ * (double)(this.stepZ > 0 ? 1 : 0);
            this.initialised = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void trace() {
            boolean isPaused = false;
            try {
                if (!this.initialised) {
                    this.init();
                }
                if (this.energy <= 0.0f) {
                    return;
                }
                while (this.energy > 0.0f && this.y >= ExplosionNukeRayParallelized.this.minY && this.y < ExplosionNukeRayParallelized.this.minY + ExplosionNukeRayParallelized.this.worldHeight) {
                    Block block;
                    double segmentLenForProcessing;
                    SubChunkSnapshot snap;
                    if (Thread.currentThread().isInterrupted()) {
                        break;
                    }
                    if (this.currentRayPosition >= (double)ExplosionNukeRayParallelized.this.radius - 1.0E-9) {
                        break;
                    }
                    int cx = SectionPos.m_123171_((int)this.x);
                    int cz = SectionPos.m_123171_((int)this.z);
                    int sectionY = ExplosionNukeRayParallelized.this.level.m_151564_(this.y);
                    if (cx != this.lastCX || cz != this.lastCZ || sectionY != this.lastSectionY) {
                        this.currentSubChunkKey = new SubChunkKey(cx, cz, sectionY);
                        this.lastCX = cx;
                        this.lastCZ = cz;
                        this.lastSectionY = sectionY;
                    }
                    if ((snap = (SubChunkSnapshot)ExplosionNukeRayParallelized.this.snapshots.get(this.currentSubChunkKey)) == null) {
                        isPaused = true;
                        boolean[] amFirst = new boolean[]{false};
                        ConcurrentLinkedQueue waiters = ExplosionNukeRayParallelized.this.waitingRoom.computeIfAbsent(this.currentSubChunkKey, k -> {
                            amFirst[0] = true;
                            return new ConcurrentLinkedQueue();
                        });
                        if (amFirst[0]) {
                            ExplosionNukeRayParallelized.this.highPriorityReactiveQueue.add(this.currentSubChunkKey);
                        }
                        waiters.add(this);
                        return;
                    }
                    double t_exit_voxel = Math.min(this.tMaxX, Math.min(this.tMaxY, this.tMaxZ));
                    double segmentLenInVoxel = t_exit_voxel - this.currentRayPosition;
                    boolean stopAfterThisSegment = false;
                    if (this.currentRayPosition + segmentLenInVoxel > (double)ExplosionNukeRayParallelized.this.radius - 1.0E-9) {
                        segmentLenForProcessing = Math.max(0.0, (double)ExplosionNukeRayParallelized.this.radius - this.currentRayPosition);
                        stopAfterThisSegment = true;
                    } else {
                        segmentLenForProcessing = segmentLenInVoxel;
                    }
                    if (snap != SubChunkSnapshot.EMPTY && segmentLenForProcessing > 1.0E-9 && (block = snap.getBlock(SectionPos.m_123207_((int)this.x), SectionPos.m_123207_((int)this.y), SectionPos.m_123207_((int)this.z))) != Blocks.f_50016_) {
                        float resistance = ExplosionNukeRayParallelized.getNukeResistance(block);
                        if (resistance >= 2000000.0f) {
                            this.energy = 0.0f;
                        } else {
                            double energyLossFactor = this.getEnergyLossFactor(resistance);
                            float damageDealt = (float)(energyLossFactor * segmentLenForProcessing);
                            this.energy -= damageDealt;
                            if (damageDealt > 0.0f) {
                                int yNorm = this.y - ExplosionNukeRayParallelized.this.minY;
                                int xLocal = SectionPos.m_123207_((int)this.x);
                                int zLocal = SectionPos.m_123207_((int)this.z);
                                int bitIndex = yNorm << 8 | zLocal << 4 | xLocal;
                                ChunkPos chunkPos = this.currentSubChunkKey.getPos();
                                if (ConfigBomb.explosionAlgorithm == 2) {
                                    ExplosionNukeRayParallelized.this.damageMap.computeIfAbsent(chunkPos, cp -> new ConcurrentHashMap(256)).computeIfAbsent(bitIndex, k -> new DoubleAdder()).add(damageDealt);
                                } else if (this.energy > 0.0f) {
                                    ExplosionNukeRayParallelized.this.destructionMap.computeIfAbsent(chunkPos, posKey -> new ConcurrentBitSet(ExplosionNukeRayParallelized.this.bitsetSize)).set(bitIndex);
                                }
                            }
                        }
                    }
                    this.currentRayPosition = t_exit_voxel;
                    if (this.energy <= 0.0f) break;
                    if (stopAfterThisSegment) {
                        break;
                    }
                    if (this.tMaxX < this.tMaxY) {
                        if (this.tMaxX < this.tMaxZ) {
                            this.x += this.stepX;
                            this.tMaxX += this.tDeltaX;
                            continue;
                        }
                        this.z += this.stepZ;
                        this.tMaxZ += this.tDeltaZ;
                        continue;
                    }
                    if (this.tMaxY < this.tMaxZ) {
                        this.y += this.stepY;
                        this.tMaxY += this.tDeltaY;
                        continue;
                    }
                    this.z += this.stepZ;
                    this.tMaxZ += this.tDeltaZ;
                }
            }
            catch (Exception e) {
                HBM.LOGGER.error("Ray {} at distance {} finished exceptionally due to: ", new Object[]{this.dirIndex, this.currentRayPosition, e});
            }
            finally {
                if (!isPaused) {
                    ExplosionNukeRayParallelized.this.latch.countDown();
                }
            }
        }

        private double getEnergyLossFactor(float resistance) {
            double effectiveDist = Math.max(this.currentRayPosition, (double)0.01f);
            return Math.pow((double)resistance + 1.0, 3.0 * (effectiveDist / (double)ExplosionNukeRayParallelized.this.radius)) - 1.0;
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        @Override
        public void run() {
            try {
                while (!ExplosionNukeRayParallelized.this.collectFinished && !Thread.currentThread().isInterrupted()) {
                    RayTask task = ExplosionNukeRayParallelized.this.rayQueue.poll(100L, TimeUnit.MILLISECONDS);
                    if (task == null) continue;
                    task.trace();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

