/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.particle.ModParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class ExplosionUtils {
    public static void explode(Level pLevel, double x, double y, double z, float radius, boolean cloud, boolean rubble, boolean shrapnel) {
        pLevel.m_255391_(null, x, y, z, radius, true, Level.ExplosionInteraction.TNT);
        if (cloud) {
            ExplosionUtils.spawnParticles(pLevel, x, y, z, ExplosionUtils.cloudFunction((int)radius));
        }
    }

    public static void spawnParticles(Level pLevel, double x, double y, double z, int count) {
        for (ServerPlayer serverPlayer : ((ServerLevel)pLevel).m_6907_()) {
            if (!(serverPlayer.m_20275_(x, y, z) < 4096.0)) continue;
            for (int i = 0; i < count; ++i) {
                double xRand = pLevel.f_46441_.m_188583_();
                double zRand = pLevel.f_46441_.m_188583_();
                pLevel.m_7106_((ParticleOptions)ModParticleTypes.HBM_SMOKE.get(), x, y, z, 1.0E-4 * xRand, 5.0E-4, 1.0E-4 * zRand);
            }
        }
    }

    public static int cloudFunction(int i) {
        return (int)(850.0 * (1.0 - Math.pow(Math.E, -i / 15)) + 15.0);
    }

    public static int rubbleFunction(int i) {
        return i / 10;
    }

    public static int shrapnelFunction(int i) {
        return i / 3;
    }
}

