/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion.vanillant.standard;

import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.interfaces.IBlockMutator;
import com.hbm.explosion.vanillant.interfaces.IBlockProcessor;
import com.hbm.explosion.vanillant.interfaces.IDropChanceMutator;
import com.hbm.explosion.vanillant.interfaces.IFortuneMutator;
import com.hbm.explosion.vanillant.standard.DropChanceMutatorStandard;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockProcessorStandard
implements IBlockProcessor {
    protected IDropChanceMutator chance;
    protected IFortuneMutator fortune;
    protected IBlockMutator convert;

    public BlockProcessorStandard withChance(IDropChanceMutator chance) {
        this.chance = chance;
        return this;
    }

    public BlockProcessorStandard withFortune(IFortuneMutator fortune) {
        this.fortune = fortune;
        return this;
    }

    public BlockProcessorStandard withBlockEffect(IBlockMutator convert) {
        this.convert = convert;
        return this;
    }

    @Override
    public void process(ExplosionVNT explosion, Level world, double x, double y, double z, HashSet<BlockPos> affectedBlocks) {
        BlockState blockState;
        Iterator<BlockPos> iterator = affectedBlocks.iterator();
        float dropChance = 1.0f / explosion.size;
        while (iterator.hasNext()) {
            BlockPos blockPos = iterator.next();
            blockState = world.m_8055_(blockPos);
            if (!blockState.m_60795_()) {
                if (blockState.canDropFromExplosion((BlockGetter)world, blockPos, explosion.innerInstance)) {
                    if (this.chance != null) {
                        dropChance = this.chance.mutateDropChance(explosion, blockState.m_60734_(), blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), dropChance);
                    }
                    int n = this.fortune == null ? 0 : this.fortune.mutateFortune(explosion, blockState.m_60734_(), blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
                }
                blockState.onBlockExploded(world, blockPos, explosion.innerInstance);
                if (this.convert == null) continue;
                this.convert.mutatePre(explosion, blockState.m_60734_(), 0, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
                continue;
            }
            iterator.remove();
        }
        if (this.convert != null) {
            for (BlockPos blockPos : affectedBlocks) {
                blockState = world.m_8055_(blockPos);
                if (blockState.m_60795_()) continue;
                this.convert.mutatePost(explosion, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
            }
        }
    }

    public BlockProcessorStandard setNoDrop() {
        this.chance = new DropChanceMutatorStandard(0.0f);
        return this;
    }

    public BlockProcessorStandard setAllDrop() {
        this.chance = new DropChanceMutatorStandard(1.0f);
        return this;
    }

    public BlockProcessorStandard setFortune(final int fortune) {
        this.fortune = new IFortuneMutator(){

            @Override
            public int mutateFortune(ExplosionVNT explosion, Block block, int x, int y, int z) {
                return fortune;
            }
        };
        return this;
    }
}

