/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.gui.menu;

import com.hbm.blockentity.machine.GasTurbineBlockEntity;
import com.hbm.gui.ModMenuType;
import com.hbm.gui.menu.BaseMachineMenu;
import com.hbm.gui.menu.ITileAccess;
import com.hbm.gui.menu.slot.BatterySlot;
import com.hbm.registries.ModTags;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class GasTurbineMenu
extends BaseMachineMenu
implements ITileAccess {
    public static final int SLOT_OUTPUT = 0;
    public static final int SLOT_CONFIG = 1;
    public static final int DATA_SIZE = 13;
    private static final int PLAYER_INV_Y_OFFSET = 57;
    private static final int SLIDER_BUTTON_BASE = 2000;
    @Nullable
    private GasTurbineBlockEntity blockEntity;

    public GasTurbineMenu(int containerId, Inventory inventory) {
        this(containerId, inventory, (Container)new SimpleContainer(2), (ContainerData)new SimpleContainerData(13));
    }

    public GasTurbineMenu(int containerId, Inventory inventory, Container container, ContainerData data) {
        super((MenuType)ModMenuType.GAS_TURBINE_MENU.get(), containerId, container, data);
        if (container instanceof GasTurbineBlockEntity) {
            GasTurbineBlockEntity turbine;
            this.blockEntity = turbine = (GasTurbineBlockEntity)container;
        }
        this.slotNum = 2;
        this.m_38897_(new BatterySlot(container, 0, 8, 109));
        this.m_38897_(new Slot(container, 1, 36, 17));
        this.addPlayerSlot(inventory, 0, 57);
        this.m_38884_(data);
    }

    @Override
    public boolean innerMovePlayer2Container(int index, ItemStack stack) {
        if (stack.m_204117_(ModTags.Items.CHARGEABLE)) {
            return this.m_38903_(stack, 0, 1, false);
        }
        return this.m_38903_(stack, 1, 2, false);
    }

    @Override
    public void setTile(BlockEntity blockEntity) {
        if (blockEntity instanceof GasTurbineBlockEntity) {
            GasTurbineBlockEntity turbine;
            this.blockEntity = turbine = (GasTurbineBlockEntity)blockEntity;
        }
    }

    @Nullable
    public GasTurbineBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public long getEnergy() {
        long lo = Integer.toUnsignedLong(this.containerData.m_6413_(0));
        long hi = Integer.toUnsignedLong(this.containerData.m_6413_(1));
        return hi << 32 | lo;
    }

    public int getRpm() {
        return this.containerData.m_6413_(2);
    }

    public int getTemperature() {
        return this.containerData.m_6413_(3);
    }

    public int getState() {
        return this.containerData.m_6413_(4);
    }

    public boolean isAutoMode() {
        return this.containerData.m_6413_(5) > 0;
    }

    public int getSliderPosition() {
        return this.containerData.m_6413_(6);
    }

    public int getThrottle() {
        return this.containerData.m_6413_(7);
    }

    public int getSteamAmount() {
        return this.containerData.m_6413_(8);
    }

    public int getWaterAmount() {
        return this.containerData.m_6413_(9);
    }

    public int getFuelAmount() {
        return this.containerData.m_6413_(10);
    }

    public int getLubricantAmount() {
        return this.containerData.m_6413_(11);
    }

    public int getInstantPowerOutput() {
        return this.containerData.m_6413_(12);
    }

    public boolean isRunning() {
        return this.getState() == 1;
    }

    public static int getFuelCapacity() {
        return 100000;
    }

    public static int getLubricantCapacity() {
        return 16000;
    }

    public static int getWaterCapacity() {
        return 16000;
    }

    public static int getSteamCapacity() {
        return 160000;
    }

    public boolean m_6366_(Player player, int id) {
        Container container = this.container;
        if (container instanceof GasTurbineBlockEntity) {
            GasTurbineBlockEntity turbine = (GasTurbineBlockEntity)container;
            if (id == 0) {
                if (turbine.getState() == 0) {
                    turbine.requestStart();
                } else {
                    turbine.requestStop();
                }
                return true;
            }
            if (id == 1) {
                if (turbine.getState() == 1) {
                    turbine.toggleAutoMode();
                    return true;
                }
                return false;
            }
            if (id >= 2000 && id <= 2060) {
                int slider = id - 2000;
                turbine.setAutoMode(false);
                turbine.setPowerSliderPos(slider);
                return true;
            }
        }
        return super.m_6366_(player, id);
    }

    public static int sliderButtonId(int sliderValue) {
        return 2000 + sliderValue;
    }
}

