/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.gui.menu;

import com.hbm.blockentity.machine.IronCrateBlockEntity;
import com.hbm.gui.ModMenuType;
import com.hbm.registries.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class IronCrateMenu
extends AbstractContainerMenu {
    private static final int CRATE_ROWS = 4;
    private static final int CRATE_COLUMNS = 9;
    private static final int CRATE_SLOT_COUNT = 36;
    private static final int PLAYER_INV_OFFSET = 36;
    private static final int PLAYER_HOTBAR_OFFSET = 63;
    private static final int TOTAL_SLOTS = 72;
    private final IronCrateBlockEntity blockEntity;
    private final Level level;
    private final ItemStack crateSignature;

    public IronCrateMenu(int id, Inventory inventory, FriendlyByteBuf buf) {
        this(id, inventory, inventory.f_35978_.m_9236_().m_7702_(buf.m_130135_()));
    }

    public IronCrateMenu(int id, Inventory inventory, BlockEntity entity) {
        super((MenuType)ModMenuType.IRON_CRATE_MENU.get(), id);
        IronCrateBlockEntity crate;
        this.blockEntity = entity instanceof IronCrateBlockEntity ? (crate = (IronCrateBlockEntity)entity) : new IronCrateBlockEntity(BlockPos.f_121853_, ((Block)ModBlocks.crate_iron.get()).m_49966_());
        this.level = inventory.f_35978_.m_9236_();
        this.crateSignature = new ItemStack((ItemLike)ModBlocks.crate_iron.get());
        this.addCrateSlots(this.blockEntity, 8, 18);
        this.addPlayerInventory(inventory, 8, 104);
        this.addPlayerHotbar(inventory, 8, 162);
    }

    private void addCrateSlots(IronCrateBlockEntity crate, int startX, int startY) {
        crate.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            for (int row = 0; row < 4; ++row) {
                for (int col = 0; col < 9; ++col) {
                    int index = row * 9 + col;
                    this.m_38897_((Slot)new SlotItemHandler(handler, index, startX + col * 18, startY + row * 18));
                }
            }
        });
    }

    private void addPlayerInventory(Inventory inventory, int startX, int startY) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int index = col + row * 9 + 9;
                this.m_38897_(new ProtectedSlot(inventory, index, startX + col * 18, startY + row * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory inventory, int startX, int startY) {
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new ProtectedSlot(inventory, col, startX + col * 18, startY));
        }
    }

    public boolean m_6875_(@NotNull Player player) {
        return IronCrateMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)ModBlocks.crate_iron.get()));
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack empty = ItemStack.f_41583_;
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return empty;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copy = sourceStack.m_41777_();
        if (index < 36 ? !this.m_38903_(sourceStack, 36, 72, true) : !this.m_38903_(sourceStack, 0, 36, false)) {
            return empty;
        }
        if (sourceStack.m_41619_()) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(player, sourceStack);
        return copy;
    }

    private class ProtectedSlot
    extends Slot {
        public ProtectedSlot(Inventory inventory, int index, int x, int y) {
            super((Container)inventory, index, x, y);
        }

        public boolean m_8010_(Player player) {
            ItemStack stack = this.m_7993_();
            return !ItemStack.m_150942_((ItemStack)stack, (ItemStack)IronCrateMenu.this.crateSignature);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return !ItemStack.m_150942_((ItemStack)stack, (ItemStack)IronCrateMenu.this.crateSignature);
        }
    }
}

