/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.gui.menu;

import com.hbm.blockentity.machine.PWRControllerBlockEntity;
import com.hbm.gui.ModMenuType;
import com.hbm.gui.menu.BaseMachineMenu;
import com.hbm.gui.menu.slot.OutputSlot;
import com.hbm.item.pwr.ItemPWRFuel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class PWRMenu
extends BaseMachineMenu {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 1;
    public static final int SLOT_COOLANT = 2;
    public static final int DATA_COUNT = 14;

    public PWRMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, (Container)new SimpleContainer(3), (ContainerData)new SimpleContainerData(14));
    }

    public PWRMenu(int containerId, Inventory playerInventory, Container container, ContainerData data) {
        super((MenuType)ModMenuType.PWR_MENU.get(), containerId, container, data);
        this.slotNum = 3;
        this.m_38897_(new Slot(container, 0, 53, 5));
        this.m_38897_(new OutputSlot(container, 1, 89, 32));
        this.m_38897_(new Slot(container, 2, 8, 59));
        this.addPlayerSlot(playerInventory, 0, 22);
        this.m_38884_(data);
    }

    @Override
    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack current = slot.m_7993_();
            stack = current.m_41777_();
            if (index < this.slotNum) {
                if (!this.m_38903_(current, this.slotNum, this.slotNum + 36, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (current.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
                if (!this.m_38903_(current, 2, 3, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (ItemPWRFuel.isFreshFuel(current)) {
                if (!this.m_38903_(current, 0, 1, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                return ItemStack.f_41583_;
            }
            if (current.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return stack;
    }

    public boolean m_6366_(Player player, int id) {
        Container container = this.container;
        if (container instanceof PWRControllerBlockEntity) {
            PWRControllerBlockEntity controller = (PWRControllerBlockEntity)container;
            controller.setRodTarget(id);
            return true;
        }
        return super.m_6366_(player, id);
    }

    public int getCoreHeat() {
        return this.containerData.m_6413_(0);
    }

    public int getCoreHeatCapacity() {
        return this.containerData.m_6413_(1);
    }

    public int getHullHeat() {
        return this.containerData.m_6413_(2);
    }

    public int getHullHeatCapacity() {
        return this.containerData.m_6413_(3);
    }

    public int getFluxScaled() {
        return this.containerData.m_6413_(4);
    }

    public int getProgress() {
        return this.containerData.m_6413_(5);
    }

    public int getProcessTime() {
        return this.containerData.m_6413_(6);
    }

    public int getRodLevelScaled() {
        return this.containerData.m_6413_(7);
    }

    public int getRodTargetScaled() {
        return this.containerData.m_6413_(8);
    }

    public int getFuelType() {
        return this.containerData.m_6413_(9);
    }

    public int getFuelAmount() {
        return this.containerData.m_6413_(10);
    }

    public int getRodCount() {
        return this.containerData.m_6413_(11);
    }

    public int getCoolantAmount() {
        return this.containerData.m_6413_(12);
    }

    public int getHotCoolantAmount() {
        return this.containerData.m_6413_(13);
    }
}

