/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.gui.menu;

import com.hbm.blockentity.machine.rbmk.RBMKControlRodEntity;
import com.hbm.gui.ModMenuType;
import com.hbm.gui.menu.BaseMachineMenu;
import com.hbm.item.rbmk.ItemRBMKControlRod;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class RBMKControlRodMenu
extends BaseMachineMenu {
    private static final int BUTTON_LEVEL_BASE = 10;
    private static final int BUTTON_COLOR_BASE = 20;
    public static final int LEVEL_COUNT = 5;
    public static final int COLOR_COUNT = 5;
    private static final double[] LEVEL_STEPS = new double[]{1.0, 0.75, 0.5, 0.25, 0.0};
    public static final int COLOR_NONE = -1;

    public static int levelButtonId(int index) {
        return 10 + Math.max(0, Math.min(index, 4));
    }

    public static int colorButtonId(int index) {
        return 20 + Math.max(0, Math.min(index, 4));
    }

    public static double levelStepValue(int index) {
        return LEVEL_STEPS[Math.max(0, Math.min(index, LEVEL_STEPS.length - 1))];
    }

    public RBMKControlRodMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, (Container)new SimpleContainer(1), (ContainerData)new SimpleContainerData(14));
    }

    public RBMKControlRodMenu(int containerId, Inventory playerInventory, Container container, ContainerData data) {
        super((MenuType)ModMenuType.RBMK_CONTROL_ROD_MENU.get(), containerId, container, data);
        this.slotNum = 1;
        this.m_38897_(new Slot(container, 0, 80, 45){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof ItemRBMKControlRod;
            }
        });
        this.addPlayerSlot(playerInventory, -1, 19);
        this.m_38884_(data);
    }

    public boolean m_6366_(Player player, int id) {
        Container container = this.container;
        if (container instanceof RBMKControlRodEntity) {
            RBMKControlRodEntity controlRod = (RBMKControlRodEntity)container;
            if (id >= 10 && id < 15) {
                double target = LEVEL_STEPS[id - 10];
                controlRod.setInsertionFraction(target);
                return true;
            }
            if (id >= 20 && id < 25) {
                controlRod.toggleColorGroup(id - 20);
                return true;
            }
        }
        return super.m_6366_(player, id);
    }

    @Override
    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    public float getHeat() {
        return (float)this.containerData.m_6413_(0) / 10.0f;
    }

    public float getMeltdownThreshold() {
        return (float)this.containerData.m_6413_(1) / 10.0f;
    }

    public int getEnergyStored() {
        return this.containerData.m_6413_(2);
    }

    public int getEnergyCapacity() {
        return this.containerData.m_6413_(3);
    }

    public int getWaterAmount() {
        return this.containerData.m_6413_(4);
    }

    public int getSteamAmount() {
        return this.containerData.m_6413_(5);
    }

    public int getLocalControlPercent() {
        return this.containerData.m_6413_(6);
    }

    public int getGlobalControlPercent() {
        return this.containerData.m_6413_(7);
    }

    public int getInsertionPercent() {
        return this.containerData.m_6413_(8);
    }

    public int getInsertionLevel() {
        return this.containerData.m_6413_(9);
    }

    public int getColumnCount() {
        return this.containerData.m_6413_(10);
    }

    public boolean isAz5CoolingDown() {
        return this.containerData.m_6413_(11) > 0;
    }

    public int getAz5CooldownTicks() {
        return this.containerData.m_6413_(11);
    }

    public int getSelectedColor() {
        int value = this.containerData.m_6413_(12);
        return value >= 0 && value < 5 ? value : -1;
    }

    public boolean hasColumnData() {
        return this.containerData.m_6413_(1) > 0;
    }

    public boolean hasControlRodItem() {
        return this.containerData.m_6413_(13) > 0;
    }
}

